/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.client.texture.CanvasTexture;
import com.github.omoflop.crazypainting.network.c2s.SignPaintingC2S;
import com.github.omoflop.crazypainting.network.event.PaintingChangeEvent;
import com.github.omoflop.crazypainting.network.types.ChangeKey;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class NetSync {
    private final CanvasTexture texture;
    private final Runnable closeFunction;
    private final ChangeKey changeKey;
    private final AtomicBoolean hasChanges;
    private final int easelEntityId;
    private boolean closed = false;
    private int updateCooldown = 0;

    public NetSync(CanvasTexture texture, ChangeKey changeKey, Runnable closeFunction, AtomicBoolean hasChanges, int easelEntityId) {
        this.texture = texture;
        this.changeKey = changeKey;
        this.closeFunction = closeFunction;
        this.hasChanges = hasChanges;
        this.easelEntityId = easelEntityId;
    }

    public void tick() {
        if (!this.hasChanges.get()) {
            return;
        }
        --this.updateCooldown;
        if (this.updateCooldown <= 0) {
            this.updateCooldown = 20;
            this.hasChanges.set(false);
            this.sendChanges();
        }
    }

    public void sendChanges() {
        PaintingData data = this.texture.toData();
        if (data != null) {
            this.texture.updateTexture();
            ClientPlayNetworking.send((class_8710)new PaintingChangeEvent(Optional.of(this.changeKey), data, "", this.easelEntityId));
        } else {
            CrazyPainting.LOGGER.error("Failed to send painting change update packet");
        }
    }

    public void signAndClose(String title) {
        this.texture.updateTexture();
        PaintingData data = this.texture.toData();
        if (data == null) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new PaintingChangeEvent(Optional.of(this.changeKey), data, title, this.easelEntityId));
        ClientPlayNetworking.send((class_8710)new SignPaintingC2S(this.changeKey, data.id(), this.easelEntityId, title));
        this.closeFunction.run();
        this.closed = true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.sendChanges();
    }
}

