/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.components;

import com.github.omoflop.crazypainting.content.CrazyComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10104;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public record CanvasDataComponent(int id, boolean glow, String signedBy, String title, byte generation) implements class_9299
{
    public static final Codec<CanvasDataComponent> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("id").forGetter(CanvasDataComponent::id), (App)Codec.BOOL.fieldOf("glow").forGetter(CanvasDataComponent::glow), (App)Codec.STRING.fieldOf("signed_by").forGetter(CanvasDataComponent::signedBy), (App)Codec.STRING.fieldOf("title").forGetter(CanvasDataComponent::title), (App)Codec.BYTE.fieldOf("generation").forGetter(CanvasDataComponent::generation)).apply((Applicative)builder, CanvasDataComponent::new));
    public static final CanvasDataComponent DEFAULT = new CanvasDataComponent(-1, false, "", "Untitled Painting", 0);

    public static CanvasDataComponent withId(@Nullable CanvasDataComponent data, int id) {
        if (data == null) {
            data = DEFAULT;
        }
        return new CanvasDataComponent(id, data.glow, data.signedBy, data.title, data.generation);
    }

    public CanvasDataComponent withId(int id) {
        return new CanvasDataComponent(id, this.glow, this.signedBy, this.title, this.generation);
    }

    public CanvasDataComponent withGlow(boolean glow) {
        return new CanvasDataComponent(this.id, glow, this.signedBy, this.title, this.generation);
    }

    public CanvasDataComponent withSignedBy(String signedBy) {
        return new CanvasDataComponent(this.id, this.glow, signedBy, this.title, this.generation);
    }

    public CanvasDataComponent withTitle(String title) {
        return new CanvasDataComponent(this.id, this.glow, this.signedBy, title, this.generation);
    }

    public CanvasDataComponent withGeneration(byte generation) {
        return new CanvasDataComponent(this.id, this.glow, this.signedBy, this.title, generation);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        CanvasDataComponent data = (CanvasDataComponent)components.method_58694(CrazyComponents.CANVAS_DATA);
        assert (data != null);
        if (type.method_8035()) {
            textConsumer.accept((class_2561)class_2561.method_43470((String)("Canvas ID: " + data.id)).method_27692(class_124.field_1080));
        }
        if (data.signedBy != null && !data.signedBy.isEmpty()) {
            this.appendSignedByTooltip(data, textConsumer);
        }
    }

    private void appendSignedByTooltip(CanvasDataComponent data, Consumer<class_2561> textConsumer) {
        DataResult selector = class_10104.method_62667((String)data.signedBy);
        class_5250 arg = class_2561.method_43470((String)"Unknown");
        if (selector.isSuccess()) {
            arg = class_2561.method_43467((class_10104)((class_10104)selector.getOrThrow()), Optional.empty());
        }
        textConsumer.accept((class_2561)class_2561.method_43469((String)"item.crazypainting.canvas.tooltip.signed", (Object[])new Object[]{arg}).method_27692(class_124.field_1054));
        if (this.generation >= 0) {
            textConsumer.accept((class_2561)class_2561.method_43471((String)("book.generation." + this.generation)).method_27692(class_124.field_1080));
        }
    }
}

