/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.content;

import com.github.omoflop.crazypainting.network.c2s.RequestPaintingC2S;
import com.github.omoflop.crazypainting.network.c2s.SignPaintingC2S;
import com.github.omoflop.crazypainting.network.c2s.handlers.RequestPaintingServerHandler;
import com.github.omoflop.crazypainting.network.c2s.handlers.SignPaintingServerHandler;
import com.github.omoflop.crazypainting.network.event.PaintingChangeEvent;
import com.github.omoflop.crazypainting.network.event.ServerPaintingChangeEventHandler;
import com.github.omoflop.crazypainting.network.s2c.PaintingCanUpdateS2C;
import com.github.omoflop.crazypainting.network.s2c.PaintingUpdateS2C;
import com.github.omoflop.crazypainting.network.s2c.UpdateEaselCanvasIdS2C;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;

public class CrazyNetworking {
    public static void register() {
        PayloadTypeRegistry.playS2C().register(PaintingChangeEvent.ID, PaintingChangeEvent.CODEC);
        PayloadTypeRegistry.playS2C().register(PaintingUpdateS2C.ID, PaintingUpdateS2C.CODEC);
        PayloadTypeRegistry.playS2C().register(PaintingCanUpdateS2C.ID, PaintingCanUpdateS2C.CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateEaselCanvasIdS2C.ID, UpdateEaselCanvasIdS2C.CODEC);
        PayloadTypeRegistry.playC2S().register(PaintingChangeEvent.ID, PaintingChangeEvent.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestPaintingC2S.ID, RequestPaintingC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(SignPaintingC2S.ID, SignPaintingC2S.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PaintingChangeEvent.ID, (ServerPlayNetworking.PlayPayloadHandler)new ServerPaintingChangeEventHandler());
        ServerPlayNetworking.registerGlobalReceiver(RequestPaintingC2S.ID, (ServerPlayNetworking.PlayPayloadHandler)new RequestPaintingServerHandler());
        ServerPlayNetworking.registerGlobalReceiver(SignPaintingC2S.ID, (ServerPlayNetworking.PlayPayloadHandler)new SignPaintingServerHandler());
    }

    public static void savePainting(Path savePath, int id, PaintingData data, PaintingSize size) throws IOException {
        Files.createDirectory(savePath, new FileAttribute[0]);
        File pngFile = Files.createFile(savePath.resolve("painting_" + id + ".png"), new FileAttribute[0]).toFile();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(data.data()));
        ImageIO.write((RenderedImage)image, "PNG", pngFile);
    }

    public static byte[] loadPainting(Path rootPath, int id) throws IOException {
        return Files.readAllBytes(rootPath.resolve("painting_" + id + ".png"));
    }

    public static byte[] readByteArray(class_2540 buf) {
        int length = buf.readInt();
        ByteBuf bb = buf.readBytes(length);
        byte[] arr = new byte[bb.readableBytes()];
        bb.readBytes(arr);
        return arr;
    }

    public static void writeByteArray(class_2540 buf, byte[] bytes) {
        buf.method_53002(bytes.length);
        buf.method_52983(bytes);
    }
}

