/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.state;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.network.ChangeRecord;
import com.github.omoflop.crazypainting.network.s2c.PaintingCanUpdateS2C;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.network.types.PaintingId;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CanvasManager
extends class_18 {
    public static final Codec<CanvasManager> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("next_id").forGetter(self -> self.nextId)).apply((Applicative)builder, CanvasManager::new));
    private static final String OLD_ID = "crazypainting:canvas_manager";
    private static final String ID = "crazypainting_canvas_manager";
    public static final HashMap<UUID, ChangeRecord> CHANGE_IDS = new HashMap();
    private int nextId;

    public CanvasManager(int nextId) {
        this.nextId = nextId;
    }

    public static CanvasManager createNew() {
        return new CanvasManager(-1);
    }

    public int getNextId() {
        ++this.nextId;
        return this.nextId;
    }

    public static CanvasManager getServerState(MinecraftServer server) {
        class_10741 type = new class_10741(ID, CanvasManager::createNew, CODEC, null);
        Path dataDir = server.method_27050(class_5218.field_24188).resolve("data");
        File oldFile = new File(dataDir.toFile(), "crazypainting:canvas_manager.dat");
        Path newFile = dataDir.resolve("crazypainting_canvas_manager.dat");
        if (oldFile.exists() && !Files.exists(newFile, new LinkOption[0])) {
            CrazyPainting.LOGGER.info("Found old CanvasManager dat file, attempting to migrate");
            try {
                Files.move(oldFile.toPath(), newFile, new CopyOption[0]);
                CrazyPainting.LOGGER.info("Successfully migrated CanvasManager dat to new filename");
            }
            catch (IOException e) {
                CrazyPainting.LOGGER.error("Failed to migrate CanvasManager dat file, sticking with old one", (Throwable)e);
                type = new class_10741(OLD_ID, CanvasManager::createNew, CODEC, null);
            }
        }
        CanvasManager canvasManager = (CanvasManager)Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_17983().method_17924(type);
        canvasManager.method_80();
        return canvasManager;
    }

    public static PaintingData createOrLoad(int canvasId, PaintingSize size, MinecraftServer server) throws IOException {
        PaintingData data = CanvasManager.load(canvasId, server);
        if (data == null) {
            return new PaintingData(CanvasManager.createEmptyImage(size), size, new PaintingId(canvasId));
        }
        return data;
    }

    @Nullable
    public static PaintingData load(int canvasId, MinecraftServer server) throws IOException {
        Path savePath = server.method_27050(class_5218.field_24188).resolve("data/crazy_paintings");
        Files.createDirectories(savePath, new FileAttribute[0]);
        Path paintingPath = savePath.resolve("painting_" + canvasId + ".qoi");
        Optional<byte[]> bytes = CanvasManager.tryRead(paintingPath);
        if (bytes.isEmpty()) {
            return null;
        }
        BufferedImage img = ImageIO.read(paintingPath.toFile());
        CrazyPainting.debug("Loaded painting id: {} of size {} x {}", canvasId, img.getWidth(), img.getHeight());
        PaintingSize size = PaintingSize.fromPixels(img.getWidth(), img.getHeight());
        return new PaintingData(bytes.get(), size, new PaintingId(canvasId));
    }

    private static Optional<byte[]> tryRead(Path path) {
        try {
            return Optional.of(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static byte[] createEmptyImage(PaintingSize size) {
        BufferedImage img = new BufferedImage(size.width() * 16, size.height() * 16, 2);
        int[] pixels = new int[img.getWidth() * img.getHeight()];
        Arrays.fill(pixels, -393218);
        img.setRGB(0, 0, size.width() * 16, size.height() * 16, pixels, 0, size.width() * 16);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "qoi", out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void receive(PaintingData data, MinecraftServer server, class_3222 sender) throws IOException {
        Path savePath = server.method_27050(class_5218.field_24188).resolve("data/crazy_paintings");
        Files.createDirectories(savePath, new FileAttribute[0]);
        Path paintingPath = savePath.resolve("painting_" + data.id().value() + ".qoi");
        Files.write(paintingPath, data.data(), new OpenOption[0]);
        for (class_3222 player : sender.method_51469().method_18456()) {
            if (player.equals((Object)sender)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PaintingCanUpdateS2C(data.id().value()));
        }
        CrazyPainting.debug("Sent out an update packet to all players except one", new Object[0]);
    }
}

