/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.datagen;

import com.github.omoflop.crazypainting.content.CrazyItems;
import com.github.omoflop.crazypainting.items.CanvasItem;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;

@Environment(value=EnvType.CLIENT)
public class CrazyRecipeProvider
extends FabricRecipeProvider {
    public CrazyRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 exporter) {
        return new class_2446(this, wrapperLookup, exporter){

            public void method_10419() {
                this.method_62749(class_7800.field_40638, (class_1935)CrazyItems.PALETTE_ITEM).method_10446(class_3489.field_15534).method_10442(1.method_32807((class_1935)class_1802.field_8320), this.method_10420(class_3489.field_15534)).method_10431(this.field_53721);
                this.method_62746(class_7800.field_40635, (class_1935)CrazyItems.SMALL_CANVAS_ITEM).method_10439("///").method_10439("/p/").method_10439("///").method_10434(Character.valueOf('p'), (class_1935)class_1802.field_8407).method_10434(Character.valueOf('/'), (class_1935)class_1802.field_8600).method_10429(1.method_32807((class_1935)CrazyItems.PALETTE_ITEM), this.method_10426((class_1935)CrazyItems.PALETTE_ITEM)).method_10431(this.field_53721);
                this.method_62746(class_7800.field_40635, (class_1935)CrazyItems.EASEL_ITEM).method_10439(" / ").method_10439(" / ").method_10439("/_/").method_10434(Character.valueOf('_'), (class_1935)class_1802.field_8291).method_10434(Character.valueOf('/'), (class_1935)class_1802.field_8600).method_10429(1.method_32807((class_1935)class_1802.field_8600), this.method_10426((class_1935)class_1802.field_8600)).method_10431(this.field_53721);
                for (CanvasItem canvas : CrazyItems.allCanvases) {
                    if (canvas == CrazyItems.SMALL_CANVAS_ITEM) continue;
                    this.offerCanvas(canvas, this.field_53721);
                }
            }

            public void offerCanvas(CanvasItem targetCanvas, class_8790 exporter) {
                byte targetWidth = targetCanvas.width;
                byte targetHeight = targetCanvas.height;
                Object[] pattern = new String[targetHeight];
                Arrays.fill(pattern, "@".repeat(Math.max(0, targetWidth)));
                class_2447 builder = this.method_62746(class_7800.field_40635, (class_1935)targetCanvas);
                for (Object patternRow : pattern) {
                    builder.method_10439((String)patternRow);
                }
                builder.method_10434(Character.valueOf('@'), (class_1935)CrazyItems.SMALL_CANVAS_ITEM).method_10429(1.method_32807((class_1935)CrazyItems.PALETTE_ITEM), this.method_10426((class_1935)CrazyItems.PALETTE_ITEM)).method_10435(this.getCanvasName(targetCanvas)).method_36443(exporter, this.getCanvasName(targetCanvas) + "_from_small_canvas");
                for (CanvasItem sourceCanvas : CrazyItems.allCanvases) {
                    int canvasesNeeded;
                    if (sourceCanvas == targetCanvas || sourceCanvas == CrazyItems.SMALL_CANVAS_ITEM) continue;
                    byte sourceWidth = sourceCanvas.width;
                    byte sourceHeight = sourceCanvas.height;
                    if (targetHeight == sourceHeight && targetWidth % sourceWidth == 0 && (canvasesNeeded = targetWidth / sourceWidth) <= 3 && canvasesNeeded > 1) {
                        this.method_62746(class_7800.field_40635, (class_1935)targetCanvas).method_10439("@".repeat(canvasesNeeded)).method_10434(Character.valueOf('@'), (class_1935)sourceCanvas).method_10429(1.method_32807((class_1935)CrazyItems.PALETTE_ITEM), this.method_10426((class_1935)CrazyItems.PALETTE_ITEM)).method_10435(this.getCanvasName(targetCanvas)).method_36443(exporter, this.getCanvasName(targetCanvas) + "_from_" + this.getCanvasName(sourceCanvas) + "_horizontal");
                    }
                    if (targetWidth == sourceWidth && targetHeight % sourceHeight == 0 && (canvasesNeeded = targetHeight / sourceHeight) <= 3 && canvasesNeeded > 1) {
                        class_2447 verticalBuilder = this.method_62746(class_7800.field_40635, (class_1935)targetCanvas);
                        for (int i = 0; i < canvasesNeeded; ++i) {
                            verticalBuilder.method_10439("@");
                        }
                        verticalBuilder.method_10434(Character.valueOf('@'), (class_1935)sourceCanvas).method_10429(1.method_32807((class_1935)CrazyItems.PALETTE_ITEM), this.method_10426((class_1935)CrazyItems.PALETTE_ITEM)).method_10435(this.getCanvasName(targetCanvas)).method_36443(exporter, this.getCanvasName(targetCanvas) + "_from_" + this.getCanvasName(sourceCanvas) + "_vertical");
                    }
                    if (targetWidth % sourceWidth != 0 || targetHeight % sourceHeight != 0) continue;
                    int horizontalCount = targetWidth / sourceWidth;
                    int verticalCount = targetHeight / sourceHeight;
                    int totalCanvases = horizontalCount * verticalCount;
                    if (horizontalCount > 3 || verticalCount > 3 || totalCanvases <= 1 || totalCanvases > 9 || verticalCount == 1 || horizontalCount == 1) continue;
                    StringBuilder gridRow = new StringBuilder();
                    gridRow.append("@".repeat(Math.max(0, horizontalCount)));
                    class_2447 gridBuilder = this.method_62746(class_7800.field_40635, (class_1935)targetCanvas);
                    for (int i = 0; i < verticalCount; ++i) {
                        gridBuilder.method_10439(gridRow.toString());
                    }
                    gridBuilder.method_10434(Character.valueOf('@'), (class_1935)sourceCanvas).method_10429(1.method_32807((class_1935)CrazyItems.PALETTE_ITEM), this.method_10426((class_1935)CrazyItems.PALETTE_ITEM)).method_10435(this.getCanvasName(targetCanvas)).method_36443(exporter, this.getCanvasName(targetCanvas) + "_from_" + this.getCanvasName(sourceCanvas) + "_grid");
                }
            }

            private String getCanvasName(CanvasItem canvas) {
                String name = canvas.getId().method_12832().toLowerCase();
                if (name.isEmpty()) {
                    return canvas.width + "x" + canvas.height;
                }
                return name;
            }
        };
    }

    public String method_10321() {
        return "CrazyPaintingRecipeProvider";
    }
}

