/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.widgets;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.client.ColorHelper;
import com.github.omoflop.crazypainting.client.CrazyPaintingClient;
import com.github.omoflop.crazypainting.client.screens.PaintingEditorScreen;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorState;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorWidget;
import com.github.omoflop.crazypainting.client.screens.editor.types.MouseListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.Renderable;
import java.util.Collection;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ColorPickerWidget
extends EditorWidget
implements Renderable,
MouseListener {
    private static final class_2561 PALETTE_TEXT = class_2561.method_43471((String)"gui.crazypainting.palette");
    private static final class_2561 PALETTE_EMPTY_TEXT = class_2561.method_43471((String)"gui.crazypainting.palette.empty");
    private final EditorState state;
    private final Collection<Integer> colors;
    private final class_327 textRenderer;
    private boolean leftJustPressed = false;
    private boolean rightJustPressed = false;

    public ColorPickerWidget(EditorState state, Collection<Integer> colors) {
        this.state = state;
        this.colors = colors;
        this.textRenderer = class_310.method_1551().field_1772;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int n = this.centerX();
        int n2 = this.top();
        Objects.requireNonNull(this.textRenderer);
        context.method_27534(this.textRenderer, PALETTE_TEXT, n, n2 - 9, -75715);
        if (this.colors.isEmpty()) {
            context.method_51440(this.textRenderer, (class_5348)PALETTE_EMPTY_TEXT, this.x, this.y, this.width, -5231066, false);
            return;
        }
        this.drawPalette(context, mouseX, mouseY);
        this.drawBottomArea(context);
        this.leftJustPressed = false;
        this.rightJustPressed = false;
    }

    private void drawBottomArea(class_332 context) {
        class_5250 text;
        Objects.requireNonNull(this.textRenderer);
        int size = (int)(9.0f * 1.5f);
        int y2 = this.bottom() - size * 2;
        if (this.colors.contains(this.state.primaryColor) || CrazyPainting.isNotVanillaColor(this.state.primaryColor)) {
            text = class_2561.method_43470((String)ColorHelper.hexString(this.state.primaryColor));
            this.drawColorBox(context, this.x, y2, this.width, size, -6447721, this.state.primaryColor);
            context.method_51439(this.textRenderer, (class_2561)text, this.x + this.width / 2 - this.textRenderer.method_27525((class_5348)text) / 2, y2 + 3, ColorHelper.contrast(this.state.primaryColor), false);
        }
        if (this.colors.contains(this.state.secondaryColor) || CrazyPainting.isNotVanillaColor(this.state.secondaryColor)) {
            text = class_2561.method_43470((String)ColorHelper.hexString(this.state.secondaryColor));
            this.drawColorBox(context, this.x, y2 += size, this.width, size, -12103854, this.state.secondaryColor);
            context.method_51439(this.textRenderer, (class_2561)text, this.x + this.width / 2 - this.textRenderer.method_27525((class_5348)text) / 2, y2 + 3, ColorHelper.contrast(this.state.secondaryColor), false);
        }
    }

    private void drawPalette(class_332 context, int mouseX, int mouseY) {
        int size = 12;
        int xx = this.x + 2;
        int yy = this.y + 2;
        for (int color : this.colors) {
            if (this.drawPaletteBox(context, mouseX, mouseY, xx, yy, 12, 12, color)) {
                if (color != this.state.primaryColor && this.leftJustPressed) {
                    this.state.primaryColor = color;
                    CrazyPaintingClient.click(2.0f);
                }
                if (color != this.state.secondaryColor && this.rightJustPressed) {
                    this.state.secondaryColor = color;
                    CrazyPaintingClient.click(1.7f);
                }
            }
            if ((xx += 12) + 12 < this.right()) continue;
            xx = this.x + 2;
            yy += 12;
        }
        for (int i = 4; i > 0; --i) {
            int ii = 4 - i;
            float opacity = (float)(i * 25) / 100.0f;
            if (!this.drawOpacityBox(context, mouseX, mouseY, this.x + 12 * ii + 2, yy + 24, 12, 12, opacity) || !this.leftJustPressed || this.state.opacity == opacity) continue;
            this.leftJustPressed = false;
            CrazyPaintingClient.click(opacity + 0.5f);
            this.state.opacity = opacity;
        }
        if (this.drawToolBox(context, mouseX, mouseY, this.x + 2, yy + 48, 13, 13, this.state.colorPickerActive, 16, 16, 7, 7) && this.leftJustPressed) {
            this.state.setColorPicker(!this.state.colorPickerActive);
        }
    }

    private boolean drawOpacityBox(class_332 context, int mouseX, int mouseY, int x, int y, int width, int height, float opacity) {
        int backgroundColor;
        boolean isSelected = this.state.opacity == opacity;
        boolean isMouseOver = mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
        int borderColor = -14869215;
        if (isSelected) {
            borderColor = -393218;
        }
        int n = backgroundColor = isMouseOver ? -393218 : 0;
        if (opacity != 1.0f) {
            context.method_25294(x + 2, y + 2, x + width - 2, y + height - 2, -393218);
        }
        this.drawColorBox(context, x, y, width, height, borderColor, ColorHelper.setOpacity(-14869215, opacity), backgroundColor);
        if (isMouseOver) {
            context.method_51438(this.textRenderer, (class_2561)class_2561.method_43469((String)"gui.crazypainting.painting_editor.opacity", (Object[])new Object[]{(int)Math.floor(opacity * 100.0f) + "%"}), mouseX, mouseY);
        }
        return isMouseOver;
    }

    private boolean drawPaletteBox(class_332 context, int mouseX, int mouseY, int x, int y, int width, int height, int color) {
        int backgroundColor;
        boolean isPrimary = color == this.state.primaryColor;
        boolean isSecondary = color == this.state.secondaryColor;
        boolean isMouseOver = mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
        int borderColor = -14869215;
        if (isPrimary) {
            borderColor = -393218;
        }
        if (isSecondary) {
            borderColor = -6447721;
        }
        int n = backgroundColor = color == -393218 ? -6447721 : -393218;
        if (!isMouseOver) {
            backgroundColor = 0;
        }
        this.drawColorBox(context, x, y, width, height, borderColor, color, backgroundColor);
        return isMouseOver;
    }

    private boolean drawToolBox(class_332 context, int mouseX, int mouseY, int x, int y, int width, int height, boolean selected, int u, int v, int w, int h) {
        boolean isMouseOver = mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
        int borderColor = selected ? -393218 : -14869215;
        int backgroundColor = -6447721;
        if (!isMouseOver) {
            backgroundColor = 0;
        }
        this.drawColorBox(context, x, y, width, height, borderColor, -393218, backgroundColor);
        context.method_25290(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, x + width / 2 - w / 2, y + height / 2 - h / 2, (float)u, (float)v, w, h, 64, 64);
        return isMouseOver;
    }

    private void drawColorBox(class_332 context, int x, int y, int width, int height, int borderColor, int innerColor, int backgroundColor) {
        context.method_49601(x, y, width, height, borderColor);
        if (backgroundColor != 0) {
            context.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, backgroundColor);
        }
        if (innerColor == 0) {
            context.method_25294(x + 2, y + 2, x + width - 2, y + height - 2, -12103854);
            context.method_25294(x + 2, y + 2, x + width / 2, y + height / 2, -6447721);
            context.method_25294(x + width / 2, y + height / 2, x + width - 2, y + height - 2, -6447721);
        } else {
            context.method_25294(x + 2, y + 2, x + width - 2, y + height - 2, innerColor);
        }
    }

    private void drawColorBox(class_332 context, int x, int y, int width, int height, int borderColor, int innerColor) {
        this.drawColorBox(context, x, y, width, height, borderColor, innerColor, 0);
    }

    @Override
    public boolean onMousePressed(double mouseX, double mouseY, int button) {
        if (!this.containsPoint(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            this.leftJustPressed = true;
        }
        if (button == 1) {
            this.rightJustPressed = true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }
}

