/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.components;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.content.CrazyComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record PaletteColorsComponent(List<Integer> colors) implements class_9299
{
    public static final Codec<PaletteColorsComponent> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)Codec.INT).fieldOf("colors").forGetter(PaletteColorsComponent::colors)).apply((Applicative)builder, PaletteColorsComponent::new));

    public static PaletteColorsComponent empty() {
        return new PaletteColorsComponent(new ArrayList<Integer>());
    }

    public static void sort(ArrayList<Integer> palette) {
        List<Integer> colors = Arrays.stream(CrazyPainting.VANILLA_COLOR_ORDER).boxed().toList();
        palette.sort((a, b) -> {
            int aIndex = 10000;
            int bIndex = 10000;
            if (colors.contains(a)) {
                aIndex = colors.indexOf(a);
                bIndex = colors.indexOf(b);
            }
            return aIndex - bIndex;
        });
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        PaletteColorsComponent data = (PaletteColorsComponent)components.method_58694(CrazyComponents.PALETTE_COLORS);
        assert (data != null);
        if (data.colors == null || data.colors.isEmpty()) {
            textConsumer.accept((class_2561)class_2561.method_43471((String)"item.crazypainting.palette.tooltip.empty").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            return;
        }
        class_5250 text = class_2561.method_43471((String)"item.crazypainting.palette.tooltip.colors").method_27693(": ").method_27692(class_124.field_1078);
        for (int i = 0; i < data.colors.size(); ++i) {
            int color = data.colors.get(i);
            if (color == 0) {
                text.method_10852((class_2561)class_2561.method_43471((String)"item.crazypainting.palette.tooltip.color_entry.transparent").method_27692(class_124.field_1068));
                continue;
            }
            text.method_10852((class_2561)class_2561.method_43471((String)"item.crazypainting.palette.tooltip.color_entry").method_54663(data.colors.get(i).intValue()));
        }
        textConsumer.accept((class_2561)text);
    }
}

