/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.entities;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.components.CanvasDataComponent;
import com.github.omoflop.crazypainting.content.CrazyComponents;
import com.github.omoflop.crazypainting.content.CrazyItems;
import com.github.omoflop.crazypainting.items.CanvasItem;
import com.github.omoflop.crazypainting.items.PaletteItem;
import com.github.omoflop.crazypainting.network.ChangeRecord;
import com.github.omoflop.crazypainting.network.event.PaintingChangeEvent;
import com.github.omoflop.crazypainting.network.s2c.UpdateEaselCanvasIdS2C;
import com.github.omoflop.crazypainting.network.types.ChangeKey;
import com.github.omoflop.crazypainting.network.types.PaintingId;
import com.github.omoflop.crazypainting.state.CanvasManager;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EaselEntity
extends class_1309 {
    public static final class_2940<class_1799> CANVAS_ITEM = class_2945.method_12791(EaselEntity.class, (class_2941)class_2943.field_13322);
    public long lastHitTime;

    public EaselEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132 createAttributes() {
        return EaselEntity.method_26827().method_26868(class_5134.field_23716, 4.0).method_26866();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(CANVAS_ITEM, (Object)class_1799.field_8037);
        super.method_5693(builder);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        class_1799 displayStack = this.getDisplayStack();
        class_1799 playerHeldStack = player.method_5998(hand);
        boolean displayItemIsCanvas = displayStack.method_7909() instanceof CanvasItem;
        if (displayStack.method_7960() && playerHeldStack.method_7960()) {
            return class_1269.field_5814;
        }
        if (displayItemIsCanvas && this.checkInk(playerHeldStack, displayStack, player)) {
            return class_1269.field_5812;
        }
        if (displayStack.method_7960()) {
            if (!playerHeldStack.method_7960()) {
                this.setDisplayStack(playerHeldStack.method_7972());
                player.method_6122(hand, class_1799.field_8037);
            }
        } else if (!displayItemIsCanvas || player.method_5715()) {
            if (hand == class_1268.field_5808 && playerHeldStack.method_7960()) {
                player.method_6122(hand, displayStack);
                this.setDisplayStack(class_1799.field_8037);
            }
        } else {
            class_1792 class_17922 = displayStack.method_7909();
            if (class_17922 instanceof CanvasItem) {
                int canvasId;
                boolean hasPaletteInEitherHand;
                CanvasItem canvasItem = (CanvasItem)class_17922;
                if (!(player instanceof class_3222)) {
                    return class_1269.field_5812;
                }
                class_3222 serverPlayer = (class_3222)player;
                boolean edit = hasPaletteInEitherHand = player.method_5998(class_1268.field_5808).method_7909() instanceof PaletteItem || player.method_5998(class_1268.field_5810).method_7909() instanceof PaletteItem;
                if (CanvasItem.isSigned(displayStack)) {
                    edit = false;
                }
                if ((canvasId = CanvasItem.getCanvasId(displayStack)) == -1 && hasPaletteInEitherHand) {
                    canvasId = CanvasManager.getServerState(Objects.requireNonNull(serverPlayer.method_5682())).getNextId();
                    displayStack.method_57379(CrazyComponents.CANVAS_DATA, (Object)CanvasDataComponent.withId((CanvasDataComponent)displayStack.method_58694(CrazyComponents.CANVAS_DATA), canvasId));
                    edit = true;
                }
                Optional<ChangeKey> change = Optional.empty();
                if (edit) {
                    ChangeRecord changeRecord = new ChangeRecord(ChangeKey.create(), new PaintingId(canvasId));
                    change = Optional.of(changeRecord.key());
                    CanvasManager.CHANGE_IDS.put(serverPlayer.method_5667(), changeRecord);
                }
                try {
                    MinecraftServer server = Objects.requireNonNull(serverPlayer.method_5682());
                    PaintingChangeEvent changeEvent = new PaintingChangeEvent(change, CanvasManager.createOrLoad(canvasId, canvasItem.getSize(), server), CanvasItem.getTitle(displayStack), this.method_5628());
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)changeEvent);
                    for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new UpdateEaselCanvasIdS2C(this.method_5628(), new PaintingId(canvasId)));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return super.method_5688(player, hand);
    }

    private boolean checkInk(class_1799 playerHeldStack, class_1799 displayStack, class_1657 player) {
        boolean holdingUnGlowItem;
        boolean holdingGlowItem = playerHeldStack.method_7909() == CrazyPainting.GLOW_ITEM;
        boolean bl = holdingUnGlowItem = playerHeldStack.method_7909() == CrazyPainting.UNGLOW_ITEM;
        if (holdingGlowItem || holdingUnGlowItem) {
            CanvasDataComponent data = (CanvasDataComponent)displayStack.method_58694(CrazyComponents.CANVAS_DATA);
            boolean success = false;
            if (data == null) {
                data = CanvasDataComponent.DEFAULT.withGlow(holdingGlowItem);
                success = true;
            } else if (data.glow() == holdingUnGlowItem) {
                data = data.withGlow(holdingGlowItem);
                success = true;
            }
            if (success) {
                displayStack.method_57379(CrazyComponents.CANVAS_DATA, (Object)data);
                player.method_56078(holdingGlowItem ? class_3417.field_28392 : class_3417.field_28397);
                playerHeldStack.method_57008(1, (class_1309)player);
                return true;
            }
        }
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    public boolean method_5810() {
        return false;
    }

    public class_2561 method_5476() {
        return this.method_5998(class_1268.field_5808).method_63015();
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    protected void method_6031(float bodyRotation) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
    }

    public void method_5636(float bodyYaw) {
        this.field_6220 = this.field_5982 = bodyYaw;
        this.field_6259 = this.field_6241 = bodyYaw;
    }

    public void method_5847(float headYaw) {
        this.field_6220 = this.field_5982 = headYaw;
        this.field_6259 = this.field_6241 = headYaw;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (this.method_31481()) {
            return false;
        }
        if (!world.method_64395().method_8355(class_1928.field_19388) && source.method_5529() instanceof class_1308) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (!this.method_5679(world, source)) {
            if (source.method_48789(class_8103.field_42249)) {
                this.breakAndDropItem(world, source);
                this.method_5650(class_1297.class_5529.field_26998);
                return false;
            }
            if (source.method_48789(class_8103.field_42258)) {
                if (this.method_5809()) {
                    this.updateHealth(world, source, 0.15f);
                } else {
                    this.method_5639(5.0f);
                }
                return false;
            }
            if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
                this.updateHealth(world, source, 4.0f);
                return false;
            }
            boolean bl = source.method_48789(class_8103.field_46230);
            boolean bl2 = source.method_48789(class_8103.field_46211);
            if (!bl && !bl2) {
                return false;
            }
            class_1297 attacker = source.method_5529();
            if (attacker instanceof class_1657) {
                class_1657 playerEntity = (class_1657)attacker;
                if (!playerEntity.method_31549().field_7476) {
                    return false;
                }
            }
            if (source.method_5530()) {
                this.playBreakSound();
                this.spawnBreakParticles();
                this.method_5650(class_1297.class_5529.field_26998);
                return true;
            }
            long l = world.method_8510();
            if (l - this.lastHitTime > 5L && !bl2) {
                world.method_8421((class_1297)this, (byte)32);
                this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
                this.lastHitTime = l;
            } else {
                this.breakAndDropItem(world, source);
                this.spawnBreakParticles();
                this.method_5650(class_1297.class_5529.field_26998);
            }
            return true;
        }
        return false;
    }

    public void method_5711(byte status) {
        if (status == 32) {
            if (this.method_37908().field_9236) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHitTime = this.method_37908().method_8510();
            }
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_5640(double distance) {
        double d = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d) || d == 0.0) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    private void spawnBreakParticles() {
        if (this.method_37908() instanceof class_3218) {
            ((class_3218)this.method_37908()).method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void updateHealth(class_3218 world, class_1282 damageSource, float amount) {
        float f = this.method_6032();
        if ((f -= amount) <= 0.5f) {
            this.breakAndDropItem(world, damageSource);
            this.method_5768(world);
        } else {
            this.method_6033(f);
            this.method_32875((class_6880)class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void breakAndDropItem(class_3218 world, class_1282 damageSource) {
        class_1799 itemStack = new class_1799((class_1935)CrazyItems.EASEL_ITEM);
        itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)itemStack);
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)this.getDisplayStack());
        this.onBreak(world, damageSource);
    }

    private void onBreak(class_3218 world, class_1282 damageSource) {
        this.playBreakSound();
        this.method_16080(world, damageSource);
    }

    @Nullable
    public class_1799 method_31480() {
        class_1799 display = this.getDisplayStack();
        if (display.method_7960()) {
            return new class_1799((class_1935)CrazyItems.EASEL_ITEM);
        }
        return display.method_7972();
    }

    private void playBreakSound() {
        this.method_37908().method_43128((class_1297)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15118, this.method_5634(), 1.0f, 1.0f);
    }

    public class_1799 getDisplayStack() {
        return (class_1799)this.field_6011.method_12789(CANVAS_ITEM);
    }

    public void setDisplayStack(class_1799 value) {
        this.setAsStackHolder(value);
        this.method_5841().method_12778(CANVAS_ITEM, (Object)value);
    }

    private void setAsStackHolder(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7945() == null) {
            stack.method_27320((class_1297)this);
        }
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        class_1799 itemStack = this.getDisplayStack();
        if (!itemStack.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, (Object)itemStack);
        }
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        class_1799 itemStack = view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        this.setDisplayStack(itemStack);
    }
}

