/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.types;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class EditorWidget {
    public int x;
    public int y;
    public int width;
    public int height;

    public int top() {
        return this.y;
    }

    public int left() {
        return this.x;
    }

    public int right() {
        return this.x + this.width;
    }

    public int bottom() {
        return this.y + this.height;
    }

    public void calculateSize(int screenWidth, int screenHeight) {
    }

    public int centerX() {
        return this.x + this.width / 2;
    }

    public int centerY() {
        return this.y + this.height / 2;
    }

    public void alignXCenter(int screenWidth) {
        this.x = screenWidth / 2 - this.width / 2;
    }

    public void alignXBetween(int pointA, int pointB) {
        this.x = (pointB - pointA) / 2 - this.width / 2 + pointA;
    }

    public void alignYCenter(int screenHeight) {
        this.y = screenHeight / 2 - this.height / 2;
    }

    public void alignXRight(int distanceFromRight, int screenWidth) {
        this.x = screenWidth - this.width - distanceFromRight;
    }

    public void alignXLeft(int distanceFromLeft) {
        this.x = distanceFromLeft;
    }

    public boolean containsPoint(double px, double py) {
        return (double)this.x <= px && (double)this.y <= py && (double)this.right() > px && (double)this.bottom() > py;
    }
}

