/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.widgets;

import com.github.omoflop.crazypainting.client.ColorHelper;
import com.github.omoflop.crazypainting.client.CrazyPaintingClient;
import com.github.omoflop.crazypainting.client.screens.PaintingEditorScreen;
import com.github.omoflop.crazypainting.client.screens.editor.types.DrawHelper;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorState;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorWidget;
import com.github.omoflop.crazypainting.client.screens.editor.types.KeyListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.MouseListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.Renderable;
import com.github.omoflop.crazypainting.client.screens.editor.types.Tickable;
import com.github.omoflop.crazypainting.client.texture.CanvasTexture;
import com.github.omoflop.crazypainting.content.CrazySounds;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class CanvasWidget
extends EditorWidget
implements Renderable,
MouseListener,
KeyListener,
Tickable {
    private final EditorState state;
    private final CanvasTexture texture;
    private final DrawHelper drawHelper;
    public int zoom = 10;
    public boolean panStart;
    public int panX;
    public int panY;
    public double panOffsetX;
    public double panOffsetY;
    public boolean leftDown = false;
    public boolean rightDown = false;
    private boolean leftJustDown;
    private boolean rightJustDown;

    public CanvasWidget(EditorState state, CanvasTexture texture, AtomicBoolean hasChanges) {
        this.state = state;
        this.texture = texture;
        this.drawHelper = new DrawHelper(state, texture, hasChanges);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        boolean mouseInCanvas;
        context.method_49601(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -14869215);
        context.method_44379(this.x, this.y, this.right(), this.bottom());
        for (int i = 0; i < this.texture.pixels.length; ++i) {
            int drawX = this.x + i % this.texture.width * this.zoom;
            int drawY = this.y + i / this.texture.width * this.zoom;
            context.method_25294(drawX + this.panX, drawY + this.panY, drawX + this.zoom + this.panX, drawY + this.zoom + this.panY, this.texture.pixels[i]);
        }
        int cursorX = (mouseX - (this.x + this.panX)) / this.zoom;
        int cursorY = (mouseY - (this.y + this.panY)) / this.zoom;
        boolean bl = mouseInCanvas = cursorX >= 0 && cursorY >= 0 && cursorX < this.texture.width && cursorY < this.texture.height;
        if (mouseInCanvas) {
            if (this.state.colorPickerActive) {
                int cursorDrawX = this.x + this.panX + cursorX * this.zoom;
                int cursorDrawY = this.y + this.panY + cursorY * this.zoom;
                int hoveredColor = this.texture.pixels[cursorX + cursorY * this.texture.width];
                context.method_49601(cursorDrawX, cursorDrawY, this.zoom, this.zoom, ColorHelper.contrast(hoveredColor));
            } else {
                this.state.brushType.iteratePatternCentered(cursorX, cursorY, (px, py, ignored) -> {
                    if (!this.texture.isPixelInBounds(px, py)) {
                        return;
                    }
                    int cursorDrawX = this.x + this.panX + px * this.zoom;
                    int cursorDrawY = this.y + this.panY + py * this.zoom;
                    int hoveredColor = this.texture.pixels[px + py * this.texture.width];
                    context.method_49601(cursorDrawX, cursorDrawY, this.zoom, this.zoom, ColorHelper.contrast(hoveredColor));
                });
            }
            if (this.leftDown || this.rightDown) {
                if (this.state.colorPickerActive) {
                    if (this.leftJustDown) {
                        this.state.primaryColor = this.texture.pixels[cursorX + cursorY * this.texture.width];
                        CrazyPaintingClient.play(CrazySounds.COLOR_PICKER_USE, 1.0f);
                    } else if (this.rightJustDown) {
                        this.state.secondaryColor = this.texture.pixels[cursorX + cursorY * this.texture.width];
                        CrazyPaintingClient.play(CrazySounds.COLOR_PICKER_USE, 1.0f);
                    }
                } else {
                    this.drawHelper.useBrush(cursorX, cursorY, this.leftDown ? this.state.primaryColor : this.state.secondaryColor, this.state.opacity);
                }
            }
        }
        context.method_44380();
        if (this.panStart) {
            this.panX = (int)((double)mouseX - this.panOffsetX);
            this.panY = (int)((double)mouseY - this.panOffsetY);
            context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX - 8, mouseY - 8, 32.0f, 32.0f, 16, 16, 64, 64, -1);
            GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212994);
        } else if (this.containsPoint(mouseX, mouseY) && mouseInCanvas) {
            if (this.state.colorPickerActive) {
                context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX, mouseY - 16, 16.0f, 32.0f, 16, 16, 64, 64, -1);
                context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX, mouseY - 16, 0.0f, 32.0f, 16, 16, 64, 64, this.state.primaryColor);
            } else {
                context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX, mouseY, 16.0f, 0.0f, 16, 16, 64, 64, -1);
                if (this.state.primaryColor == 0 || this.state.primaryColor == -1) {
                    context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX, mouseY, 0.0f, 16.0f, 16, 16, 64, 64, -14869215);
                } else {
                    context.method_25291(class_10799.field_56883, PaintingEditorScreen.EDITOR_TEXTURE_ID, mouseX, mouseY, 0.0f, 0.0f, 16, 16, 64, 64, this.state.primaryColor);
                }
            }
            GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212994);
        } else {
            GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212993);
        }
        this.leftJustDown = false;
        this.rightJustDown = false;
    }

    @Override
    public void calculateSize(int screenWidth, int screenHeight) {
        this.width = Math.min(this.texture.width * 10, screenWidth / 2);
        this.height = Math.min(this.texture.height * 10, screenHeight - 64);
    }

    @Override
    public boolean onMousePressed(double mouseX, double mouseY, int button) {
        if (!this.containsPoint(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            this.leftDown = true;
            this.leftJustDown = true;
            this.drawHelper.beginStroke();
        } else if (button == 1) {
            this.rightDown = true;
            this.rightJustDown = true;
            this.drawHelper.beginStroke();
        } else if (button == 2) {
            this.panStart = true;
            this.panOffsetX = mouseX - (double)this.panX;
            this.panOffsetY = mouseY - (double)this.panY;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        this.panStart = false;
        if (button == 0) {
            this.leftDown = false;
        }
        if (button == 1) {
            this.rightDown = false;
        }
        this.drawHelper.endStroke();
        return false;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.containsPoint(mouseX, mouseY)) {
            return false;
        }
        if (verticalAmount == 0.0) {
            return false;
        }
        double worldMouseX = (mouseX - (double)(this.x + this.panX)) / (double)this.zoom;
        double worldMouseY = (mouseY - (double)(this.y + this.panY)) / (double)this.zoom;
        this.zoom = verticalAmount > 0.0 ? Math.min(64, this.zoom * 2) : Math.max(1, this.zoom / 2);
        this.panX = (int)(mouseX - (double)this.x - worldMouseX * (double)this.zoom);
        this.panY = (int)(mouseY - (double)this.y - worldMouseY * (double)this.zoom);
        return true;
    }

    @Override
    public boolean onCharTyped(char chr, int modifiers) {
        if (!this.state.shortcutsEnabled) {
            return false;
        }
        if (this.state.colorPickerActive && chr == 'b') {
            this.state.setColorPicker(false);
            return true;
        }
        if (!this.state.colorPickerActive && chr == 'i') {
            this.state.setColorPicker(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.state.shortcutsEnabled) {
            return false;
        }
        if (keyCode == 90 && (modifiers & 2) == 2 && this.drawHelper.undo()) {
            CrazyPaintingClient.play(CrazySounds.UNDO, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public void tick() {
        this.drawHelper.tick();
    }
}

