/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.recipe;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.components.PaletteColorsComponent;
import com.github.omoflop.crazypainting.content.CrazyComponents;
import com.github.omoflop.crazypainting.content.CrazyRecipes;
import com.github.omoflop.crazypainting.items.PaletteItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public class PaletteFillingRecipe
extends class_1852 {
    public PaletteFillingRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        List stacks = input.method_59989();
        class_1799 paletteStack = PaletteFillingRecipe.tryGetPalette(stacks);
        if (paletteStack == null) {
            return false;
        }
        ArrayList<Integer> colors = PaletteFillingRecipe.gatherColors(stacks);
        if (colors.isEmpty()) {
            return false;
        }
        return !PaletteItem.hasAnyColor(paletteStack, colors);
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        List stacks = input.method_59989();
        class_1799 paletteStack = PaletteFillingRecipe.tryGetPalette(stacks);
        assert (paletteStack != null);
        PaletteItem item = (PaletteItem)paletteStack.method_7909();
        ArrayList<Integer> colorPalette = new ArrayList<Integer>();
        colorPalette.addAll(PaletteItem.getColors(paletteStack));
        colorPalette.addAll(PaletteFillingRecipe.gatherColors(stacks));
        PaletteColorsComponent.sort(colorPalette);
        class_1799 resultStack = new class_1799((class_1935)item);
        resultStack.method_57379(CrazyComponents.PALETTE_COLORS, (Object)new PaletteColorsComponent(colorPalette));
        return resultStack;
    }

    public class_1865<? extends class_1852> method_8119() {
        return CrazyRecipes.PALETTE_FILLING;
    }

    private static ArrayList<Integer> gatherColors(List<class_1799> stacks) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (class_1799 stack : stacks) {
            class_1792 item = stack.method_7909();
            if (!CrazyPainting.VANILLA_COLORS.containsKey(item)) continue;
            colors.add(CrazyPainting.VANILLA_COLORS.get(item));
        }
        return colors;
    }

    @Nullable
    private static class_1799 tryGetPalette(List<class_1799> stacks) {
        class_1799 paletteStack = null;
        for (class_1799 stack : stacks) {
            class_1792 item = stack.method_7909();
            if (paletteStack == null && item instanceof PaletteItem) {
                paletteStack = stack;
                continue;
            }
            if (CrazyPainting.VANILLA_COLORS.containsKey(item) || stack.method_7960()) continue;
            return null;
        }
        return paletteStack;
    }
}

