/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.forge;

import dev.architectury.registry.client.forge.ClientReloadListenerRegistryImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;

public class ReloadListenerRegistryImpl {
    private static Map<ResourceLocation, PreparableReloadListener> serverDataReloadListeners = new HashMap<ResourceLocation, PreparableReloadListener>();
    private static Map<ResourceLocation, Collection<ResourceLocation>> serverDataReloadListenerDependencies = new HashMap<ResourceLocation, Collection<ResourceLocation>>();

    public static void register(PackType type, PreparableReloadListener listener, ResourceLocation listenerId, Collection<ResourceLocation> dependencies) {
        if (type == PackType.SERVER_DATA) {
            serverDataReloadListeners.put(listenerId, listener);
            serverDataReloadListenerDependencies.put(listenerId, dependencies);
        } else if (type == PackType.CLIENT_RESOURCES) {
            ClientReloadListenerRegistryImpl.register(listener, listenerId, dependencies);
        }
    }

    public static void addServerReloadListeners(AddServerReloadListenersEvent event) {
        serverDataReloadListeners.forEach((arg_0, arg_1) -> ((AddServerReloadListenersEvent)event).addListener(arg_0, arg_1));
        serverDataReloadListenerDependencies.forEach((listener, dependencies) -> dependencies.forEach(dependency -> event.addDependency(listener, dependency)));
    }

    static {
        NeoForge.EVENT_BUS.addListener(ReloadListenerRegistryImpl::addServerReloadListeners);
    }
}

