/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.entity.trade.forge;

import dev.architectury.registry.level.entity.trade.TradeRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

public class TradeRegistryImpl {
    private static final Map<ResourceKey<VillagerProfession>, Int2ObjectMap<List<VillagerTrades.ItemListing>>> TRADES_TO_ADD = new HashMap<ResourceKey<VillagerProfession>, Int2ObjectMap<List<VillagerTrades.ItemListing>>>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_BUYING = new ArrayList<VillagerTrades.ItemListing>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_GENERIC = new ArrayList<VillagerTrades.ItemListing>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_RARE = new ArrayList<VillagerTrades.ItemListing>();

    public static void registerVillagerTrade0(ResourceKey<VillagerProfession> profession, int level, VillagerTrades.ItemListing ... trades) {
        Int2ObjectMap tradesForProfession = TRADES_TO_ADD.computeIfAbsent(profession, $ -> new Int2ObjectOpenHashMap());
        List tradesForLevel = (List)tradesForProfession.computeIfAbsent(level, $ -> new ArrayList());
        Collections.addAll(tradesForLevel, trades);
    }

    public static void registerTradeForWanderingTrader(TradeRegistry.WandererTradeType type, VillagerTrades.ItemListing ... trades) {
        if (type == TradeRegistry.WandererTradeType.RARE_TRADES) {
            Collections.addAll(WANDERER_TRADER_TRADES_RARE, trades);
        } else if (type == TradeRegistry.WandererTradeType.GENERIC_TRADES) {
            Collections.addAll(WANDERER_TRADER_TRADES_GENERIC, trades);
        } else {
            Collections.addAll(WANDERER_TRADER_TRADES_BUYING, trades);
        }
    }

    public static void onTradeRegistering(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ItemListing>> trades = TRADES_TO_ADD.get(event.getType());
        if (trades != null) {
            for (Int2ObjectMap.Entry entry : trades.int2ObjectEntrySet()) {
                ((List)event.getTrades().computeIfAbsent(entry.getIntKey(), $ -> NonNullList.create())).addAll((Collection)entry.getValue());
            }
        }
    }

    public static void onWanderingTradeRegistering(WandererTradesEvent event) {
        if (!WANDERER_TRADER_TRADES_BUYING.isEmpty()) {
            event.getBuyingTrades().addAll(WANDERER_TRADER_TRADES_BUYING);
        }
        if (!WANDERER_TRADER_TRADES_GENERIC.isEmpty()) {
            event.getGenericTrades().addAll(WANDERER_TRADER_TRADES_GENERIC);
        }
        if (!WANDERER_TRADER_TRADES_RARE.isEmpty()) {
            event.getRareTrades().addAll(WANDERER_TRADER_TRADES_RARE);
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(TradeRegistryImpl::onTradeRegistering);
        NeoForge.EVENT_BUS.addListener(TradeRegistryImpl::onWanderingTradeRegistering);
    }
}

