/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import com.yourname.skillforge999.SkillForge999;
import com.yourname.skillforge999.SkillManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands
implements CommandExecutor {
    private SkillForge999 plugin;

    public Commands(SkillForge999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("skillforge") || command.getName().equalsIgnoreCase("sf")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                return true;
            }
            Player player = (Player)sender;
            if (args.length == 0) {
                this.plugin.getSkillManager().openSkillsInventory(player, 0);
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (player.hasPermission("skillforge.reload")) {
                    this.plugin.reloadConfig();
                    this.plugin.saveSkillsConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "SkillForge999 config reloaded!");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                }
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " [reload]");
            return true;
        }
        if (command.getName().equalsIgnoreCase("sfdebug")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                return true;
            }
            Player player = (Player)sender;
            if (player.hasPermission("skillforge.debug")) {
                this.plugin.setDebugMode(!this.plugin.isDebugMode());
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "Debug mode " + (this.plugin.isDebugMode() ? "enabled" : "disabled"));
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("party")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use party commands!");
                return true;
            }
            Player player = (Player)sender;
            if (args.length == 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /party <create|invite|accept|gui>");
                return true;
            }
            if (args[0].equalsIgnoreCase("create")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /party create <name>");
                    return true;
                }
                String partyName = args[1];
                this.plugin.getPartyManager().createParty(player, partyName);
                return true;
            }
            if (args[0].equalsIgnoreCase("invite")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /party invite <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                this.plugin.getPartyManager().invitePlayer(player, target);
                return true;
            }
            if (args[0].equalsIgnoreCase("accept")) {
                String partyName = null;
                if (args.length >= 2) {
                    partyName = args[1];
                }
                this.plugin.getPartyManager().acceptInvite(player, partyName);
                return true;
            }
            if (args[0].equalsIgnoreCase("gui")) {
                this.plugin.getPartyManager().openPartyGUI(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("leave")) {
                this.plugin.getPartyManager().leaveParty(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("disband")) {
                this.plugin.getPartyManager().disbandParty(player);
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /party <create|invite|accept|gui|leave|disband>");
            return true;
        }
        if (command.getName().equalsIgnoreCase("skill")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use skill commands!");
                return true;
            }
            Player player = (Player)sender;
            if (args.length == 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /skill <top|stats>");
                return true;
            }
            if (args[0].equalsIgnoreCase("top")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /skill top <skill_name>");
                    return true;
                }
                String skillName = args[1];
                SkillManager.Skill skill = null;
                try {
                    skill = SkillManager.Skill.valueOf(skillName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid skill name.");
                    return true;
                }
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "---- Top 10 " + skill.name() + " ----");
                HashMap<UUID, Integer> topPlayers = new HashMap<UUID, Integer>();
                for (String uuidStr : this.plugin.getSkillsConfig().getKeys(false)) {
                    UUID uuid = UUID.fromString(uuidStr);
                    int level = this.plugin.getSkillsConfig().getInt(uuidStr + "." + skill.getConfigKey() + ".level", 0);
                    topPlayers.put(uuid, level);
                }
                topPlayers.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).forEach(entry -> {
                    Player p = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
                    String name = p != null ? p.getName() : ((UUID)entry.getKey()).toString();
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + name + ": " + String.valueOf(ChatColor.GREEN) + String.valueOf(entry.getValue()));
                });
                return true;
            }
            if (args[0].equalsIgnoreCase("stats")) {
                Player target = player;
                if (args.length >= 2 && (target = Bukkit.getPlayer((String)args[1])) == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "---- " + target.getName() + "'s Skills ----");
                for (SkillManager.Skill skill : SkillManager.Skill.values()) {
                    int level = this.plugin.getSkillManager().getSkillLevel(target.getUniqueId(), skill);
                    int xp = this.plugin.getSkillManager().getSkillXp(target.getUniqueId(), skill);
                    int nextLevelXp = 25 * (level + 1);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + skill.name() + ": " + String.valueOf(ChatColor.GREEN) + "Level " + level + " (" + xp + "/" + nextLevelXp + " XP)");
                }
                return true;
            }
        } else if (command.getName().equalsIgnoreCase("sfadmin")) {
            if (!sender.hasPermission("skillforge.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sfadmin <setlevel>");
                return true;
            }
            if (args[0].equalsIgnoreCase("setlevel")) {
                int level;
                if (args.length < 4) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sfadmin setlevel <player> <skill> <level>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                String skillName = args[2];
                SkillManager.Skill skill = null;
                try {
                    skill = SkillManager.Skill.valueOf(skillName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid skill name.");
                    return true;
                }
                try {
                    level = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid level. Please enter a number.");
                    return true;
                }
                if (level < 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Level cannot be negative.");
                    return true;
                }
                this.plugin.getSkillManager().setSkillLevel(target.getUniqueId(), skill, level);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s " + skill.name() + " level to " + level + ".");
                return true;
            }
        }
        return false;
    }
}

