/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import com.yourname.skillforge999.SkillForge999;
import com.yourname.skillforge999.SkillManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Hopper;
import org.bukkit.block.ShulkerBox;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Listeners
implements Listener {
    private SkillForge999 plugin;
    private final Map<UUID, Long> lastXpGain = new ConcurrentHashMap<UUID, Long>();
    private final Map<Location, UUID> brewingStandLastUser = new ConcurrentHashMap<Location, UUID>();
    private static final Map<String, Material> AUTO_SMELT_MAP = Listeners.createAutoSmeltMap();
    private static final Material[] ORES = new Material[]{Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE, Material.EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_COPPER_ORE, Material.ANCIENT_DEBRIS};

    public Listeners(SkillForge999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String uuid = player.getUniqueId().toString();
        if (!this.plugin.getSkillsConfig().contains(uuid)) {
            this.initializePlayerData(uuid);
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("Initialized new player data for " + player.getName());
            }
        }
        this.updatePlayerSpeed(player);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        if (player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH)) {
            return;
        }
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        if (this.isOre(material)) {
            this.handleOreMiner(player, event, uuid, material);
        } else if (this.isLog(material)) {
            this.handleTreeFeller(player, event, uuid);
        } else if (this.isCrop(material)) {
            this.handleFarmer(player, event, uuid);
        } else if (this.isExcavationMaterial(material)) {
            this.handleExcavator(player, event, uuid);
        }
    }

    @EventHandler
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        Player player = event.getPlayer();
        int xp = event.getExpToDrop();
        if (xp > 0 && !this.shouldSkipXpGain(player.getUniqueId())) {
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.SMELTING_EXPERT, this.getConfigXp(SkillManager.Skill.SMELTING_EXPERT) * xp);
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH && !this.shouldSkipXpGain(event.getPlayer().getUniqueId())) {
            Player player = event.getPlayer();
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.FISHERMAN, this.getConfigXp(SkillManager.Skill.FISHERMAN));
            int fisherLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.FISHERMAN);
            if (fisherLevel > 0 && Math.random() * 100.0 < (double)fisherLevel * this.plugin.getConfig().getDouble("skills.Fisherman.double_catch_chance_per_level", 1.0) && event.getCaught() instanceof Item) {
                int maxStackSize;
                Item caught = (Item)event.getCaught();
                ItemStack item = caught.getItemStack();
                int originalAmount = item.getAmount();
                int doubledAmount = originalAmount * 2;
                if (doubledAmount <= (maxStackSize = item.getMaxStackSize())) {
                    item.setAmount(doubledAmount);
                    caught.setItemStack(item);
                } else {
                    ItemStack extraStack = item.clone();
                    extraStack.setAmount(originalAmount);
                    player.getWorld().dropItemNaturally(caught.getLocation(), extraStack);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.BREWING_STAND) {
            this.brewingStandLastUser.put(event.getClickedBlock().getLocation(), event.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onPotionBrew(BrewEvent event) {
        Location loc = event.getContents().getHolder().getLocation();
        if (loc == null) {
            return;
        }
        UUID userUUID = this.brewingStandLastUser.get(loc);
        if (userUUID == null) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(userUUID);
        if (player == null || this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        this.processXpGain(player, SkillManager.Skill.ALCHEMIST, this.getConfigXp(SkillManager.Skill.ALCHEMIST));
        int alchemistLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.ALCHEMIST);
        if (alchemistLevel > 0) {
            Random random = new Random();
            if ((double)random.nextInt(100) < (double)alchemistLevel * this.plugin.getConfig().getDouble("skills.Alchemist.double_potion_chance_per_level", 1.0)) {
                for (ItemStack result : event.getResults()) {
                    int maxStackSize;
                    if (result == null) continue;
                    int originalAmount = result.getAmount();
                    int doubledAmount = originalAmount * 2;
                    if (doubledAmount <= (maxStackSize = result.getMaxStackSize())) {
                        result.setAmount(doubledAmount);
                        break;
                    }
                    ItemStack extraStack = result.clone();
                    extraStack.setAmount(originalAmount);
                    player.getWorld().dropItemNaturally(player.getLocation(), extraStack);
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GRAY) + "SkillForge - Skills")) {
            int currentPage;
            String name;
            ItemStack clicked;
            block13: {
                event.setCancelled(true);
                clicked = event.getCurrentItem();
                if (clicked == null || !clicked.hasItemMeta()) {
                    return;
                }
                name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
                currentPage = 0;
                if (title.contains("Page")) {
                    try {
                        currentPage = Integer.parseInt(title.replaceAll("[^0-9]", "")) - 1;
                    }
                    catch (NumberFormatException e) {
                        if (!this.plugin.isDebugMode()) break block13;
                        this.plugin.getLogger().warning("Failed to parse page number from inventory title: " + title + " - " + e.getMessage());
                    }
                }
            }
            if (name.equalsIgnoreCase("Next Page")) {
                this.plugin.getSkillManager().openSkillsInventory(player, currentPage + 1);
            } else if (name.equalsIgnoreCase("Previous Page")) {
                this.plugin.getSkillManager().openSkillsInventory(player, currentPage - 1);
            } else if (clicked.getType() == Material.BARRIER) {
                player.closeInventory();
            }
        } else if (title.startsWith(String.valueOf(ChatColor.DARK_GRAY) + "Party: ")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Tameable tameable;
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            ItemStack weapon = player.getInventory().getItemInMainHand();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            if (weapon.getType().toString().endsWith("_SWORD")) {
                this.processXpGain(player, SkillManager.Skill.SWORDSMAN, this.getConfigXp(SkillManager.Skill.SWORDSMAN));
                int swordsmanLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.SWORDSMAN);
                if (swordsmanLevel > 0) {
                    event.setDamage(event.getDamage() + (double)swordsmanLevel * this.plugin.getConfig().getDouble("skills.Swordsman.damage_bonus_per_level", 0.1));
                }
            }
            if (event.getEntity() instanceof Animals) {
                this.processXpGain(player, SkillManager.Skill.HUNTER, this.getConfigXp(SkillManager.Skill.HUNTER));
                int hunterLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.HUNTER);
                if (hunterLevel > 0 && Math.random() * 100.0 < (double)hunterLevel * this.plugin.getConfig().getDouble("skills.Hunter.double_drop_chance_per_level", 1.0)) {
                    final LivingEntity entity = (LivingEntity)event.getEntity();
                    new BukkitRunnable(){

                        public void run() {
                            Collection<ItemStack> drops = Listeners.this.getEntityDrops(entity);
                            for (ItemStack drop : drops) {
                                ItemStack doubled = drop.clone();
                                doubled.setAmount(drop.getAmount() * 2);
                                entity.getWorld().dropItemNaturally(entity.getLocation(), doubled);
                            }
                        }
                    }.runTask((Plugin)this.plugin);
                }
            }
        } else if (event.getDamager() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getDamager();
            if (arrow.getShooter() instanceof Player) {
                Player player = (Player)arrow.getShooter();
                if (this.shouldSkipXpGain(player.getUniqueId())) {
                    return;
                }
                String uuid = player.getUniqueId().toString();
                this.processXpGain(player, SkillManager.Skill.ARCHER, this.getConfigXp(SkillManager.Skill.ARCHER));
                int archerLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.ARCHER);
                if (archerLevel > 0) {
                    Random random = new Random();
                    if ((double)random.nextInt(100) < (double)archerLevel * this.plugin.getConfig().getDouble("skills.Archer.double_damage_chance_per_level", 1.0)) {
                        event.setDamage(event.getDamage() * 2.0);
                    }
                    Random random2 = new Random();
                    if ((double)random2.nextInt(100) < (double)archerLevel * this.plugin.getConfig().getDouble("skills.Archer.arrow_retrieval_chance_multiplier", 5.0)) {
                        player.getWorld().dropItemNaturally(player.getLocation(), new ItemStack(Material.ARROW));
                    }
                }
            }
        } else if (event.getDamager() instanceof Tameable && (tameable = (Tameable)event.getDamager()).isTamed() && tameable.getOwner() instanceof Player) {
            Player owner = (Player)tameable.getOwner();
            String uuid = owner.getUniqueId().toString();
            int beastmasterLevel = this.plugin.getSkillManager().getSkillLevel(owner.getUniqueId(), SkillManager.Skill.BEASTMASTER);
            if (beastmasterLevel > 0) {
                double bonusDamage = (double)beastmasterLevel * this.plugin.getConfig().getDouble("skills.Beastmaster.bonus_damage_per_level", 0.1);
                event.setDamage(event.getDamage() + bonusDamage);
            }
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            double reduction;
            Player player = (Player)event.getEntity();
            String uuid = player.getUniqueId().toString();
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                int acrobatLevel;
                int xpGained;
                if (!this.shouldSkipXpGain(player.getUniqueId()) && (xpGained = (int)(event.getDamage() * this.plugin.getConfig().getDouble("skills.Acrobat.xp_per_fall_damage", 1.0))) > 0) {
                    this.processXpGain(player, SkillManager.Skill.ACROBAT, xpGained);
                }
                if ((acrobatLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.ACROBAT)) > 0) {
                    reduction = (double)acrobatLevel * this.plugin.getConfig().getDouble("skills.Acrobat.fall_damage_reduction_per_level", 0.01);
                    event.setDamage(event.getDamage() * (1.0 - reduction));
                }
            } else if (!this.shouldSkipXpGain(player.getUniqueId())) {
                this.processXpGain(player, SkillManager.Skill.DEFENSE, this.getConfigXp(SkillManager.Skill.DEFENSE));
            }
            int defenseLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.DEFENSE);
            if (defenseLevel > 0) {
                reduction = (double)defenseLevel * this.plugin.getConfig().getDouble("skills.Defense.damage_reduction_per_level", 0.005);
                event.setDamage(event.getDamage() * (1.0 - reduction));
            }
        }
    }

    @EventHandler
    public void onXpPickup(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        int xpAmount = event.getAmount();
        UUID uuid = player.getUniqueId();
        if (xpAmount <= 0 || this.shouldSkipXpGain(uuid)) {
            return;
        }
        String id = uuid.toString();
        int convertedXp = xpAmount / 10;
        if (convertedXp > 0) {
            // empty if block
        }
    }

    @EventHandler
    public void onInventoryOpen(final InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getPlayer();
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder == null) {
            return;
        }
        if (holder instanceof Chest || holder instanceof Barrel || holder instanceof Dispenser || holder instanceof Dropper || holder instanceof Furnace || holder instanceof Hopper || holder instanceof ShulkerBox) {
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.LOOTER, this.getConfigXp(SkillManager.Skill.LOOTER));
            int looterLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.LOOTER);
            if (looterLevel > 0) {
                int chance = (int)((double)looterLevel * this.plugin.getConfig().getDouble("skills.Looter.bonus_loot_chance_per_level", 1.0));
                if (new Random().nextInt(100) < chance) {
                    new BukkitRunnable(){

                        public void run() {
                            Inventory inv = event.getInventory();
                            ArrayList<ItemStack> bonusItems = new ArrayList<ItemStack>();
                            for (ItemStack item : inv.getContents()) {
                                if (item == null || item.getType() == Material.AIR) continue;
                                ItemStack bonus = item.clone();
                                bonus.setAmount(1 + new Random().nextInt(2));
                                bonusItems.add(bonus);
                            }
                            for (ItemStack bonus : bonusItems) {
                                player.getWorld().dropItemNaturally(player.getLocation(), bonus);
                            }
                        }
                    }.runTask((Plugin)this.plugin);
                }
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        this.processXpGain(player, SkillManager.Skill.RECYCLER, this.getConfigXp(SkillManager.Skill.RECYCLER));
        int recyclerLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.RECYCLER);
        if (recyclerLevel > 0) {
            int refundChance = (int)((double)recyclerLevel * this.plugin.getConfig().getDouble("skills.Recycler.refund_chance_per_level", 1.0));
            Random random = new Random();
            int refundCount = 1 + random.nextInt(2);
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                if (event.getInventory().getItem(i) == null || event.getInventory().getItem(i).getType() == Material.AIR) continue;
                slots.add(i);
            }
            Collections.shuffle(slots);
            int refunded = 0;
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                ItemStack item;
                int slot = (Integer)iterator.next();
                if (refunded >= refundCount) break;
                if (random.nextInt(100) >= refundChance || (item = event.getInventory().getItem(slot)) == null) continue;
                ItemStack refund = item.clone();
                refund.setAmount(1);
                player.getInventory().addItem(new ItemStack[]{refund});
                ++refunded;
            }
        }
    }

    @EventHandler
    public void onEntityTame(EntityTameEvent event) {
        if (event.getOwner() instanceof Player) {
            LivingEntity tamed;
            AttributeInstance maxHealth;
            Player player = (Player)event.getOwner();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.BEASTMASTER, this.getConfigXp(SkillManager.Skill.BEASTMASTER));
            int beastmasterLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.BEASTMASTER);
            if (beastmasterLevel > 0 && (maxHealth = (tamed = event.getEntity()).getAttribute(Attribute.MAX_HEALTH)) != null) {
                double bonusHealth = (double)beastmasterLevel * this.plugin.getConfig().getDouble("skills.Beastmaster.bonus_health_per_level", 0.5);
                maxHealth.setBaseValue(maxHealth.getBaseValue() + bonusHealth);
                tamed.setHealth(maxHealth.getBaseValue());
            }
        }
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        if (event.getBreeder() instanceof Player) {
            Player player = (Player)event.getBreeder();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.BEASTMASTER, this.getConfigXp(SkillManager.Skill.BEASTMASTER));
            int beastmasterLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.BEASTMASTER);
            if (beastmasterLevel > 0) {
                double twinChance = (double)beastmasterLevel * this.plugin.getConfig().getDouble("skills.Beastmaster.twin_chance_per_level", 0.5);
                Random random = new Random();
                if (random.nextDouble() * 100.0 < twinChance) {
                    event.getEntity().getWorld().spawnEntity(event.getEntity().getLocation(), event.getEntityType());
                }
            }
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getEnchanter();
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        this.processXpGain(player, SkillManager.Skill.ENCHANTER, this.getConfigXp(SkillManager.Skill.ENCHANTER));
        int enchanterLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.ENCHANTER);
        if (enchanterLevel > 0) {
            double costReduction = this.plugin.getConfig().getDouble("skills.Enchanter.cost_reduction_per_level", 0.01) * (double)enchanterLevel;
            int newCost = (int)((double)event.getExpLevelCost() * (1.0 - costReduction));
            event.setExpLevelCost(Math.max(0, newCost));
            double enchantmentImprovementChance = this.plugin.getConfig().getDouble("skills.Enchanter.enchantment_improvement_chance_per_level", 0.5) * (double)enchanterLevel;
            Random random = new Random();
            for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                if (!(random.nextDouble() * 100.0 < enchantmentImprovementChance)) continue;
                Enchantment enchantment = (Enchantment)entry.getKey();
                int currentLevel = (Integer)entry.getValue();
                if (currentLevel >= enchantment.getMaxLevel()) continue;
                event.getEnchantsToAdd().put(enchantment, currentLevel + 1);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your Enchanter skill improved " + enchantment.getName() + " to level " + (currentLevel + 1) + "!");
            }
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Enchanter skill active! Level: " + enchanterLevel + ". XP cost reduced!");
        }
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntered() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntered();
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        if (event.getVehicle() instanceof Animals || event.getVehicle() instanceof Horse) {
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.RIDER, this.getConfigXp(SkillManager.Skill.RIDER));
            int riderLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.RIDER);
            if (riderLevel > 0) {
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "Rider skill active! Level: " + riderLevel);
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        TNTPrimed tnt;
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity() instanceof TNTPrimed && (tnt = (TNTPrimed)event.getEntity()).getSource() instanceof Player) {
            Player player = (Player)tnt.getSource();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            this.processXpGain(player, SkillManager.Skill.DEMOLITIONIST, this.getConfigXp(SkillManager.Skill.DEMOLITIONIST));
            int demolitionistLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.DEMOLITIONIST);
            if (demolitionistLevel > 0) {
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "Demolitionist skill active! Level: " + demolitionistLevel);
            }
        }
    }

    @EventHandler
    public void onTradeSelect(TradeSelectEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        this.processXpGain(player, SkillManager.Skill.MERCHANT, this.getConfigXp(SkillManager.Skill.MERCHANT));
        int merchantLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.MERCHANT);
        if (merchantLevel > 0) {
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Merchant skill active! Level: " + merchantLevel);
        }
    }

    private void initializePlayerData(String uuid) {
        HashMap<CallSite, Integer> defaultData = new HashMap<CallSite, Integer>();
        for (SkillManager.Skill skill : SkillManager.Skill.values()) {
            defaultData.put((CallSite)((Object)(skill.getConfigKey() + ".level")), 0);
            defaultData.put((CallSite)((Object)(skill.getConfigKey() + ".xp")), 0);
        }
        this.plugin.getSkillsConfig().createSection(uuid, defaultData);
        this.plugin.saveSkillsConfig();
    }

    private boolean shouldSkipXpGain(UUID uuid) {
        long now = System.currentTimeMillis();
        Long lastTime = this.lastXpGain.get(uuid);
        if (lastTime != null && now - lastTime < 50L) {
            return true;
        }
        this.lastXpGain.put(uuid, now);
        return false;
    }

    private void handleOreMiner(Player player, BlockBreakEvent event, String uuid, Material material) {
        int oreMinerLevel;
        this.processXpGain(player, SkillManager.Skill.ORE_MINER, this.getConfigXp(SkillManager.Skill.ORE_MINER));
        int smeltingExpertLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.SMELTING_EXPERT);
        if (smeltingExpertLevel > 0 && AUTO_SMELT_MAP.containsKey(material.name())) {
            Random random = new Random();
            if ((double)random.nextInt(100) < (double)smeltingExpertLevel * this.plugin.getConfig().getDouble("skills.SmeltingExpert.auto_smelt_chance_per_level", 1.0)) {
                event.setDropItems(false);
                Material smeltedMaterial = AUTO_SMELT_MAP.get(material.name());
                if (smeltedMaterial != null) {
                    player.getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(smeltedMaterial, 1));
                    this.processXpGain(player, SkillManager.Skill.SMELTING_EXPERT, this.getConfigXp(SkillManager.Skill.SMELTING_EXPERT));
                }
                return;
            }
        }
        if ((oreMinerLevel = this.plugin.getSkillsConfig().getInt(uuid + ".OreMiner.level", 0)) <= 0) {
            return;
        }
        double oreMinerChance = (double)oreMinerLevel * this.plugin.getConfig().getDouble("skills.OreMiner.double_drop_chance_per_level", 1.0);
        Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
        for (ItemStack drop : drops) {
            if (!(Math.random() * 100.0 < oreMinerChance)) continue;
            ItemStack doubleDrop = drop.clone();
            doubleDrop.setAmount(drop.getAmount() * 2);
            player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
        }
    }

    private void handleTreeFeller(Player player, BlockBreakEvent event, String uuid) {
        this.processXpGain(player, SkillManager.Skill.TREE_FELLER, this.getConfigXp(SkillManager.Skill.TREE_FELLER));
        int treeFellerLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.TREE_FELLER);
        if (treeFellerLevel > 0) {
            Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
            for (ItemStack drop : drops) {
                Random random = new Random();
                if (!((double)random.nextInt(100) < (double)treeFellerLevel * this.plugin.getConfig().getDouble("skills.TreeFeller.double_drop_chance_per_level", 1.0))) continue;
                ItemStack doubleDrop = drop.clone();
                doubleDrop.setAmount(drop.getAmount() * 2);
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
            }
        }
    }

    private void handleFarmer(Player player, BlockBreakEvent event, String uuid) {
        this.processXpGain(player, SkillManager.Skill.FARMER, this.getConfigXp(SkillManager.Skill.FARMER));
        int farmerLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.FARMER);
        if (farmerLevel > 0) {
            Collection drops = event.getBlock().getDrops();
            for (ItemStack drop : drops) {
                Random random = new Random();
                if (!((double)random.nextInt(100) < (double)farmerLevel * this.plugin.getConfig().getDouble("skills.Farmer.double_drop_chance_per_level", 1.0))) continue;
                ItemStack doubleDrop = drop.clone();
                doubleDrop.setAmount(drop.getAmount() * 2);
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
            }
        }
    }

    private void handleExcavator(Player player, BlockBreakEvent event, String uuid) {
        this.processXpGain(player, SkillManager.Skill.EXCAVATOR, this.getConfigXp(SkillManager.Skill.EXCAVATOR));
        int excavatorLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), SkillManager.Skill.EXCAVATOR);
        if (excavatorLevel > 0) {
            Random random;
            double lootChance;
            ItemStack bonusLoot;
            Random random2 = new Random();
            if ((double)random2.nextInt(100) < (double)excavatorLevel * this.plugin.getConfig().getDouble("skills.Excavator.bonus_loot_chance_per_level", 1.0) && (bonusLoot = this.getExcavatorBonusLoot(lootChance = (random = new Random()).nextDouble() * 100.0, random)) != null) {
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), bonusLoot);
            }
        }
    }

    private ItemStack getExcavatorBonusLoot(double chance, Random random) {
        if (chance <= 40.0) {
            return new ItemStack(Material.BONE, random.nextInt(2) + 1);
        }
        if (chance <= 60.0) {
            return new ItemStack(Material.ROTTEN_FLESH, random.nextInt(2) + 1);
        }
        if (chance <= 70.0) {
            return new ItemStack(Material.LEATHER);
        }
        if (chance <= 85.0) {
            return new ItemStack(Material.IRON_NUGGET);
        }
        if (chance <= 95.0) {
            return new ItemStack(Material.EMERALD);
        }
        return new ItemStack(Material.DIAMOND);
    }

    @Deprecated
    public boolean addXp(String uuid, String skillName, int xpToAdd, Player player, boolean isAsync) {
        return false;
    }

    @Deprecated
    private void sendLevelUpMessage(Player player, String skillName) {
    }

    private Collection<ItemStack> getEntityDrops(LivingEntity entity) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        EntityType type = entity.getType();
        switch (type) {
            case BAT: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case BEE: {
                drops.add(new ItemStack(Material.HONEYCOMB, 1));
                break;
            }
            case BLAZE: {
                drops.add(new ItemStack(Material.BLAZE_ROD, 1));
                break;
            }
            case CAT: {
                drops.add(new ItemStack(Material.STRING, 1));
                break;
            }
            case CAVE_SPIDER: {
                drops.add(new ItemStack(Material.STRING, 1));
                drops.add(new ItemStack(Material.SPIDER_EYE, 1));
                break;
            }
            case CHICKEN: {
                drops.add(new ItemStack(Material.CHICKEN, 1));
                drops.add(new ItemStack(Material.FEATHER, 1));
                break;
            }
            case COD: {
                drops.add(new ItemStack(Material.COD, 1));
                break;
            }
            case COW: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                drops.add(new ItemStack(Material.BEEF, 1));
                break;
            }
            case CREEPER: {
                drops.add(new ItemStack(Material.GUNPOWDER, 1));
                break;
            }
            case DOLPHIN: {
                drops.add(new ItemStack(Material.COD, 1));
                break;
            }
            case DONKEY: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case DROWNED: {
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                drops.add(new ItemStack(Material.TRIDENT, 1));
                break;
            }
            case ELDER_GUARDIAN: {
                drops.add(new ItemStack(Material.PRISMARINE_SHARD, 1));
                drops.add(new ItemStack(Material.WET_SPONGE, 1));
                break;
            }
            case ENDERMAN: {
                drops.add(new ItemStack(Material.ENDER_PEARL, 1));
                break;
            }
            case ENDERMITE: {
                drops.add(new ItemStack(Material.ENDER_PEARL, 1));
                break;
            }
            case EVOKER: {
                drops.add(new ItemStack(Material.TOTEM_OF_UNDYING, 1));
                break;
            }
            case FOX: {
                drops.add(new ItemStack(Material.SWEET_BERRIES, 1));
                break;
            }
            case GHAST: {
                drops.add(new ItemStack(Material.GHAST_TEAR, 1));
                drops.add(new ItemStack(Material.GUNPOWDER, 1));
                break;
            }
            case GOAT: {
                drops.add(new ItemStack(Material.GOAT_HORN, 1));
                break;
            }
            case GUARDIAN: {
                drops.add(new ItemStack(Material.PRISMARINE_SHARD, 1));
                break;
            }
            case HOGLIN: {
                drops.add(new ItemStack(Material.PORKCHOP, 1));
                break;
            }
            case HORSE: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case HUSK: {
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                break;
            }
            case LLAMA: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case MAGMA_CUBE: {
                drops.add(new ItemStack(Material.MAGMA_CREAM, 1));
                break;
            }
            case MULE: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case MOOSHROOM: {
                drops.add(new ItemStack(Material.BEEF, 1));
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case OCELOT: {
                drops.add(new ItemStack(Material.COD, 1));
                break;
            }
            case PANDA: {
                drops.add(new ItemStack(Material.BAMBOO, 1));
                break;
            }
            case PARROT: {
                drops.add(new ItemStack(Material.FEATHER, 1));
                break;
            }
            case PHANTOM: {
                drops.add(new ItemStack(Material.PHANTOM_MEMBRANE, 1));
                break;
            }
            case PIG: {
                drops.add(new ItemStack(Material.PORKCHOP, 1));
                break;
            }
            case PIGLIN: {
                drops.add(new ItemStack(Material.GOLD_INGOT, 1));
                break;
            }
            case PIGLIN_BRUTE: {
                drops.add(new ItemStack(Material.GOLD_INGOT, 1));
                break;
            }
            case PILLAGER: {
                drops.add(new ItemStack(Material.ARROW, 1));
                break;
            }
            case POLAR_BEAR: {
                drops.add(new ItemStack(Material.COD, 1));
                break;
            }
            case PUFFERFISH: {
                drops.add(new ItemStack(Material.PUFFERFISH, 1));
                break;
            }
            case RABBIT: {
                drops.add(new ItemStack(Material.RABBIT_HIDE, 1));
                drops.add(new ItemStack(Material.RABBIT_FOOT, 1));
                drops.add(new ItemStack(Material.RABBIT, 1));
                break;
            }
            case RAVAGER: {
                drops.add(new ItemStack(Material.SADDLE, 1));
                break;
            }
            case SALMON: {
                drops.add(new ItemStack(Material.SALMON, 1));
                break;
            }
            case SHEEP: {
                drops.add(new ItemStack(Material.WHITE_WOOL, 1));
                drops.add(new ItemStack(Material.MUTTON, 1));
                break;
            }
            case SHULKER: {
                drops.add(new ItemStack(Material.SHULKER_SHELL, 1));
                break;
            }
            case SILVERFISH: {
                drops.add(new ItemStack(Material.GRAVEL, 1));
                break;
            }
            case SKELETON: {
                drops.add(new ItemStack(Material.BONE, 1));
                drops.add(new ItemStack(Material.ARROW, 1));
                break;
            }
            case SKELETON_HORSE: {
                drops.add(new ItemStack(Material.BONE, 1));
                break;
            }
            case SLIME: {
                drops.add(new ItemStack(Material.SLIME_BALL, 1));
                break;
            }
            case SPIDER: {
                drops.add(new ItemStack(Material.STRING, 1));
                drops.add(new ItemStack(Material.SPIDER_EYE, 1));
                break;
            }
            case SQUID: {
                drops.add(new ItemStack(Material.INK_SAC, 1));
                break;
            }
            case STRAY: {
                drops.add(new ItemStack(Material.BONE, 1));
                drops.add(new ItemStack(Material.ARROW, 1));
                drops.add(new ItemStack(Material.POTION, 1));
                break;
            }
            case STRIDER: {
                drops.add(new ItemStack(Material.STRING, 1));
                break;
            }
            case TADPOLE: {
                drops.add(new ItemStack(Material.SLIME_BALL, 1));
                break;
            }
            case TRADER_LLAMA: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                break;
            }
            case TROPICAL_FISH: {
                drops.add(new ItemStack(Material.TROPICAL_FISH, 1));
                break;
            }
            case TURTLE: {
                drops.add(new ItemStack(Material.SEAGRASS, 1));
                break;
            }
            case VEX: {
                drops.add(new ItemStack(Material.IRON_SWORD, 1));
                break;
            }
            case VILLAGER: {
                drops.add(new ItemStack(Material.EMERALD, 1));
                break;
            }
            case VINDICATOR: {
                drops.add(new ItemStack(Material.EMERALD, 1));
                drops.add(new ItemStack(Material.IRON_AXE, 1));
                break;
            }
            case WANDERING_TRADER: {
                drops.add(new ItemStack(Material.LEAD, 1));
                break;
            }
            case WARDEN: {
                drops.add(new ItemStack(Material.SCULK_CATALYST, 1));
                break;
            }
            case WITCH: {
                drops.add(new ItemStack(Material.GLASS_BOTTLE, 1));
                drops.add(new ItemStack(Material.GLOWSTONE_DUST, 1));
                drops.add(new ItemStack(Material.GUNPOWDER, 1));
                drops.add(new ItemStack(Material.REDSTONE, 1));
                drops.add(new ItemStack(Material.SPIDER_EYE, 1));
                drops.add(new ItemStack(Material.SUGAR, 1));
                break;
            }
            case WITHER_SKELETON: {
                drops.add(new ItemStack(Material.BONE, 1));
                drops.add(new ItemStack(Material.WITHER_SKELETON_SKULL, 1));
                break;
            }
            case WOLF: {
                drops.add(new ItemStack(Material.BONE, 1));
                break;
            }
            case ZOGLIN: {
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                break;
            }
            case ZOMBIE: {
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                break;
            }
            case ZOMBIE_HORSE: {
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                drops.add(new ItemStack(Material.GOLD_NUGGET, 1));
                drops.add(new ItemStack(Material.ROTTEN_FLESH, 1));
                break;
            }
        }
        return drops;
    }

    private static Map<String, Material> createAutoSmeltMap() {
        HashMap<String, Material> map = new HashMap<String, Material>();
        map.put("IRON_ORE", Material.IRON_INGOT);
        map.put("GOLD_ORE", Material.GOLD_INGOT);
        map.put("NETHER_GOLD_ORE", Material.GOLD_INGOT);
        map.put("ANCIENT_DEBRIS", Material.NETHERITE_SCRAP);
        map.put("COPPER_ORE", Material.COPPER_INGOT);
        map.put("DEEPSLATE_IRON_ORE", Material.IRON_INGOT);
        map.put("DEEPSLATE_GOLD_ORE", Material.GOLD_INGOT);
        map.put("DEEPSLATE_COPPER_ORE", Material.COPPER_INGOT);
        return map;
    }

    private int getConfigXp(SkillManager.Skill skill) {
        return this.plugin.getConfig().getInt("skills." + skill.getConfigKey() + ".xp_per_action", 1);
    }

    private boolean isOre(Material material) {
        for (Material ore : ORES) {
            if (material != ore) continue;
            return true;
        }
        return false;
    }

    private boolean isLog(Material material) {
        return material.name().endsWith("_LOG") || material.name().endsWith("_STEM") || material.name().endsWith("_WOOD") || material == Material.MANGROVE_ROOTS;
    }

    private boolean isCrop(Material material) {
        return material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS || material == Material.MELON || material == Material.PUMPKIN || material == Material.SUGAR_CANE || material == Material.COCOA || material == Material.NETHER_WART || material == Material.SWEET_BERRY_BUSH || material == Material.CACTUS || material == Material.KELP;
    }

    private boolean isExcavationMaterial(Material material) {
        return material == Material.DIRT || material == Material.GRASS_BLOCK || material == Material.SAND || material == Material.GRAVEL || material == Material.COARSE_DIRT || material == Material.PODZOL || material == Material.MYCELIUM || material == Material.RED_SAND || material == Material.SOUL_SAND || material == Material.SOUL_SOIL || material == Material.CLAY;
    }

    private void updatePlayerSpeed(Player player) {
        int level = this.plugin.getSkillsConfig().getInt(String.valueOf(player.getUniqueId()) + ".Acrobat.level", 0);
        if (level > 0) {
            double bonus = (double)level * this.plugin.getConfig().getDouble("skills.Acrobat.speed_bonus_per_level", 0.001);
            player.setWalkSpeed((float)Math.min(0.2 + bonus, 1.0));
        } else {
            player.setWalkSpeed(0.2f);
        }
    }

    private void processXpGain(Player player, SkillManager.Skill skill, int xpToAdd) {
        int newXp;
        String uuid = player.getUniqueId().toString();
        int currentXp = this.plugin.getSkillManager().getSkillXp(player.getUniqueId(), skill);
        int currentLevel = this.plugin.getSkillManager().getSkillLevel(player.getUniqueId(), skill);
        int xpNeededForNextLevel = 25 * (currentLevel + 1);
        int newLevel = currentLevel;
        for (newXp = currentXp + xpToAdd; newXp >= xpNeededForNextLevel; newXp -= xpNeededForNextLevel) {
            xpNeededForNextLevel = 25 * (++newLevel + 1);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You leveled up your " + skill.getDisplayName() + " skill to level " + newLevel + "!");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.plugin.getSkillManager().setSkillXp(player.getUniqueId(), skill, newXp);
        this.plugin.getSkillManager().setSkillLevel(player.getUniqueId(), skill, newLevel);
    }
}

