/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import com.yourname.skillforge999.SkillForge999;
import com.yourname.skillforge999.SkillManager;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PartyManager {
    private SkillForge999 plugin;
    private Map<UUID, Party> playerParties;
    private Map<String, Party> activeParties;
    private Map<UUID, UUID> partyInvites;
    private YamlConfiguration partiesConfig;
    private File partiesFile;

    public PartyManager(SkillForge999 plugin) {
        this.plugin = plugin;
        this.playerParties = new HashMap<UUID, Party>();
        this.activeParties = new HashMap<String, Party>();
        this.partyInvites = new HashMap<UUID, UUID>();
        this.partiesFile = new File(plugin.getDataFolder(), "parties.yml");
        if (!this.partiesFile.exists()) {
            try {
                this.partiesFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create parties.yml!");
                e.printStackTrace();
            }
        }
        this.partiesConfig = YamlConfiguration.loadConfiguration((File)this.partiesFile);
        this.loadParties();
    }

    public void saveParties() {
        block5: {
            this.partiesConfig = new YamlConfiguration();
            for (Map.Entry<String, Party> entry : this.activeParties.entrySet()) {
                String partyName = entry.getKey();
                Party party = entry.getValue();
                this.partiesConfig.set("parties." + partyName + ".leader", (Object)party.getLeader().toString());
                this.partiesConfig.set("parties." + partyName + ".members", party.getMembers().stream().map(UUID::toString).collect(Collectors.toList()));
            }
            for (Map.Entry<Object, Object> entry : this.partyInvites.entrySet()) {
                this.partiesConfig.set("invites." + ((UUID)entry.getKey()).toString(), (Object)((UUID)entry.getValue()).toString());
            }
            try {
                this.partiesConfig.save(this.partiesFile);
                if (this.plugin.isDebugMode()) {
                    this.plugin.getLogger().info("Saved parties.yml successfully");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save parties.yml!");
                if (!this.plugin.isDebugMode()) break block5;
                e.printStackTrace();
            }
        }
    }

    public void loadParties() {
        if (!this.partiesFile.exists()) {
            return;
        }
        if (this.partiesConfig.contains("parties")) {
            for (String partyName : this.partiesConfig.getConfigurationSection("parties").getKeys(false)) {
                UUID leaderUUID = UUID.fromString(this.partiesConfig.getString("parties." + partyName + ".leader"));
                Party party = new Party(partyName, leaderUUID);
                List memberUUIDs = this.partiesConfig.getStringList("parties." + partyName + ".members");
                for (String uuidStr : memberUUIDs) {
                    UUID memberUUID = UUID.fromString(uuidStr);
                    if (!party.getMembers().contains(memberUUID)) {
                        party.addMember(memberUUID);
                    }
                    this.playerParties.put(memberUUID, party);
                }
                this.activeParties.put(partyName, party);
            }
        }
        if (this.partiesConfig.contains("invites")) {
            for (String invitedUUIDStr : this.partiesConfig.getConfigurationSection("invites").getKeys(false)) {
                UUID invitedUUID = UUID.fromString(invitedUUIDStr);
                UUID inviterUUID = UUID.fromString(this.partiesConfig.getString("invites." + invitedUUIDStr));
                this.partyInvites.put(invitedUUID, inviterUUID);
            }
        }
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("Loaded parties.yml successfully");
        }
    }

    public boolean createParty(Player leader, String partyName) {
        if (this.activeParties.containsKey(partyName.toLowerCase())) {
            leader.sendMessage(String.valueOf(ChatColor.RED) + "A party with that name already exists!");
            return false;
        }
        if (this.playerParties.containsKey(leader.getUniqueId())) {
            leader.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a party!");
            return false;
        }
        Party newParty = new Party(partyName, leader.getUniqueId());
        this.activeParties.put(partyName.toLowerCase(), newParty);
        this.playerParties.put(leader.getUniqueId(), newParty);
        leader.sendMessage(String.valueOf(ChatColor.GREEN) + "You have created the party '" + partyName + "'!");
        return true;
    }

    public boolean invitePlayer(Player inviter, Player target) {
        if (!this.playerParties.containsKey(inviter.getUniqueId())) {
            inviter.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return false;
        }
        Party party = this.playerParties.get(inviter.getUniqueId());
        if (!party.getLeader().equals(inviter.getUniqueId())) {
            inviter.sendMessage(String.valueOf(ChatColor.RED) + "Only the party leader can invite players!");
            return false;
        }
        if (this.playerParties.containsKey(target.getUniqueId())) {
            inviter.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is already in a party!");
            return false;
        }
        if (this.partyInvites.containsKey(target.getUniqueId())) {
            inviter.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " already has a pending party invite!");
            return false;
        }
        this.partyInvites.put(target.getUniqueId(), inviter.getUniqueId());
        inviter.sendMessage(String.valueOf(ChatColor.GREEN) + "You have invited " + target.getName() + " to your party.");
        target.sendMessage(String.valueOf(ChatColor.GREEN) + inviter.getName() + " has invited you to join their party '" + party.getName() + "'. Type " + String.valueOf(ChatColor.YELLOW) + "/party accept" + String.valueOf(ChatColor.GREEN) + " to join.");
        return true;
    }

    public boolean acceptInvite(Player player, String partyName) {
        UUID inviterUUID = this.partyInvites.get(player.getUniqueId());
        if (inviterUUID == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending party invites.");
            return false;
        }
        Party partyToJoin = null;
        if (partyName == null || partyName.isEmpty()) {
            Player inviter = Bukkit.getPlayer((UUID)inviterUUID);
            if (inviter != null && this.playerParties.containsKey(inviter.getUniqueId())) {
                partyToJoin = this.playerParties.get(inviter.getUniqueId());
            }
        } else {
            partyToJoin = this.activeParties.get(partyName.toLowerCase());
            if (partyToJoin == null || !partyToJoin.getLeader().equals(inviterUUID)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You were not invited to a party named '" + partyName + "'.");
                return false;
            }
        }
        if (partyToJoin == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The party you were invited to no longer exists or the inviter is offline.");
            return false;
        }
        if (this.playerParties.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a party!");
            this.partyInvites.remove(player.getUniqueId());
            return false;
        }
        partyToJoin.addMember(player.getUniqueId());
        this.playerParties.put(player.getUniqueId(), partyToJoin);
        this.partyInvites.remove(player.getUniqueId());
        partyToJoin.sendMessage(String.valueOf(ChatColor.GREEN) + player.getName() + " has joined the party!");
        return true;
    }

    public void openPartyGUI(Player player) {
        if (!this.playerParties.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return;
        }
        Party party = this.playerParties.get(player.getUniqueId());
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_GRAY) + "Party: " + party.getName()));
        int slot = 0;
        for (UUID memberUUID : party.getMembers()) {
            Player member = Bukkit.getPlayer((UUID)memberUUID);
            if (member == null || !member.isOnline()) continue;
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta meta = playerHead.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + member.getName());
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Leader: " + (member.getUniqueId().equals(party.getLeader()) ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"))));
                for (SkillManager.Skill skill : SkillManager.Skill.values()) {
                    int level = this.plugin.getSkillManager().getSkillLevel(member.getUniqueId(), skill);
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_AQUA) + skill.getDisplayName() + ": " + String.valueOf(ChatColor.WHITE) + level)));
                }
                meta.setLore(lore);
                playerHead.setItemMeta(meta);
            }
            gui.setItem(slot, playerHead);
            ++slot;
        }
        ItemStack pane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta paneMeta = pane.getItemMeta();
        if (paneMeta != null) {
            paneMeta.setDisplayName(" ");
            pane.setItemMeta(paneMeta);
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, pane);
        }
        player.openInventory(gui);
    }

    public Party getPlayerParty(UUID playerUUID) {
        return this.playerParties.get(playerUUID);
    }

    public boolean leaveParty(Player player) {
        if (!this.playerParties.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return false;
        }
        Party party = this.playerParties.get(player.getUniqueId());
        if (party.getLeader().equals(player.getUniqueId())) {
            this.disbandParty(player);
            return true;
        }
        party.removeMember(player.getUniqueId());
        this.playerParties.remove(player.getUniqueId());
        party.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has left the party.");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have left the party.");
        return true;
    }

    public boolean disbandParty(Player player) {
        if (!this.playerParties.containsKey(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return false;
        }
        Party party = this.playerParties.get(player.getUniqueId());
        if (!party.getLeader().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the party leader can disband the party!");
            return false;
        }
        party.sendMessage(String.valueOf(ChatColor.RED) + "The party has been disbanded by " + player.getName() + ".");
        for (UUID memberUUID : party.getMembers()) {
            this.playerParties.remove(memberUUID);
        }
        this.activeParties.remove(party.getName().toLowerCase());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have disbanded the party.");
        return true;
    }

    public class Party {
        private String name;
        private UUID leader;
        private List<UUID> members;

        public Party(String name, UUID leader) {
            this.name = name;
            this.leader = leader;
            this.members = new ArrayList<UUID>();
            this.members.add(leader);
        }

        public String getName() {
            return this.name;
        }

        public UUID getLeader() {
            return this.leader;
        }

        public List<UUID> getMembers() {
            return this.members;
        }

        public boolean addMember(UUID playerUUID) {
            if (!this.members.contains(playerUUID)) {
                this.members.add(playerUUID);
                return true;
            }
            return false;
        }

        public boolean removeMember(UUID playerUUID) {
            return this.members.remove(playerUUID);
        }

        public boolean isMember(UUID playerUUID) {
            return this.members.contains(playerUUID);
        }

        public void sendMessage(String message) {
            for (UUID memberUUID : this.members) {
                Player member = Bukkit.getPlayer((UUID)memberUUID);
                if (member == null || !member.isOnline()) continue;
                member.sendMessage(String.valueOf(ChatColor.AQUA) + "[Party] " + message);
            }
        }
    }
}

