/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import com.yourname.skillforge999.SkillForge999;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkillManager {
    private SkillForge999 plugin;
    private final List<SkillItem> allSkills = Arrays.asList(new SkillItem(Material.DIAMOND_PICKAXE, "Ore Miner", Skill.ORE_MINER.getConfigKey()), new SkillItem(Material.DIAMOND_AXE, "Tree Feller", Skill.TREE_FELLER.getConfigKey()), new SkillItem(Material.DIAMOND_HOE, "Farmer", Skill.FARMER.getConfigKey()), new SkillItem(Material.FURNACE, "Smelting Expert", Skill.SMELTING_EXPERT.getConfigKey()), new SkillItem(Material.DIAMOND_SHOVEL, "Excavator", Skill.EXCAVATOR.getConfigKey()), new SkillItem(Material.FISHING_ROD, "Fisherman", Skill.FISHERMAN.getConfigKey()), new SkillItem(Material.DIAMOND_SWORD, "Swordsman", Skill.SWORDSMAN.getConfigKey()), new SkillItem(Material.BOW, "Archer", Skill.ARCHER.getConfigKey()), new SkillItem(Material.BREWING_STAND, "Alchemist", Skill.ALCHEMIST.getConfigKey()), new SkillItem(Material.SHIELD, "Defense", Skill.DEFENSE.getConfigKey()), new SkillItem(Material.BEEF, "Hunter", Skill.HUNTER.getConfigKey()), new SkillItem(Material.CHEST, "Looter", Skill.LOOTER.getConfigKey()), new SkillItem(Material.FURNACE, "Recycler", Skill.RECYCLER.getConfigKey()), new SkillItem(Material.FEATHER, "Acrobat", Skill.ACROBAT.getConfigKey()), new SkillItem(Material.BONE, "Beastmaster", Skill.BEASTMASTER.getConfigKey()), new SkillItem(Material.ENCHANTING_TABLE, "Enchanter", Skill.ENCHANTER.getConfigKey()), new SkillItem(Material.SADDLE, "Rider", Skill.RIDER.getConfigKey()), new SkillItem(Material.TNT, "Demolitionist", Skill.DEMOLITIONIST.getConfigKey()), new SkillItem(Material.EMERALD, "Merchant", Skill.MERCHANT.getConfigKey()));

    public SkillManager(SkillForge999 plugin) {
        this.plugin = plugin;
    }

    public void openSkillsInventory(Player player, int page) {
        ItemStack closeButton;
        ItemMeta closeMeta;
        int skillsPerPage = 21;
        int totalPages = (int)Math.ceil((double)this.allSkills.size() / (double)skillsPerPage);
        page = Math.max(0, Math.min(page, totalPages - 1));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GRAY) + "SkillForge - Skills (Page " + (page + 1) + ")"));
        String uuid = player.getUniqueId().toString();
        int start = page * skillsPerPage;
        int end = Math.min(start + skillsPerPage, this.allSkills.size());
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        for (int i = start; i < end; ++i) {
            SkillItem skill = this.allSkills.get(i);
            this.addSkillItem(gui, slots[i - start], skill.material, skill.name, uuid, skill.configKey);
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
                prev.setItemMeta(prevMeta);
            }
            gui.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
                next.setItemMeta(nextMeta);
            }
            gui.setItem(53, next);
        }
        if ((closeMeta = (closeButton = new ItemStack(Material.BARRIER)).getItemMeta()) != null) {
            closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close Menu");
            closeButton.setItemMeta(closeMeta);
        }
        gui.setItem(49, closeButton);
        this.fillWithPanes(gui);
        player.openInventory(gui);
    }

    private void addSkillItem(Inventory gui, int slot, Material material, String name, String uuid, String configKey) {
        int level = this.plugin.getSkillsConfig().getInt(uuid + "." + configKey + ".level", 0);
        int xp = this.plugin.getSkillsConfig().getInt(uuid + "." + configKey + ".xp", 0);
        int nextLevelXp = 25 * (level + 1);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + name);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + "Level: " + String.valueOf(ChatColor.GREEN) + level);
            lore.add(String.valueOf(ChatColor.GRAY) + "XP: " + String.valueOf(ChatColor.AQUA) + xp + "/" + nextLevelXp);
            lore.add(this.getProgressBar(xp, nextLevelXp));
            switch (name) {
                case "Ore Miner": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.OreMiner.double_drop_chance_per_level", 1.0) + "% chance for double ores");
                    break;
                }
                case "Tree Feller": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.TreeFeller.double_drop_chance_per_level", 1.0) + "% chance for double logs");
                    break;
                }
                case "Farmer": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Farmer.double_drop_chance_per_level", 1.0) + "% chance for double crops");
                    break;
                }
                case "Smelting Expert": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.SmeltingExpert.auto_smelt_chance_per_level", 1.0) + "% chance to auto-smelt ores");
                    break;
                }
                case "Excavator": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Excavator.bonus_loot_chance_per_level", 1.0) + "% chance for bonus loot");
                    break;
                }
                case "Fisherman": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Fisherman.double_catch_chance_per_level", 1.0) + "% chance for double fish/loot");
                    break;
                }
                case "Swordsman": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.plugin.getConfig().getDouble("skills.Swordsman.damage_bonus_per_level", 0.1) + " sword damage");
                    break;
                }
                case "Archer": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Archer.double_damage_chance_per_level", 1.0) + "% chance for double damage");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Archer.arrow_retrieval_chance_multiplier", 5.0) + "% arrow retrieval chance");
                    break;
                }
                case "Alchemist": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Alchemist.double_potion_chance_per_level", 1.0) + "% chance for double potions");
                    break;
                }
                case "Defense": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Defense.damage_reduction_per_level", 0.005) * 100.0 + "% damage reduction");
                    break;
                }
                case "Hunter": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Hunter.double_drop_chance_per_level", 1.0) + "% chance for double mob drops");
                    break;
                }
                case "Looter": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Looter.bonus_loot_chance_per_level", 1.0) + "% chance for bonus chest loot");
                    break;
                }
                case "Recycler": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Recycler.refund_chance_per_level", 1.0) + "% chance to refund items when crafting");
                    break;
                }
                case "Acrobat": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Acrobat.fall_damage_reduction_per_level", 0.01) * 100.0 + "% fall damage reduction");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.plugin.getConfig().getDouble("skills.Acrobat.speed_bonus_per_level", 0.001) * 100.0 + "% movement speed");
                    break;
                }
                case "Beastmaster": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.plugin.getConfig().getDouble("skills.Beastmaster.bonus_health_per_level", 0.5) + " bonus health for tamed animals");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.plugin.getConfig().getDouble("skills.Beastmaster.bonus_damage_per_level", 0.1) + " bonus damage for tamed animals");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.plugin.getConfig().getDouble("skills.Beastmaster.twin_chance_per_level", 0.5) + "% chance to breed twins");
                    break;
                }
                case "Enchanter": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: Improved enchantments and reduced enchanting cost.");
                    break;
                }
                case "Rider": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: Faster mounts and reduced food consumption for ridden entities.");
                    break;
                }
                case "Demolitionist": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: Increased blast radius and no self-damage from explosions.");
                    break;
                }
                case "Merchant": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: Better trades with villagers and a chance for bargain prices.");
                }
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            gui.setItem(slot, item);
        }
    }

    private String getProgressBar(int current, int max) {
        int bars = (int)((double)current / (double)max * 20.0);
        StringBuilder progress = new StringBuilder(String.valueOf(ChatColor.GRAY) + "[");
        progress.append(ChatColor.GREEN);
        for (int i = 0; i < 20; ++i) {
            progress.append(i < bars ? "|" : " ");
        }
        progress.append(ChatColor.GRAY).append("] ").append((int)((double)current / (double)max * 100.0)).append("%");
        return progress.toString();
    }

    private void fillWithPanes(Inventory gui) {
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.setDisplayName(" ");
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, filler);
        }
    }

    public List<SkillItem> getAllSkills() {
        return this.allSkills;
    }

    public int getSkillLevel(UUID playerUUID, Skill skill) {
        return this.plugin.getSkillsConfig().getInt(playerUUID.toString() + "." + skill.getConfigKey() + ".level", 0);
    }

    public int getSkillXp(UUID playerUUID, Skill skill) {
        return this.plugin.getSkillsConfig().getInt(playerUUID.toString() + "." + skill.getConfigKey() + ".xp", 0);
    }

    public void setSkillLevel(UUID playerUUID, Skill skill, int level) {
        this.plugin.getSkillsConfig().set(playerUUID.toString() + "." + skill.getConfigKey() + ".level", (Object)level);
        this.plugin.getSkillsConfig().set(playerUUID.toString() + "." + skill.getConfigKey() + ".xp", (Object)0);
        this.plugin.saveSkillsConfig();
    }

    public void setSkillXp(UUID playerUUID, Skill skill, int xp) {
        this.plugin.getSkillsConfig().set(playerUUID.toString() + "." + skill.getConfigKey() + ".xp", (Object)xp);
        this.plugin.saveSkillsConfig();
    }

    public Map<Skill, Integer> getPlayerSkillLevels(UUID playerUUID) {
        HashMap<Skill, Integer> skillLevels = new HashMap<Skill, Integer>();
        for (Skill skill : Skill.values()) {
            skillLevels.put(skill, this.getSkillLevel(playerUUID, skill));
        }
        return skillLevels;
    }

    public static class SkillItem {
        Material material;
        String name;
        String configKey;

        public SkillItem(Material material, String name, String configKey) {
            this.material = material;
            this.name = name;
            this.configKey = configKey;
        }
    }

    public static enum Skill {
        ORE_MINER("OreMiner", "Ore Miner"),
        TREE_FELLER("TreeFeller", "Tree Feller"),
        FARMER("Farmer", "Farmer"),
        SMELTING_EXPERT("SmeltingExpert", "Smelting Expert"),
        EXCAVATOR("Excavator", "Excavator"),
        FISHERMAN("Fisherman", "Fisherman"),
        SWORDSMAN("Swordsman", "Swordsman"),
        ARCHER("Archer", "Archer"),
        ALCHEMIST("Alchemist", "Alchemist"),
        DEFENSE("Defense", "Defense"),
        HUNTER("Hunter", "Hunter"),
        LOOTER("Looter", "Looter"),
        RECYCLER("Recycler", "Recycler"),
        ACROBAT("Acrobat", "Acrobat"),
        BEASTMASTER("Beastmaster", "Beastmaster"),
        ENCHANTER("Enchanter", "Enchanter"),
        RIDER("Rider", "Rider"),
        DEMOLITIONIST("Demolitionist", "Demolitionist"),
        MERCHANT("Merchant", "Merchant");

        private final String configKey;
        private final String displayName;

        private Skill(String configKey, String displayName) {
            this.configKey = configKey;
            this.displayName = displayName;
        }

        public String getConfigKey() {
            return this.configKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

