/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Hopper;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SkillForge999
extends JavaPlugin
implements Listener {
    private static final Map<String, Material> AUTO_SMELT_MAP = SkillForge999.createAutoSmeltMap();
    private static final Material[] ORES = new Material[]{Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, Material.REDSTONE_ORE, Material.LAPIS_ORE, Material.EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_COPPER_ORE, Material.ANCIENT_DEBRIS};
    private final Map<UUID, Long> lastXpGain = new ConcurrentHashMap<UUID, Long>();
    private final Map<Location, UUID> brewingStandLastUser = new ConcurrentHashMap<Location, UUID>();
    private YamlConfiguration skillsConfig;
    private File skillsFile;
    private boolean debugMode = false;
    private final List<SkillItem> allSkills = Arrays.asList(new SkillItem(Material.DIAMOND_PICKAXE, "Ore Miner", "OreMiner"), new SkillItem(Material.DIAMOND_AXE, "Tree Feller", "TreeFeller"), new SkillItem(Material.DIAMOND_HOE, "Farmer", "Farmer"), new SkillItem(Material.FURNACE, "Smelting Expert", "SmeltingExpert"), new SkillItem(Material.DIAMOND_SHOVEL, "Excavator", "Excavator"), new SkillItem(Material.FISHING_ROD, "Fisherman", "Fisherman"), new SkillItem(Material.DIAMOND_SWORD, "Swordsman", "Swordsman"), new SkillItem(Material.BOW, "Archer", "Archer"), new SkillItem(Material.BREWING_STAND, "Alchemist", "Alchemist"), new SkillItem(Material.SHIELD, "Defense", "Defense"), new SkillItem(Material.BEEF, "Hunter", "Hunter"), new SkillItem(Material.CHEST, "Looter", "Looter"), new SkillItem(Material.FURNACE, "Recycler", "Recycler"), new SkillItem(Material.FEATHER, "Acrobat", "Acrobat"), new SkillItem(Material.BONE, "Beastmaster", "Beastmaster"));

    public void onEnable() {
        String[] skillNames;
        this.saveDefaultConfig();
        this.reloadConfig();
        for (String skill : skillNames = new String[]{"OreMiner", "TreeFeller", "Farmer", "SmeltingExpert", "Excavator", "Fisherman", "Swordsman", "Archer", "Alchemist", "Defense", "Hunter", "Looter", "Recycler", "Acrobat", "Beastmaster"}) {
            if (this.getConfig().contains("skills." + skill + ".xp_per_action")) continue;
            this.getConfig().set("skills." + skill + ".xp_per_action", (Object)1);
        }
        if (!this.getConfig().contains("skills.OreMiner.double_drop_chance_per_level")) {
            this.getConfig().set("skills.OreMiner.double_drop_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.TreeFeller.double_drop_chance_per_level")) {
            this.getConfig().set("skills.TreeFeller.double_drop_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Farmer.double_drop_chance_per_level")) {
            this.getConfig().set("skills.Farmer.double_drop_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.SmeltingExpert.auto_smelt_chance_per_level")) {
            this.getConfig().set("skills.SmeltingExpert.auto_smelt_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Excavator.bonus_loot_chance_per_level")) {
            this.getConfig().set("skills.Excavator.bonus_loot_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Fisherman.double_catch_chance_per_level")) {
            this.getConfig().set("skills.Fisherman.double_catch_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Swordsman.damage_bonus_per_level")) {
            this.getConfig().set("skills.Swordsman.damage_bonus_per_level", (Object)0.1);
        }
        if (!this.getConfig().contains("skills.Archer.double_damage_chance_per_level")) {
            this.getConfig().set("skills.Archer.double_damage_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Archer.arrow_retrieval_chance_multiplier")) {
            this.getConfig().set("skills.Archer.arrow_retrieval_chance_multiplier", (Object)5.0);
        }
        if (!this.getConfig().contains("skills.Alchemist.double_potion_chance_per_level")) {
            this.getConfig().set("skills.Alchemist.double_potion_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Defense.damage_reduction_per_level")) {
            this.getConfig().set("skills.Defense.damage_reduction_per_level", (Object)0.005);
        }
        if (!this.getConfig().contains("skills.Hunter.double_drop_chance_per_level")) {
            this.getConfig().set("skills.Hunter.double_drop_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Looter.bonus_loot_chance_per_level")) {
            this.getConfig().set("skills.Looter.bonus_loot_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Recycler.refund_chance_per_level")) {
            this.getConfig().set("skills.Recycler.refund_chance_per_level", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Acrobat.xp_per_fall_damage")) {
            this.getConfig().set("skills.Acrobat.xp_per_fall_damage", (Object)1.0);
        }
        if (!this.getConfig().contains("skills.Acrobat.fall_damage_reduction_per_level")) {
            this.getConfig().set("skills.Acrobat.fall_damage_reduction_per_level", (Object)0.01);
        }
        if (!this.getConfig().contains("skills.Acrobat.speed_bonus_per_level")) {
            this.getConfig().set("skills.Acrobat.speed_bonus_per_level", (Object)0.001);
        }
        if (!this.getConfig().contains("skills.Beastmaster.xp_per_tame")) {
            this.getConfig().set("skills.Beastmaster.xp_per_tame", (Object)10);
        }
        if (!this.getConfig().contains("skills.Beastmaster.xp_per_breed")) {
            this.getConfig().set("skills.Beastmaster.xp_per_breed", (Object)5);
        }
        if (!this.getConfig().contains("skills.Beastmaster.bonus_health_per_level")) {
            this.getConfig().set("skills.Beastmaster.bonus_health_per_level", (Object)0.5);
        }
        if (!this.getConfig().contains("skills.Beastmaster.bonus_damage_per_level")) {
            this.getConfig().set("skills.Beastmaster.bonus_damage_per_level", (Object)0.1);
        }
        if (!this.getConfig().contains("skills.Beastmaster.twin_chance_per_level")) {
            this.getConfig().set("skills.Beastmaster.twin_chance_per_level", (Object)0.5);
        }
        this.saveConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.skillsFile = new File(this.getDataFolder(), "skills.yml");
        if (!this.skillsFile.exists()) {
            try {
                this.skillsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create skills.yml!");
                return;
            }
        }
        this.skillsConfig = YamlConfiguration.loadConfiguration((File)this.skillsFile);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("skillforge").setExecutor((CommandExecutor)this);
        this.getCommand("sf").setExecutor((CommandExecutor)this);
        this.getCommand("sfdebug").setExecutor((CommandExecutor)this);
        this.startAutoSaveTask();
        this.getLogger().info("SkillForge999 enabled successfully!");
    }

    public void onDisable() {
        this.saveSkillsConfig();
        this.getLogger().info("SkillForge999 disabled successfully!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("sfdebug")) {
            if (player.hasPermission("skillforge.debug")) {
                this.debugMode = !this.debugMode;
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "Debug mode " + (this.debugMode ? "enabled" : "disabled"));
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.openSkillsInventory(player, 0);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload") && player.hasPermission("skillforge.reload")) {
            this.reloadConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "SkillForge999 config reloaded!");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " [reload]");
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String uuid = player.getUniqueId().toString();
        if (!this.skillsConfig.contains(uuid)) {
            this.initializePlayerData(uuid);
            if (this.debugMode) {
                this.getLogger().info("Initialized new player data for " + player.getName());
            }
        }
        this.updatePlayerSpeed(player);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        if (player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH)) {
            return;
        }
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        if (this.isOre(material)) {
            this.handleOreMiner(player, event, uuid, material);
        } else if (this.isLog(material)) {
            this.handleTreeFeller(player, event, uuid);
        } else if (this.isCrop(material)) {
            this.handleFarmer(player, event, uuid);
        } else if (this.isExcavationMaterial(material)) {
            this.handleExcavator(player, event, uuid);
        }
    }

    @EventHandler
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        Player player = event.getPlayer();
        int xp = event.getExpToDrop();
        if (xp > 0 && !this.shouldSkipXpGain(player.getUniqueId())) {
            String uuid = player.getUniqueId().toString();
            this.addXp(uuid, "SmeltingExpert", this.getConfigXp("SmeltingExpert") * xp, player, false);
        }
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH && !this.shouldSkipXpGain(event.getPlayer().getUniqueId())) {
            int fisherLevel;
            Player player = event.getPlayer();
            String uuid = player.getUniqueId().toString();
            boolean leveledUp = this.addXp(uuid, "Fisherman", this.getConfigXp("Fisherman"), player, false);
            if (leveledUp) {
                this.sendLevelUpMessage(player, "Fisherman");
            }
            if ((fisherLevel = this.skillsConfig.getInt(uuid + ".Fisherman.level", 0)) > 0 && Math.random() * 100.0 < (double)fisherLevel * this.getConfig().getDouble("skills.Fisherman.double_catch_chance_per_level", 1.0) && event.getCaught() instanceof Item) {
                Item caught = (Item)event.getCaught();
                ItemStack item = caught.getItemStack();
                item.setAmount(item.getAmount() * 2);
                caught.setItemStack(item);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.BREWING_STAND) {
            this.brewingStandLastUser.put(event.getClickedBlock().getLocation(), event.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onPotionBrew(BrewEvent event) {
        int alchemistLevel;
        Location loc = event.getContents().getHolder().getLocation();
        if (loc == null) {
            return;
        }
        UUID userUUID = this.brewingStandLastUser.get(loc);
        if (userUUID == null) {
            return;
        }
        Player player = this.getServer().getPlayer(userUUID);
        if (player == null || this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        boolean leveledUp = this.addXp(uuid, "Alchemist", this.getConfigXp("Alchemist"), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Alchemist");
        }
        if ((alchemistLevel = this.skillsConfig.getInt(uuid + ".Alchemist.level", 0)) > 0) {
            Random random = new Random();
            if ((double)random.nextInt(100) < (double)alchemistLevel * this.getConfig().getDouble("skills.Alchemist.double_potion_chance_per_level", 1.0)) {
                for (ItemStack result : event.getResults()) {
                    if (result == null) continue;
                    result.setAmount(result.getAmount() * 2);
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GRAY) + "SkillForge - Skills")) {
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta()) {
                return;
            }
            String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
            int currentPage = 0;
            if (title.contains("Page")) {
                try {
                    currentPage = Integer.parseInt(title.replaceAll("[^0-9]", "")) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (name.equalsIgnoreCase("Next Page")) {
                this.openSkillsInventory(player, currentPage + 1);
            } else if (name.equalsIgnoreCase("Previous Page")) {
                this.openSkillsInventory(player, currentPage - 1);
            } else if (clicked.getType() == Material.BARRIER) {
                player.closeInventory();
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player owner;
        String uuid;
        int beastmasterLevel;
        Tameable tameable;
        if (event.getDamager() instanceof Player) {
            boolean leveledUp;
            Player player = (Player)event.getDamager();
            ItemStack weapon = player.getInventory().getItemInMainHand();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid2 = player.getUniqueId().toString();
            if (weapon.getType().toString().endsWith("_SWORD")) {
                int swordsmanLevel;
                leveledUp = this.addXp(uuid2, "Swordsman", this.getConfigXp("Swordsman"), player, false);
                if (leveledUp) {
                    this.sendLevelUpMessage(player, "Swordsman");
                }
                if ((swordsmanLevel = this.skillsConfig.getInt(uuid2 + ".Swordsman.level", 0)) > 0) {
                    event.setDamage(event.getDamage() + (double)swordsmanLevel * this.getConfig().getDouble("skills.Swordsman.damage_bonus_per_level", 0.1));
                }
            }
            if (event.getEntity() instanceof Animals) {
                int hunterLevel;
                leveledUp = this.addXp(uuid2, "Hunter", this.getConfigXp("Hunter"), player, false);
                if (leveledUp) {
                    this.sendLevelUpMessage(player, "Hunter");
                }
                if ((hunterLevel = this.skillsConfig.getInt(uuid2 + ".Hunter.level", 0)) > 0 && Math.random() * 100.0 < (double)hunterLevel * this.getConfig().getDouble("skills.Hunter.double_drop_chance_per_level", 1.0)) {
                    final LivingEntity entity = (LivingEntity)event.getEntity();
                    new BukkitRunnable(){

                        public void run() {
                            List<ItemStack> drops = entity instanceof Animals ? SkillForge999.this.getEntityDrops(entity) : Collections.emptyList();
                            for (ItemStack drop : drops) {
                                ItemStack doubled = drop.clone();
                                doubled.setAmount(drop.getAmount());
                                entity.getWorld().dropItemNaturally(entity.getLocation(), doubled);
                            }
                        }
                    }.runTask((Plugin)this);
                }
            }
        } else if (event.getDamager() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getDamager();
            if (arrow.getShooter() instanceof Player) {
                int archerLevel;
                Player player = (Player)arrow.getShooter();
                if (this.shouldSkipXpGain(player.getUniqueId())) {
                    return;
                }
                String uuid3 = player.getUniqueId().toString();
                boolean leveledUp = this.addXp(uuid3, "Archer", this.getConfigXp("Archer"), player, false);
                if (leveledUp) {
                    this.sendLevelUpMessage(player, "Archer");
                }
                if ((archerLevel = this.skillsConfig.getInt(uuid3 + ".Archer.level", 0)) > 0) {
                    Random random = new Random();
                    if ((double)random.nextInt(100) < (double)archerLevel * this.getConfig().getDouble("skills.Archer.double_damage_chance_per_level", 1.0)) {
                        event.setDamage(event.getDamage() * 2.0);
                    }
                    Random random2 = new Random();
                    if ((double)random2.nextInt(100) < (double)archerLevel * this.getConfig().getDouble("skills.Archer.arrow_retrieval_chance_multiplier", 5.0)) {
                        player.getWorld().dropItemNaturally(player.getLocation(), new ItemStack(Material.ARROW));
                    }
                }
            }
        } else if (event.getDamager() instanceof Tameable && (tameable = (Tameable)event.getDamager()).isTamed() && tameable.getOwner() instanceof Player && (beastmasterLevel = this.skillsConfig.getInt((uuid = (owner = (Player)tameable.getOwner()).getUniqueId().toString()) + ".Beastmaster.level", 0)) > 0) {
            double bonusDamage = (double)beastmasterLevel * this.getConfig().getDouble("skills.Beastmaster.bonus_damage_per_level", 0.1);
            event.setDamage(event.getDamage() + bonusDamage);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            boolean leveledUp;
            Player player = (Player)event.getEntity();
            String uuid = player.getUniqueId().toString();
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                int acrobatLevel;
                boolean leveledUp2;
                int xpGained;
                if (!this.shouldSkipXpGain(player.getUniqueId()) && (xpGained = (int)(event.getDamage() * this.getConfig().getDouble("skills.Acrobat.xp_per_fall_damage", 1.0))) > 0 && (leveledUp2 = this.addXp(uuid, "Acrobat", xpGained, player, false))) {
                    this.sendLevelUpMessage(player, "Acrobat");
                }
                if ((acrobatLevel = this.skillsConfig.getInt(uuid + ".Acrobat.level", 0)) > 0) {
                    double reduction = (double)acrobatLevel * this.getConfig().getDouble("skills.Acrobat.fall_damage_reduction_per_level", 0.01);
                    event.setDamage(event.getDamage() * (1.0 - reduction));
                }
            } else if (!this.shouldSkipXpGain(player.getUniqueId()) && (leveledUp = this.addXp(uuid, "Defense", this.getConfigXp("Defense"), player, false))) {
                this.sendLevelUpMessage(player, "Defense");
            }
            int defenseLevel = this.skillsConfig.getInt(uuid + ".Defense.level", 0);
            if (defenseLevel > 0) {
                double reduction = (double)defenseLevel * this.getConfig().getDouble("skills.Defense.damage_reduction_per_level", 0.005);
                event.setDamage(event.getDamage() * (1.0 - reduction));
            }
        }
    }

    @EventHandler
    public void onXpPickup(PlayerExpChangeEvent event) {
        int level;
        boolean leveledUp;
        Player player = event.getPlayer();
        int xpAmount = event.getAmount();
        UUID uuid = player.getUniqueId();
        if (xpAmount <= 0 || this.shouldSkipXpGain(uuid)) {
            return;
        }
        String id = uuid.toString();
        int convertedXp = xpAmount / 10;
        if (convertedXp > 0 && (leveledUp = this.addXp(id, "Alchemist", this.getConfigXp("Alchemist"), player, false))) {
            this.sendLevelUpMessage(player, "Alchemist");
        }
        if ((level = this.skillsConfig.getInt(id + ".Alchemist.level", 0)) > 0) {
            int bonusXp = (int)Math.floor((double)xpAmount * ((double)level / 100.0));
            event.setAmount(xpAmount + bonusXp);
        }
    }

    @EventHandler
    public void onInventoryOpen(final InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getPlayer();
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder == null) {
            return;
        }
        if (holder instanceof Chest || holder instanceof Barrel || holder instanceof Dispenser || holder instanceof Dropper || holder instanceof Furnace || holder instanceof Hopper || holder instanceof ShulkerBox) {
            int looterLevel;
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            boolean leveledUp = this.addXp(uuid, "Looter", this.getConfig().getInt("skills.Looter.xp_per_action", 1), player, false);
            if (leveledUp) {
                this.sendLevelUpMessage(player, "Looter");
            }
            if ((looterLevel = this.skillsConfig.getInt(uuid + ".Looter.level", 0)) > 0) {
                int chance = (int)((double)looterLevel * this.getConfig().getDouble("skills.Looter.bonus_loot_chance_per_level", 1.0));
                if (new Random().nextInt(100) < chance) {
                    new BukkitRunnable(){

                        public void run() {
                            Inventory inv = event.getInventory();
                            ArrayList<ItemStack> bonusItems = new ArrayList<ItemStack>();
                            for (ItemStack item : inv.getContents()) {
                                if (item == null || item.getType() == Material.AIR) continue;
                                ItemStack bonus = item.clone();
                                bonus.setAmount(1 + new Random().nextInt(2));
                                bonusItems.add(bonus);
                            }
                            for (ItemStack bonus : bonusItems) {
                                player.getWorld().dropItemNaturally(player.getLocation(), bonus);
                            }
                        }
                    }.runTask((Plugin)this);
                }
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        int recyclerLevel;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.shouldSkipXpGain(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        boolean leveledUp = this.addXp(uuid, "Recycler", this.getConfig().getInt("skills.Recycler.xp_per_action", 1), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Recycler");
        }
        if ((recyclerLevel = this.skillsConfig.getInt(uuid + ".Recycler.level", 0)) > 0) {
            int refundChance = (int)((double)recyclerLevel * this.getConfig().getDouble("skills.Recycler.refund_chance_per_level", 1.0));
            Random random = new Random();
            int refundCount = 1 + random.nextInt(2);
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                if (event.getInventory().getItem(i) == null || event.getInventory().getItem(i).getType() == Material.AIR) continue;
                slots.add(i);
            }
            Collections.shuffle(slots);
            int refunded = 0;
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                ItemStack item;
                int slot = (Integer)iterator.next();
                if (refunded >= refundCount) break;
                if (random.nextInt(100) >= refundChance || (item = event.getInventory().getItem(slot)) == null) continue;
                ItemStack refund = item.clone();
                refund.setAmount(1);
                player.getInventory().addItem(new ItemStack[]{refund});
                ++refunded;
            }
        }
    }

    @EventHandler
    public void onEntityTame(EntityTameEvent event) {
        if (event.getOwner() instanceof Player) {
            LivingEntity tamed;
            AttributeInstance maxHealth;
            int beastmasterLevel;
            Player player = (Player)event.getOwner();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            boolean leveledUp = this.addXp(uuid, "Beastmaster", this.getConfig().getInt("skills.Beastmaster.xp_per_tame", 10), player, false);
            if (leveledUp) {
                this.sendLevelUpMessage(player, "Beastmaster");
            }
            if ((beastmasterLevel = this.skillsConfig.getInt(uuid + ".Beastmaster.level", 0)) > 0 && (maxHealth = (tamed = event.getEntity()).getAttribute(Attribute.MAX_HEALTH)) != null) {
                double bonusHealth = (double)beastmasterLevel * this.getConfig().getDouble("skills.Beastmaster.bonus_health_per_level", 0.5);
                maxHealth.setBaseValue(maxHealth.getBaseValue() + bonusHealth);
                tamed.setHealth(maxHealth.getBaseValue());
            }
        }
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        if (event.getBreeder() instanceof Player) {
            int beastmasterLevel;
            Player player = (Player)event.getBreeder();
            if (this.shouldSkipXpGain(player.getUniqueId())) {
                return;
            }
            String uuid = player.getUniqueId().toString();
            boolean leveledUp = this.addXp(uuid, "Beastmaster", this.getConfig().getInt("skills.Beastmaster.xp_per_breed", 5), player, false);
            if (leveledUp) {
                this.sendLevelUpMessage(player, "Beastmaster");
            }
            if ((beastmasterLevel = this.skillsConfig.getInt(uuid + ".Beastmaster.level", 0)) > 0) {
                double twinChance = (double)beastmasterLevel * this.getConfig().getDouble("skills.Beastmaster.twin_chance_per_level", 0.5);
                Random random = new Random();
                if (random.nextDouble() * 100.0 < twinChance) {
                    event.getEntity().getWorld().spawnEntity(event.getEntity().getLocation(), event.getEntityType());
                }
            }
        }
    }

    private Collection<ItemStack> getEntityDrops(LivingEntity entity) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        EntityType type = entity.getType();
        switch (type) {
            case COW: {
                drops.add(new ItemStack(Material.LEATHER, 1));
                drops.add(new ItemStack(Material.BEEF, 1));
                break;
            }
            case SHEEP: {
                drops.add(new ItemStack(Material.WHITE_WOOL, 1));
                drops.add(new ItemStack(Material.MUTTON, 1));
                break;
            }
            case PIG: {
                drops.add(new ItemStack(Material.PORKCHOP, 1));
                break;
            }
            case CHICKEN: {
                drops.add(new ItemStack(Material.CHICKEN, 1));
                drops.add(new ItemStack(Material.FEATHER, 1));
                break;
            }
        }
        return drops;
    }

    private void initializePlayerData(String uuid) {
        HashMap<CallSite, Integer> defaultData = new HashMap<CallSite, Integer>();
        for (String skill : new String[]{"OreMiner", "TreeFeller", "Farmer", "SmeltingExpert", "Excavator", "Fisherman", "Swordsman", "Archer", "Alchemist", "Defense", "Hunter", "Looter", "Recycler", "Acrobat", "Beastmaster"}) {
            defaultData.put((CallSite)((Object)(skill + ".level")), 0);
            defaultData.put((CallSite)((Object)(skill + ".xp")), 0);
        }
        this.skillsConfig.createSection(uuid, defaultData);
        this.saveSkillsConfig();
    }

    private boolean shouldSkipXpGain(UUID uuid) {
        long now = System.currentTimeMillis();
        Long lastTime = this.lastXpGain.get(uuid);
        if (lastTime != null && now - lastTime < 50L) {
            return true;
        }
        this.lastXpGain.put(uuid, now);
        return false;
    }

    private void handleOreMiner(Player player, BlockBreakEvent event, String uuid, Material material) {
        int oreMinerLevel;
        int smeltingExpertLevel;
        boolean leveledUp = this.addXp(uuid, "OreMiner", this.getConfigXp("OreMiner"), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Ore Miner");
        }
        if ((smeltingExpertLevel = this.skillsConfig.getInt(uuid + ".SmeltingExpert.level", 0)) > 0 && AUTO_SMELT_MAP.containsKey(material.name())) {
            Random random = new Random();
            if ((double)random.nextInt(100) < (double)smeltingExpertLevel * this.getConfig().getDouble("skills.SmeltingExpert.auto_smelt_chance_per_level", 1.0)) {
                event.setDropItems(false);
                Material smeltedMaterial = AUTO_SMELT_MAP.get(material.name());
                if (smeltedMaterial != null) {
                    player.getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(smeltedMaterial, 1));
                    this.addXp(uuid, "SmeltingExpert", this.getConfigXp("SmeltingExpert"), player, false);
                }
                return;
            }
        }
        if ((oreMinerLevel = this.skillsConfig.getInt(uuid + ".OreMiner.level", 0)) <= 0) {
            return;
        }
        double oreMinerChance = (double)oreMinerLevel * this.getConfig().getDouble("skills.OreMiner.double_drop_chance_per_level", 1.0);
        Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
        for (ItemStack drop : drops) {
            if (!(Math.random() * 100.0 < oreMinerChance)) continue;
            ItemStack doubleDrop = drop.clone();
            doubleDrop.setAmount(drop.getAmount() * 2);
            player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
        }
    }

    private void handleTreeFeller(Player player, BlockBreakEvent event, String uuid) {
        int treeFellerLevel;
        boolean leveledUp = this.addXp(uuid, "TreeFeller", this.getConfigXp("TreeFeller"), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Tree Feller");
        }
        if ((treeFellerLevel = this.skillsConfig.getInt(uuid + ".TreeFeller.level", 0)) > 0) {
            Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
            for (ItemStack drop : drops) {
                Random random = new Random();
                if (!((double)random.nextInt(100) < (double)treeFellerLevel * this.getConfig().getDouble("skills.TreeFeller.double_drop_chance_per_level", 1.0))) continue;
                ItemStack doubleDrop = drop.clone();
                doubleDrop.setAmount(drop.getAmount() * 2);
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
            }
        }
    }

    private void handleFarmer(Player player, BlockBreakEvent event, String uuid) {
        int farmerLevel;
        boolean leveledUp = this.addXp(uuid, "Farmer", this.getConfigXp("Farmer"), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Farmer");
        }
        if ((farmerLevel = this.skillsConfig.getInt(uuid + ".Farmer.level", 0)) > 0) {
            Collection drops = event.getBlock().getDrops();
            for (ItemStack drop : drops) {
                Random random = new Random();
                if (!((double)random.nextInt(100) < (double)farmerLevel * this.getConfig().getDouble("skills.Farmer.double_drop_chance_per_level", 1.0))) continue;
                ItemStack doubleDrop = drop.clone();
                doubleDrop.setAmount(drop.getAmount() * 2);
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), doubleDrop);
            }
        }
    }

    private void handleExcavator(Player player, BlockBreakEvent event, String uuid) {
        int excavatorLevel;
        boolean leveledUp = this.addXp(uuid, "Excavator", this.getConfigXp("Excavator"), player, false);
        if (leveledUp) {
            this.sendLevelUpMessage(player, "Excavator");
        }
        if ((excavatorLevel = this.skillsConfig.getInt(uuid + ".Excavator.level", 0)) > 0) {
            Random random;
            double lootChance;
            ItemStack bonusLoot;
            Random random2 = new Random();
            if ((double)random2.nextInt(100) < (double)excavatorLevel * this.getConfig().getDouble("skills.Excavator.bonus_loot_chance_per_level", 1.0) && (bonusLoot = this.getExcavatorBonusLoot(lootChance = (random = new Random()).nextDouble() * 100.0, random)) != null) {
                player.getWorld().dropItemNaturally(event.getBlock().getLocation(), bonusLoot);
            }
        }
    }

    private ItemStack getExcavatorBonusLoot(double chance, Random random) {
        if (chance <= 40.0) {
            return new ItemStack(Material.BONE, random.nextInt(2) + 1);
        }
        if (chance <= 60.0) {
            return new ItemStack(Material.ROTTEN_FLESH, random.nextInt(2) + 1);
        }
        if (chance <= 70.0) {
            return new ItemStack(Material.LEATHER);
        }
        if (chance <= 85.0) {
            return new ItemStack(Material.IRON_NUGGET);
        }
        if (chance <= 95.0) {
            return new ItemStack(Material.EMERALD);
        }
        return new ItemStack(Material.DIAMOND);
    }

    private boolean addXp(String uuid, String skillName, int xpToAdd, Player player, boolean isAsync) {
        int newXp;
        int currentLevel = this.skillsConfig.getInt(uuid + "." + skillName + ".level", 0);
        int currentXp = this.skillsConfig.getInt(uuid + "." + skillName + ".xp", 0);
        int xpNeeded = Math.max(currentLevel * 10, 10);
        boolean leveledUp = false;
        for (newXp = currentXp + xpToAdd; newXp >= xpNeeded && xpNeeded > 0; newXp -= xpNeeded) {
            xpNeeded = ++currentLevel * 10;
            leveledUp = true;
        }
        this.skillsConfig.set(uuid + "." + skillName + ".level", (Object)currentLevel);
        this.skillsConfig.set(uuid + "." + skillName + ".xp", (Object)newXp);
        if (isAsync) {
            new BukkitRunnable(){

                public void run() {
                    SkillForge999.this.saveSkillsConfig();
                }
            }.runTask((Plugin)this);
        }
        if (this.debugMode && !isAsync) {
            this.getLogger().info(String.format("%s gained %d XP in %s (Level: %d, XP: %d/%d)", player.getName(), xpToAdd, skillName, currentLevel, newXp, xpNeeded));
        }
        return leveledUp;
    }

    private void sendLevelUpMessage(Player player, String skillName) {
        int level = this.skillsConfig.getInt(String.valueOf(player.getUniqueId()) + "." + skillName.replace(" ", "") + ".level", 1);
        player.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "SKILL LEVEL UP! " + String.valueOf(ChatColor.YELLOW) + skillName + " " + String.valueOf(ChatColor.GOLD) + "[" + level + "]");
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        if (skillName.equalsIgnoreCase("Acrobat")) {
            this.updatePlayerSpeed(player);
        }
    }

    public void openSkillsInventory(Player player, int page) {
        ItemStack closeButton;
        ItemMeta closeMeta;
        int skillsPerPage = 21;
        int totalPages = (int)Math.ceil((double)this.allSkills.size() / (double)skillsPerPage);
        page = Math.max(0, Math.min(page, totalPages - 1));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GRAY) + "SkillForge - Skills (Page " + (page + 1) + ")"));
        String uuid = player.getUniqueId().toString();
        int start = page * skillsPerPage;
        int end = Math.min(start + skillsPerPage, this.allSkills.size());
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        for (int i = start; i < end; ++i) {
            SkillItem skill = this.allSkills.get(i);
            this.addSkillItem(gui, slots[i - start], skill.material, skill.name, uuid, skill.configKey);
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
                prev.setItemMeta(prevMeta);
            }
            gui.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
                next.setItemMeta(nextMeta);
            }
            gui.setItem(53, next);
        }
        if ((closeMeta = (closeButton = new ItemStack(Material.BARRIER)).getItemMeta()) != null) {
            closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close Menu");
            closeButton.setItemMeta(closeMeta);
        }
        gui.setItem(49, closeButton);
        this.fillWithPanes(gui);
        player.openInventory(gui);
    }

    private void addSkillItem(Inventory gui, int slot, Material material, String name, String uuid, String configKey) {
        int level = this.skillsConfig.getInt(uuid + "." + configKey + ".level", 0);
        int xp = this.skillsConfig.getInt(uuid + "." + configKey + ".xp", 0);
        int nextLevelXp = Math.max(level * 10, 10);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + name);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(ChatColor.GRAY) + "Level: " + String.valueOf(ChatColor.GREEN) + level);
            lore.add(String.valueOf(ChatColor.GRAY) + "XP: " + String.valueOf(ChatColor.AQUA) + xp + "/" + nextLevelXp);
            lore.add(this.getProgressBar(xp, nextLevelXp));
            switch (name) {
                case "Ore Miner": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.OreMiner.double_drop_chance_per_level", 1.0) + "% chance for double ores");
                    break;
                }
                case "Tree Feller": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.TreeFeller.double_drop_chance_per_level", 1.0) + "% chance for double logs");
                    break;
                }
                case "Farmer": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Farmer.double_drop_chance_per_level", 1.0) + "% chance for double crops");
                    break;
                }
                case "Smelting Expert": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.SmeltingExpert.auto_smelt_chance_per_level", 1.0) + "% chance to auto-smelt ores");
                    break;
                }
                case "Excavator": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Excavator.bonus_loot_chance_per_level", 1.0) + "% chance for bonus loot");
                    break;
                }
                case "Fisherman": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Fisherman.double_catch_chance_per_level", 1.0) + "% chance for double fish/loot");
                    break;
                }
                case "Swordsman": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.getConfig().getDouble("skills.Swordsman.damage_bonus_per_level", 0.1) + " sword damage");
                    break;
                }
                case "Archer": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Archer.double_damage_chance_per_level", 1.0) + "% chance for double damage");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Archer.arrow_retrieval_chance_multiplier", 5.0) + "% arrow retrieval chance");
                    break;
                }
                case "Alchemist": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Alchemist.double_potion_chance_per_level", 1.0) + "% chance for double potions");
                    break;
                }
                case "Defense": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Defense.damage_reduction_per_level", 0.005) * 100.0 + "% damage reduction");
                    break;
                }
                case "Hunter": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Hunter.double_drop_chance_per_level", 1.0) + "% chance for double mob drops");
                    break;
                }
                case "Looter": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Looter.bonus_loot_chance_per_level", 1.0) + "% chance for bonus chest loot");
                    break;
                }
                case "Recycler": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Recycler.refund_chance_per_level", 1.0) + "% chance to refund items when crafting");
                    break;
                }
                case "Acrobat": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Acrobat.fall_damage_reduction_per_per_level", 0.01) * 100.0 + "% fall damage reduction");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.getConfig().getDouble("skills.Acrobat.speed_bonus_per_level", 0.001) * 100.0 + "% movement speed");
                    break;
                }
                case "Beastmaster": {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.getConfig().getDouble("skills.Beastmaster.bonus_health_per_level", 0.5) + " bonus health for tamed animals");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: +" + (double)level * this.getConfig().getDouble("skills.Beastmaster.bonus_damage_per_level", 0.1) + " bonus damage for tamed animals");
                    lore.add(String.valueOf(ChatColor.GRAY) + "Effect: " + (double)level * this.getConfig().getDouble("skills.Beastmaster.twin_chance_per_level", 0.5) + "% chance to breed twins");
                }
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            gui.setItem(slot, item);
        }
    }

    private String getProgressBar(int current, int max) {
        int bars = (int)((double)current / (double)max * 20.0);
        StringBuilder progress = new StringBuilder(String.valueOf(ChatColor.GRAY) + "[");
        progress.append(ChatColor.GREEN);
        for (int i = 0; i < 20; ++i) {
            progress.append(i < bars ? "|" : " ");
        }
        progress.append(ChatColor.GRAY).append("] ").append((int)((double)current / (double)max * 100.0)).append("%");
        return progress.toString();
    }

    private void fillWithPanes(Inventory gui) {
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.setDisplayName(" ");
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, filler);
        }
    }

    private void saveSkillsConfig() {
        block3: {
            try {
                this.skillsConfig.save(this.skillsFile);
                if (this.debugMode) {
                    this.getLogger().info("Saved skills.yml successfully");
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Could not save skills.yml!");
                if (!this.debugMode) break block3;
                e.printStackTrace();
            }
        }
    }

    private static Map<String, Material> createAutoSmeltMap() {
        HashMap<String, Material> map = new HashMap<String, Material>();
        map.put("IRON_ORE", Material.IRON_INGOT);
        map.put("GOLD_ORE", Material.GOLD_INGOT);
        map.put("NETHER_GOLD_ORE", Material.GOLD_INGOT);
        map.put("ANCIENT_DEBRIS", Material.NETHERITE_SCRAP);
        map.put("COPPER_ORE", Material.COPPER_INGOT);
        map.put("DEEPSLATE_IRON_ORE", Material.IRON_INGOT);
        map.put("DEEPSLATE_GOLD_ORE", Material.GOLD_INGOT);
        map.put("DEEPSLATE_COPPER_ORE", Material.COPPER_INGOT);
        return map;
    }

    private void startAutoSaveTask() {
        new BukkitRunnable(){

            public void run() {
                SkillForge999.this.saveSkillsConfig();
            }
        }.runTaskTimer((Plugin)this, 1200L, 1200L);
    }

    private int getConfigXp(String skillName) {
        return this.getConfig().getInt("skills." + skillName + ".xp_per_action", 1);
    }

    private boolean isOre(Material material) {
        for (Material ore : ORES) {
            if (material != ore) continue;
            return true;
        }
        return false;
    }

    private boolean isLog(Material material) {
        return material.name().endsWith("_LOG") || material.name().endsWith("_STEM") || material.name().endsWith("_WOOD") || material == Material.MANGROVE_ROOTS;
    }

    private boolean isCrop(Material material) {
        return material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS || material == Material.MELON || material == Material.PUMPKIN || material == Material.SUGAR_CANE || material == Material.COCOA || material == Material.NETHER_WART || material == Material.SWEET_BERRY_BUSH || material == Material.CACTUS || material == Material.KELP;
    }

    private boolean isExcavationMaterial(Material material) {
        return material == Material.DIRT || material == Material.GRASS_BLOCK || material == Material.SAND || material == Material.GRAVEL || material == Material.COARSE_DIRT || material == Material.PODZOL || material == Material.MYCELIUM || material == Material.RED_SAND || material == Material.SOUL_SAND || material == Material.SOUL_SOIL || material == Material.CLAY;
    }

    private void updatePlayerSpeed(Player player) {
        int level = this.skillsConfig.getInt(String.valueOf(player.getUniqueId()) + ".Acrobat.level", 0);
        if (level > 0) {
            double bonus = (double)level * this.getConfig().getDouble("skills.Acrobat.speed_bonus_per_level", 0.001);
            player.setWalkSpeed((float)Math.min(0.2 + bonus, 1.0));
        } else {
            player.setWalkSpeed(0.2f);
        }
    }

    public static class SkillItem {
        Material material;
        String name;
        String configKey;

        public SkillItem(Material material, String name, String configKey) {
            this.material = material;
            this.name = name;
            this.configKey = configKey;
        }
    }
}

