/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.skillforge999;

import com.yourname.skillforge999.Commands;
import com.yourname.skillforge999.Listeners;
import com.yourname.skillforge999.PartyManager;
import com.yourname.skillforge999.SkillManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SkillForge999
extends JavaPlugin {
    private YamlConfiguration skillsConfig;
    private File skillsFile;
    private boolean debugMode = false;
    private static SkillForge999 plugin;
    private SkillManager skillManager;
    private PartyManager partyManager;
    private Commands commands;
    private Listeners listeners;

    public static SkillForge999 getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.reloadConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.skillsFile = new File(this.getDataFolder(), "skills.yml");
        if (!this.skillsFile.exists()) {
            try {
                this.skillsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create skills.yml!");
                return;
            }
        }
        this.skillsConfig = YamlConfiguration.loadConfiguration((File)this.skillsFile);
        this.skillManager = new SkillManager(this);
        this.partyManager = new PartyManager(this);
        this.commands = new Commands(this);
        this.getCommand("skillforge").setExecutor((CommandExecutor)this.commands);
        this.getCommand("sf").setExecutor((CommandExecutor)this.commands);
        this.getCommand("sfdebug").setExecutor((CommandExecutor)this.commands);
        this.getCommand("party").setExecutor((CommandExecutor)this.commands);
        this.getCommand("skill").setExecutor((CommandExecutor)this.commands);
        this.getCommand("sfadmin").setExecutor((CommandExecutor)this.commands);
        this.listeners = new Listeners(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.listeners, (Plugin)this);
        this.startAutoSaveTask();
        this.getLogger().info("SkillForge999 enabled successfully!");
    }

    public void onDisable() {
        this.saveSkillsConfig();
        this.partyManager.saveParties();
        this.getLogger().info("SkillForge999 disabled successfully!");
    }

    public YamlConfiguration getSkillsConfig() {
        return this.skillsConfig;
    }

    public void saveSkillsConfig() {
        block3: {
            try {
                this.skillsConfig.save(this.skillsFile);
                if (this.debugMode) {
                    this.getLogger().info("Saved skills.yml successfully");
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Could not save skills.yml!");
                if (!this.debugMode) break block3;
                e.printStackTrace();
            }
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    private void startAutoSaveTask() {
        new BukkitRunnable(){

            public void run() {
                SkillForge999.this.saveSkillsConfig();
                SkillForge999.this.partyManager.saveParties();
            }
        }.runTaskTimer((Plugin)this, 1200L, 1200L);
    }
}

