/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.client;

import com.diffusehyperion.inertiaanticheat.client.InertiaAntiCheatClient;
import com.diffusehyperion.inertiaanticheat.client.networking.method.TransferHandler;
import com.diffusehyperion.inertiaanticheat.client.networking.method.data.ClientDataTransferHandler;
import com.diffusehyperion.inertiaanticheat.client.networking.method.id.ClientIdTransferHandler;
import com.diffusehyperion.inertiaanticheat.client.networking.method.name.ClientNameTransferHandler;
import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.interfaces.UpgradedClientLoginNetworkHandler;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import com.diffusehyperion.inertiaanticheat.server.networking.method.CheckingTypes;
import io.netty.channel.ChannelFutureListener;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_635;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientLoginModlistTransferHandler {
    private PublicKey serverPublicKey;
    private KeyPair clientKeyPair;

    public static void init() {
        InertiaAntiCheatClient.debugInfo("Creating mod transfer handler");
        ClientLoginNetworking.registerGlobalReceiver((class_2960)InertiaAntiCheatConstants.CHECK_CONNECTION, ClientLoginModlistTransferHandler::confirmConnection);
    }

    private static CompletableFuture<@Nullable class_2540> confirmConnection(class_310 client, class_635 handler, class_2540 buf, Consumer<ChannelFutureListener> callbacksConsumer) {
        UpgradedClientLoginNetworkHandler upgradedHandler = (UpgradedClientLoginNetworkHandler)handler;
        InertiaAntiCheatClient.debugLine();
        InertiaAntiCheatClient.debugInfo("Received request to start mod transfer");
        upgradedHandler.inertiaAntiCheat$getSecondaryStatusConsumer().accept(class_2561.method_30163((String)"Preparing mod transfer..."));
        ClientLoginModlistTransferHandler transferHandler = new ClientLoginModlistTransferHandler();
        ClientLoginNetworking.registerReceiver((class_2960)InertiaAntiCheatConstants.INITIATE_E2EE, transferHandler::exchangeKey);
        return CompletableFuture.completedFuture(PacketByteBufs.empty());
    }

    private CompletableFuture<@Nullable class_2540> exchangeKey(class_310 client, class_635 handler, class_2540 buf, Consumer<ChannelFutureListener> callbacksConsumer) {
        UpgradedClientLoginNetworkHandler upgradedHandler = (UpgradedClientLoginNetworkHandler)handler;
        InertiaAntiCheatClient.debugInfo("Exchanging keys with server");
        upgradedHandler.inertiaAntiCheat$getSecondaryStatusConsumer().accept(class_2561.method_30163((String)"Transferring keys..."));
        this.serverPublicKey = InertiaAntiCheat.retrievePublicKey(buf);
        class_2540 responseBuf = PacketByteBufs.create();
        this.clientKeyPair = InertiaAntiCheat.createRSAPair();
        responseBuf.method_52983(this.clientKeyPair.getPublic().getEncoded());
        ClientLoginNetworking.registerReceiver((class_2960)InertiaAntiCheatConstants.SET_ADAPTOR, this::createAdaptors);
        return CompletableFuture.completedFuture(responseBuf);
    }

    private CompletableFuture<@Nullable class_2540> createAdaptors(class_310 client, class_635 handler, class_2540 buf, Consumer<ChannelFutureListener> callbacksConsumer) {
        UpgradedClientLoginNetworkHandler upgradedHandler = (UpgradedClientLoginNetworkHandler)handler;
        upgradedHandler.inertiaAntiCheat$getSecondaryStatusConsumer().accept(class_2561.method_30163((String)"Starting for mod transfer..."));
        int transferAdaptorIndex = buf.readInt();
        Consumer<class_2561> secondaryStatusConsumer = upgradedHandler.inertiaAntiCheat$getSecondaryStatusConsumer();
        InertiaAntiCheatClient.debugInfo("Received adapter index of " + transferAdaptorIndex);
        CheckingTypes transferAdaptorType = CheckingTypes.values()[transferAdaptorIndex];
        TransferHandler transferAdaptor = switch (transferAdaptorType) {
            default -> throw new MatchException(null, null);
            case CheckingTypes.DATA -> new ClientDataTransferHandler(this.serverPublicKey, InertiaAntiCheatConstants.SEND_MOD, secondaryStatusConsumer);
            case CheckingTypes.NAME -> new ClientNameTransferHandler(this.serverPublicKey, InertiaAntiCheatConstants.SEND_MOD, secondaryStatusConsumer);
            case CheckingTypes.ID -> new ClientIdTransferHandler(this.serverPublicKey, InertiaAntiCheatConstants.SEND_MOD, secondaryStatusConsumer);
        };
        ClientLoginConnectionEvents.DISCONNECT.register(transferAdaptor::onDisconnect);
        InertiaAntiCheatClient.debugInfo("Registered new handler for channel");
        InertiaAntiCheatClient.debugLine();
        return CompletableFuture.completedFuture(PacketByteBufs.empty());
    }
}

