/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.client.networking.method;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import io.netty.channel.ChannelFutureListener;
import java.security.PublicKey;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_635;

@Environment(value=EnvType.CLIENT)
public abstract class TransferHandler {
    protected final PublicKey publicKey;
    protected final class_2960 modTransferID;
    protected final Consumer<class_2561> secondaryStatusConsumer;
    private int sentMods;
    private final int totalMods;

    public TransferHandler(PublicKey publicKey, class_2960 modTransferID, Consumer<class_2561> secondaryStatusConsumer, int totalMods) {
        this.publicKey = publicKey;
        this.modTransferID = modTransferID;
        this.secondaryStatusConsumer = secondaryStatusConsumer;
        this.sentMods = 0;
        this.totalMods = totalMods;
        this.updateSecondaryStatus("Sent 0/" + totalMods + " mods");
        ClientLoginNetworking.registerReceiver((class_2960)InertiaAntiCheatConstants.SEND_MOD, this::transferMod);
    }

    protected abstract CompletableFuture<class_2540> transferMod(class_310 var1, class_635 var2, class_2540 var3, Consumer<ChannelFutureListener> var4);

    public void onDisconnect(class_635 ignored1, class_310 ignored2) {
        ClientLoginNetworking.unregisterReceiver((class_2960)this.modTransferID);
    }

    protected class_2540 preparePacket(byte[] data) {
        class_2540 buf = PacketByteBufs.create();
        return this.preparePacket(buf, data);
    }

    protected class_2540 preparePacket(class_2540 buf, byte[] data) {
        SecretKey secretKey = InertiaAntiCheat.createAESKey();
        byte[] encryptedRSASecretKey = InertiaAntiCheat.encryptRSABytes(secretKey.getEncoded(), this.publicKey);
        byte[] encryptedAESNameData = InertiaAntiCheat.encryptAESBytes(data, secretKey);
        buf.method_53002(encryptedRSASecretKey.length);
        buf.method_52983(encryptedRSASecretKey);
        buf.method_52983(encryptedAESNameData);
        return buf;
    }

    protected void setCompleteTransferStatus() {
        this.secondaryStatusConsumer.accept(class_2561.method_30163((String)"Waiting for validation..."));
    }

    protected void increaseSentModsStatus() {
        ++this.sentMods;
        this.updateSecondaryStatus("Sent " + this.sentMods + "/" + this.totalMods + " mods");
    }

    private void updateSecondaryStatus(String message) {
        this.secondaryStatusConsumer.accept(class_2561.method_30163((String)message));
    }
}

