/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.client.networking.method.data;

import com.diffusehyperion.inertiaanticheat.client.InertiaAntiCheatClient;
import com.diffusehyperion.inertiaanticheat.client.networking.method.TransferHandler;
import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.util.HashAlgorithm;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import io.netty.channel.ChannelFutureListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_635;

@Environment(value=EnvType.CLIENT)
public class ClientDataTransferHandler
extends TransferHandler {
    private int allModPathsIndex;
    private final Deque<byte[]> loadedFiles;
    private static final int MAX_LOADED_FILES = 10;
    private boolean completed;
    private byte[] currentFile;
    public static final int MAX_SIZE = 1000000;

    public ClientDataTransferHandler(PublicKey publicKey, class_2960 modTransferID, Consumer<class_2561> secondaryStatusConsumer) {
        super(publicKey, modTransferID, secondaryStatusConsumer, InertiaAntiCheatClient.allModPaths.size());
        InertiaAntiCheatClient.debugInfo("Creating data transfer handler");
        this.completed = false;
        this.loadedFiles = new ArrayDeque<byte[]>(10);
        this.allModPathsIndex = 0;
        Thread fileLoaderThread = new Thread(this::fileLoaderThreadMethod);
        fileLoaderThread.start();
    }

    @Override
    public CompletableFuture<class_2540> transferMod(class_310 ignored1, class_635 ignored2, class_2540 ignored3, Consumer<ChannelFutureListener> ignored4) {
        byte[] chunk;
        if (this.completed && this.loadedFiles.isEmpty() && Objects.isNull(this.currentFile)) {
            InertiaAntiCheatClient.debugInfo("Sending final packet");
            InertiaAntiCheatClient.debugLine();
            this.setCompleteTransferStatus();
            ClientLoginNetworking.unregisterGlobalReceiver((class_2960)InertiaAntiCheatConstants.SEND_MOD);
            return CompletableFuture.completedFuture(null);
        }
        if (Objects.isNull(this.currentFile)) {
            this.increaseSentModsStatus();
            this.currentFile = this.stageNextFile();
        }
        class_2540 buf = PacketByteBufs.create();
        if (this.currentFile.length > 1000000) {
            InertiaAntiCheatClient.debugInfo("Sending part of next file");
            chunk = Arrays.copyOf(this.currentFile, 1000000);
            InertiaAntiCheatClient.debugInfo("Hash of chunk: " + InertiaAntiCheat.getHash(chunk, HashAlgorithm.MD5));
            this.currentFile = Arrays.copyOfRange(this.currentFile, 1000000, this.currentFile.length);
            buf.method_52964(false);
        } else {
            InertiaAntiCheatClient.debugInfo("Sending entirety of next file");
            chunk = this.currentFile;
            InertiaAntiCheatClient.debugInfo("Hash of chunk: " + InertiaAntiCheat.getHash(this.currentFile, HashAlgorithm.MD5));
            this.currentFile = null;
            buf.method_52964(true);
        }
        class_2540 responseBuf = this.preparePacket(buf, chunk);
        InertiaAntiCheatClient.debugLine();
        return CompletableFuture.completedFuture(responseBuf);
    }

    private synchronized void fileLoaderThreadMethod() {
        try {
            while (this.allModPathsIndex < InertiaAntiCheatClient.allModPaths.size()) {
                while (this.loadedFiles.size() >= 10) {
                    this.wait();
                }
                Path path = InertiaAntiCheatClient.allModPaths.get(this.allModPathsIndex);
                ++this.allModPathsIndex;
                try {
                    this.loadedFiles.addLast(Files.readAllBytes(path));
                    InertiaAntiCheatClient.debugInfo("Loaded mod file: " + String.valueOf(path));
                    this.notifyAll();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read mod file at path: " + String.valueOf(path), e);
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException("Could not load mod file into deque as it was full", e);
                }
            }
            InertiaAntiCheatClient.debugInfo("Mod file loader thread cleaning up at index " + this.allModPathsIndex);
            this.completed = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized byte[] stageNextFile() {
        try {
            while (this.loadedFiles.isEmpty()) {
                this.wait();
            }
            byte[] loadedFile = this.loadedFiles.remove();
            InertiaAntiCheatClient.debugInfo("Staged mod file");
            this.notifyAll();
            return loadedFile;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not stage next mod file from memory", e);
        }
    }
}

