/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.util.HashAlgorithm;
import com.diffusehyperion.inertiaanticheat.common.util.TransferMethod;
import com.diffusehyperion.inertiaanticheat.common.util.ValidationMethod;
import com.diffusehyperion.inertiaanticheat.server.ServerLoginModlistTransferHandler;
import com.moandjiezana.toml.Toml;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class InertiaAntiCheatServer
implements DedicatedServerModInitializer {
    public static Toml serverConfig;
    public static TransferMethod transferMethod;
    public static ValidationMethod validationMethod;
    public static HashAlgorithm hashAlgorithm;

    public void onInitializeServer() {
        serverConfig = InertiaAntiCheat.initializeConfig("/config/server/InertiaAntiCheat.toml", 9L);
        switch (serverConfig.getString("transfer.method").toLowerCase()) {
            case "data": {
                InertiaAntiCheat.info("Using data transfer method");
                transferMethod = TransferMethod.DATA;
                break;
            }
            case "name": {
                InertiaAntiCheat.info("Using name transfer method");
                transferMethod = TransferMethod.NAME;
                break;
            }
            case "id": {
                InertiaAntiCheat.info("Using id transfer method");
                transferMethod = TransferMethod.ID;
                break;
            }
            default: {
                InertiaAntiCheat.error("There was an error in your config! Invalid transfer method specified under \"transfer.method\"! ");
                InertiaAntiCheat.error("Defaulting to data transfer method for now.");
                transferMethod = TransferMethod.DATA;
            }
        }
        switch (serverConfig.getString("validation.method").toLowerCase()) {
            case "individual": {
                InertiaAntiCheat.info("Using individual validation method");
                validationMethod = ValidationMethod.INDIVIDUAL;
                break;
            }
            case "group": {
                InertiaAntiCheat.info("Using group validation method");
                validationMethod = ValidationMethod.GROUP;
                break;
            }
            default: {
                InertiaAntiCheat.error("There was an error in your config! Invalid validation method specified under \"validation.method\"! ");
                InertiaAntiCheat.error("Defaulting to individual method for now.");
                validationMethod = ValidationMethod.INDIVIDUAL;
            }
        }
        switch (serverConfig.getString("validation.algorithm").toLowerCase()) {
            case "md5": {
                InertiaAntiCheat.info("Using MD5 algorithm for validation");
                hashAlgorithm = HashAlgorithm.MD5;
                break;
            }
            case "sha1": {
                InertiaAntiCheat.info("Using SHA1 algorithm for validation");
                hashAlgorithm = HashAlgorithm.SHA1;
                break;
            }
            case "sha256": {
                InertiaAntiCheat.info("Using SHA256 algorithm for validation");
                hashAlgorithm = HashAlgorithm.SHA256;
                break;
            }
            default: {
                InertiaAntiCheat.error("There was an error in your config! Invalid algorithm specified under \"validation.algorithm\"! ");
                InertiaAntiCheat.error("Defaulting to MD5 algorithm for now.");
                hashAlgorithm = HashAlgorithm.MD5;
            }
        }
        ServerLoginModlistTransferHandler.init();
    }

    public static void debugInfo(String info) {
        if (InertiaAntiCheatServer.inDebug()) {
            InertiaAntiCheat.info(info);
        }
    }

    public static void debugWarn(String info) {
        if (InertiaAntiCheatServer.inDebug()) {
            InertiaAntiCheat.warn(info);
        }
    }

    public static void debugError(String info) {
        if (InertiaAntiCheatServer.inDebug()) {
            InertiaAntiCheat.error(info);
        }
    }

    public static void debugLine() {
        if (InertiaAntiCheatServer.inDebug()) {
            InertiaAntiCheat.info("--------------------");
        }
    }

    public static void debugLine2() {
        if (InertiaAntiCheatServer.inDebug()) {
            InertiaAntiCheat.info("====================");
        }
    }

    public static boolean inDebug() {
        return FabricLoader.getInstance().isDevelopmentEnvironment() || serverConfig.getBoolean("debug.debug") != false;
    }
}

