/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.interfaces.UpgradedServerLoginNetworkHandler;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import com.diffusehyperion.inertiaanticheat.common.util.ValidationMethod;
import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.diffusehyperion.inertiaanticheat.server.networking.method.ValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.ServerDataGroupValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.ServerDataIndividualValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.ServerDataReceiverHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.handlers.DataValidationHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.id.ServerIdGroupValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.id.ServerIdIndividualValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.id.ServerIdReceiverHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.id.handlers.IdValidationHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.name.ServerNameGroupValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.name.ServerNameIndividualValidatorHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.name.ServerNameReceiverHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.name.handlers.NameValidationHandler;
import com.mojang.authlib.GameProfile;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.LoginPacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class ServerLoginModlistTransferHandler {
    private KeyPair serverKeyPair;
    private PublicKey clientKey;
    private final CompletableFuture<Void> loginBlocker = new CompletableFuture();

    public static void init() {
        ServerLoginConnectionEvents.QUERY_START.register(ServerLoginModlistTransferHandler::initiateConnection);
    }

    private static void initiateConnection(class_3248 handler, MinecraftServer minecraftServer, LoginPacketSender sender, ServerLoginNetworking.LoginSynchronizer synchronizer) {
        UpgradedServerLoginNetworkHandler upgradedHandler = (UpgradedServerLoginNetworkHandler)handler;
        ServerLoginModlistTransferHandler transferHandler = new ServerLoginModlistTransferHandler();
        synchronizer.waitFor(transferHandler.loginBlocker);
        InertiaAntiCheatServer.debugLine();
        InertiaAntiCheatServer.debugInfo("Checking if " + handler.method_14383() + " has bypass permissions");
        boolean allowed = (Boolean)Permissions.check((GameProfile)upgradedHandler.inertiaAntiCheat$getGameProfile(), (String)"inertiaanticheat.bypass").join();
        if (allowed) {
            InertiaAntiCheatServer.debugInfo(handler.method_14383() + " is allowed to bypass");
            InertiaAntiCheatServer.debugLine();
            transferHandler.loginBlocker.complete(null);
            return;
        }
        InertiaAntiCheatServer.debugInfo("Not allowed to bypass, checking if address " + handler.method_14383() + " responds to mod messages");
        ServerLoginNetworking.registerReceiver((class_3248)handler, (class_2960)InertiaAntiCheatConstants.CHECK_CONNECTION, transferHandler::checkConnection);
        sender.sendPacket(InertiaAntiCheatConstants.CHECK_CONNECTION, PacketByteBufs.empty());
    }

    private void checkConnection(MinecraftServer minecraftServer, class_3248 handler, boolean b, class_2540 buf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender packetSender) {
        KeyPair keyPair;
        LoginPacketSender sender = (LoginPacketSender)packetSender;
        if (!b) {
            InertiaAntiCheatServer.debugInfo(handler.method_14383() + " does not respond to mod messages, kicking now");
            handler.method_14380(class_2561.method_30163((String)InertiaAntiCheatServer.serverConfig.getString("validation.vanillaKickMessage")));
            return;
        }
        InertiaAntiCheatServer.debugInfo(handler.method_14383() + " responds to mod messages, creating handler");
        class_2540 response = PacketByteBufs.create();
        this.serverKeyPair = keyPair = InertiaAntiCheat.createRSAPair();
        response.method_52983(keyPair.getPublic().getEncoded());
        ServerLoginNetworking.registerReceiver((class_3248)handler, (class_2960)InertiaAntiCheatConstants.INITIATE_E2EE, this::setAdaptor);
        sender.sendPacket(InertiaAntiCheatConstants.INITIATE_E2EE, response);
    }

    private void setAdaptor(MinecraftServer server, class_3248 handler, boolean b, class_2540 buf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender packetSender) {
        InertiaAntiCheatServer.debugInfo("Received " + handler.method_14383() + " keypair");
        LoginPacketSender sender = (LoginPacketSender)packetSender;
        this.clientKey = InertiaAntiCheat.retrievePublicKey(buf);
        class_2540 response = PacketByteBufs.create();
        response.method_53002(InertiaAntiCheatServer.transferMethod.ordinal());
        ServerLoginNetworking.registerReceiver((class_3248)handler, (class_2960)InertiaAntiCheatConstants.SET_ADAPTOR, this::beginModTransfer);
        sender.sendPacket(InertiaAntiCheatConstants.SET_ADAPTOR, response);
    }

    private void beginModTransfer(MinecraftServer server, class_3248 handler, boolean b, class_2540 packetByteBuf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender packetSender) {
        ValidatorHandler validatorAdaptor;
        LoginPacketSender sender = (LoginPacketSender)packetSender;
        UpgradedServerLoginNetworkHandler upgradedHandler = (UpgradedServerLoginNetworkHandler)handler;
        Runnable failureTask = () -> {
            InertiaAntiCheatServer.debugInfo("Address " + String.valueOf(upgradedHandler.inertiaAntiCheat$getConnection().method_10755()) + " failed modlist check");
            handler.method_14380(class_2561.method_30163((String)InertiaAntiCheatServer.serverConfig.getString("validation.deniedKickMessage")));
        };
        Runnable successTask = () -> InertiaAntiCheatServer.debugInfo("Address " + String.valueOf(upgradedHandler.inertiaAntiCheat$getConnection().method_10755()) + " passed modlist check");
        Runnable finishTask = () -> {
            InertiaAntiCheatServer.debugInfo("Finishing transfer, checking mods now");
            ServerLoginNetworking.unregisterReceiver((class_3248)handler, (class_2960)InertiaAntiCheatConstants.SEND_MOD);
        };
        switch (InertiaAntiCheatServer.transferMethod) {
            case DATA: {
                validatorAdaptor = switch (InertiaAntiCheatServer.validationMethod) {
                    default -> throw new MatchException(null, null);
                    case ValidationMethod.INDIVIDUAL -> new ServerDataIndividualValidatorHandler(failureTask, successTask, finishTask);
                    case ValidationMethod.GROUP -> new ServerDataGroupValidatorHandler(failureTask, successTask, finishTask);
                };
                new ServerDataReceiverHandler(this.serverKeyPair, InertiaAntiCheatConstants.SEND_MOD, handler, (DataValidationHandler)validatorAdaptor);
                sender.sendPacket(InertiaAntiCheatConstants.SEND_MOD, PacketByteBufs.empty());
                break;
            }
            case NAME: {
                validatorAdaptor = switch (InertiaAntiCheatServer.validationMethod) {
                    default -> throw new MatchException(null, null);
                    case ValidationMethod.INDIVIDUAL -> new ServerNameIndividualValidatorHandler(failureTask, successTask, finishTask);
                    case ValidationMethod.GROUP -> new ServerNameGroupValidatorHandler(failureTask, successTask, finishTask);
                };
                new ServerNameReceiverHandler(this.serverKeyPair, InertiaAntiCheatConstants.SEND_MOD, handler, (NameValidationHandler)validatorAdaptor);
                sender.sendPacket(InertiaAntiCheatConstants.SEND_MOD, PacketByteBufs.empty());
                break;
            }
            case ID: {
                validatorAdaptor = switch (InertiaAntiCheatServer.validationMethod) {
                    default -> throw new MatchException(null, null);
                    case ValidationMethod.INDIVIDUAL -> new ServerIdIndividualValidatorHandler(failureTask, successTask, finishTask);
                    case ValidationMethod.GROUP -> new ServerIdGroupValidatorHandler(failureTask, successTask, finishTask);
                };
                new ServerIdReceiverHandler(this.serverKeyPair, InertiaAntiCheatConstants.SEND_MOD, handler, (IdValidationHandler)validatorAdaptor);
                sender.sendPacket(InertiaAntiCheatConstants.SEND_MOD, PacketByteBufs.empty());
                break;
            }
            default: {
                throw new RuntimeException("Invalid or no given checking method type given in server config!");
            }
        }
        validatorAdaptor.future.whenComplete((ignored1, ignored2) -> this.loginBlocker.complete(null));
        InertiaAntiCheatServer.debugLine();
    }
}

