/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server.networking.method.data;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.util.HashAlgorithm;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.handlers.DataReceiverHandler;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.handlers.DataValidationHandler;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.LoginPacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;

public class ServerDataReceiverHandler
extends DataReceiverHandler {
    private int currentIndex = 0;
    private byte[] buffer;
    private final List<byte[]> collectedMods = new ArrayList<byte[]>();

    public ServerDataReceiverHandler(KeyPair keyPair, class_2960 modTransferID, class_3248 handler, DataValidationHandler validator) {
        super(keyPair, modTransferID, handler, validator);
    }

    @Override
    public void receiveMod(MinecraftServer minecraftServer, class_3248 handler, boolean b, class_2540 buf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender packetSender) {
        if (!b) {
            ServerLoginNetworking.unregisterReceiver((class_3248)handler, (class_2960)InertiaAntiCheatConstants.SEND_MOD);
            this.validator.checkModlist(this.collectedMods);
            return;
        }
        LoginPacketSender sender = (LoginPacketSender)packetSender;
        InertiaAntiCheatServer.debugInfo("Receiving mod " + this.currentIndex);
        boolean isFinalChunk = buf.readBoolean();
        InertiaAntiCheatServer.debugInfo("Final chunk: " + isFinalChunk);
        byte[] fileData = InertiaAntiCheat.decryptAESRSAEncodedBuf(buf, this.keyPair.getPrivate());
        InertiaAntiCheatServer.debugInfo("Checksum of chunk: " + InertiaAntiCheat.getHash(fileData, HashAlgorithm.MD5));
        this.buffer = ArrayUtils.addAll((byte[])this.buffer, (byte[])fileData);
        if (isFinalChunk) {
            InertiaAntiCheatServer.debugInfo("Adding mod, checksum: " + InertiaAntiCheat.getHash(this.buffer, HashAlgorithm.MD5));
            this.collectedMods.add(this.buffer);
            this.buffer = new byte[0];
            ++this.currentIndex;
        }
        InertiaAntiCheatServer.debugInfo("Continuing transfer");
        sender.sendPacket(this.modTransferID, PacketByteBufs.empty());
        InertiaAntiCheatServer.debugLine();
    }
}

