/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server.networking.method.id;

import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.diffusehyperion.inertiaanticheat.server.networking.method.id.handlers.IdValidationHandler;
import java.util.List;

public class ServerIdIndividualValidatorHandler
extends IdValidationHandler {
    public ServerIdIndividualValidatorHandler(Runnable failureTask, Runnable successTask, Runnable finishTask) {
        super(failureTask, successTask, finishTask);
    }

    @Override
    protected boolean validateMods(List<String> modlist) {
        InertiaAntiCheatServer.debugLine2();
        InertiaAntiCheatServer.debugInfo("Checking modlist now, using individual method");
        InertiaAntiCheatServer.debugInfo("Mod list size: " + modlist.size());
        List blacklistedMods = InertiaAntiCheatServer.serverConfig.getList("validation.individual.blacklist");
        InertiaAntiCheatServer.debugInfo("Blacklisted mods: " + String.join((CharSequence)", ", blacklistedMods));
        List whitelistedMods = InertiaAntiCheatServer.serverConfig.getList("validation.individual.whitelist");
        InertiaAntiCheatServer.debugInfo("Whitelisted mods: " + String.join((CharSequence)", ", whitelistedMods));
        InertiaAntiCheatServer.debugLine();
        for (String mod : modlist) {
            if (blacklistedMods.contains(mod)) {
                InertiaAntiCheatServer.debugInfo("Found in blacklist");
                InertiaAntiCheatServer.debugLine();
                return false;
            }
            if (!whitelistedMods.contains(mod)) continue;
            InertiaAntiCheatServer.debugInfo("Found in whitelist");
            InertiaAntiCheatServer.debugLine();
            whitelistedMods.remove(mod);
        }
        if (!whitelistedMods.isEmpty()) {
            InertiaAntiCheatServer.debugInfo("Whitelist not fulfilled");
            InertiaAntiCheatServer.debugLine();
            return false;
        }
        InertiaAntiCheatServer.debugInfo("Passed");
        InertiaAntiCheatServer.debugLine2();
        return true;
    }
}

