/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.client;

import com.diffusehyperion.inertiaanticheat.client.ClientLoginModlistTransferHandler;
import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class InertiaAntiCheatClient
implements ClientModInitializer {
    public static Toml clientConfig;
    public static final List<String> allModNames;
    public static final List<Path> allModPaths;
    public static final List<String> allModIds;

    public void onInitializeClient() {
        clientConfig = InertiaAntiCheat.initializeConfig("/config/client/InertiaAntiCheat.toml", 2L);
        this.setupModlist();
        ClientLoginModlistTransferHandler.init();
    }

    public static void debugInfo(String info) {
        if (InertiaAntiCheatClient.inDebug()) {
            InertiaAntiCheat.info(info);
        }
    }

    public static void debugWarn(String info) {
        if (InertiaAntiCheatClient.inDebug()) {
            InertiaAntiCheat.warn(info);
        }
    }

    public static void debugError(String info) {
        if (InertiaAntiCheatClient.inDebug()) {
            InertiaAntiCheat.error(info);
        }
    }

    public static void debugLine() {
        if (InertiaAntiCheatClient.inDebug()) {
            InertiaAntiCheat.info("--------------------");
        }
    }

    public static void debugLine2() {
        if (InertiaAntiCheatClient.inDebug()) {
            InertiaAntiCheat.info("====================");
        }
    }

    public static boolean inDebug() {
        return FabricLoader.getInstance().isDevelopmentEnvironment() || clientConfig.getBoolean("debug.debug") != false;
    }

    private void setupModlist() {
        File modDirectory = FabricLoader.getInstance().getGameDir().resolve("mods").toFile();
        for (File modFile : Objects.requireNonNull(modDirectory.listFiles())) {
            InertiaAntiCheatClient.debugInfo("Attempting to load mod " + modFile.getName());
            if (modFile.isDirectory()) {
                InertiaAntiCheatClient.debugWarn("Skipping mod " + modFile.getName() + " as it is a directory");
                continue;
            }
            if (!modFile.getAbsolutePath().endsWith(".jar")) {
                InertiaAntiCheatClient.debugWarn("Skipping mod " + modFile.getName() + " as it does not end with .jar");
                continue;
            }
            try (JarFile jarFile = new JarFile(modFile);){
                ZipEntry entry = jarFile.getEntry("fabric.mod.json");
                if (Objects.isNull(entry)) {
                    InertiaAntiCheatClient.debugWarn("Skipping mod " + modFile.getName() + " as it does not contain \"fabric.mod.json\"");
                    continue;
                }
                Gson gson = new Gson();
                try (InputStream input = jarFile.getInputStream(entry);){
                    JsonObject root = (JsonObject)gson.fromJson((Reader)new InputStreamReader(input), JsonObject.class);
                    if (!root.has("id")) {
                        InertiaAntiCheatClient.debugWarn("Skipping mod " + modFile.getName() + " as it does not contain a mod ID");
                        continue;
                    }
                    allModNames.add(modFile.getName());
                    allModPaths.add(modFile.toPath());
                    allModIds.add(root.get("id").getAsString());
                    InertiaAntiCheatClient.debugInfo("Successfully loaded " + modFile.getName());
                }
            }
            catch (IOException e) {
                InertiaAntiCheatClient.debugWarn("Skipping mod " + modFile.getName() + " as it could not be read");
            }
        }
        InertiaAntiCheat.info("Loaded " + allModNames.size() + " mods");
    }

    static {
        allModNames = new ArrayList<String>();
        allModPaths = new ArrayList<Path>();
        allModIds = new ArrayList<String>();
    }
}

