/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.common;

import com.diffusehyperion.inertiaanticheat.common.util.HashAlgorithm;
import com.diffusehyperion.inertiaanticheat.common.util.InertiaAntiCheatConstants;
import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;

public class InertiaAntiCheat
implements ModInitializer {
    public void onInitialize() {
        InertiaAntiCheat.info("Initializing InertiaAntiCheat!");
        try {
            Files.createDirectories(InertiaAntiCheat.getConfigDir(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void info(String info) {
        InertiaAntiCheatConstants.MODLOGGER.info("[InertiaAntiCheat] {}", (Object)info);
    }

    public static void warn(String info) {
        InertiaAntiCheatConstants.MODLOGGER.warn("[InertiaAntiCheat] {}", (Object)info);
    }

    public static void error(String info) {
        InertiaAntiCheatConstants.MODLOGGER.error("[InertiaAntiCheat] {}", (Object)info);
    }

    public static String getHash(byte[] input, HashAlgorithm algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.toString());
            byte[] hash = md.digest(input);
            StringBuilder hashBuilder = new StringBuilder(new BigInteger(1, hash).toString(16));
            while (hashBuilder.length() < algorithm.getLength()) {
                hashBuilder.insert(0, "0");
            }
            return hashBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Invalid algorithm provided! Please report this on this project's Github!", e);
        }
    }

    public static Toml initializeConfig(String defaultConfigPath, Long currentConfigVersion) {
        Toml config;
        File configFile = InertiaAntiCheat.getConfigDir().resolve("./InertiaAntiCheat.toml").toFile();
        if (!configFile.exists()) {
            InertiaAntiCheat.warn("No config file found! Creating a new one now...");
            try {
                Files.copy(Objects.requireNonNull(InertiaAntiCheatServer.class.getResourceAsStream(defaultConfigPath)), configFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't a create default config!", e);
            }
        }
        if (!Objects.equals((config = new Toml().read(configFile)).getLong("debug.version", Long.valueOf(0L)), currentConfigVersion)) {
            InertiaAntiCheat.warn("Looks like your config file is outdated! Backing up current config, then creating an updated config.");
            InertiaAntiCheat.warn("Your config file will be backed up to \"BACKUP-InertiaAntiCheat.toml\".");
            File backupFile = InertiaAntiCheat.getConfigDir().resolve("BACKUP-InertiaAntiCheat.toml").toFile();
            try {
                Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't copy existing config file into a backup config file! Please do it manually.", e);
            }
            if (!configFile.delete()) {
                throw new RuntimeException("Couldn't delete config file! Please delete it manually.");
            }
            try {
                Files.copy(Objects.requireNonNull(InertiaAntiCheatServer.class.getResourceAsStream(defaultConfigPath)), configFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't create a default config!", e);
            }
            config = new Toml().read(configFile);
            InertiaAntiCheat.info("Done! Please readjust the configs in the new file accordingly.");
        }
        return config;
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().resolve("InertiaAntiCheat");
    }

    public static PublicKey retrievePublicKey(class_2540 packetByteBuf) {
        byte[] rawPublicKeyBytes = new byte[packetByteBuf.readableBytes()];
        packetByteBuf.method_52979(rawPublicKeyBytes);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawPublicKeyBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptAESBytes(byte[] input, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            return cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptAESBytes(byte[] input, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptRSABytes(byte[] input, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptRSABytes(byte[] input, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey createAESKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair createRSAPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Something went wrong while generating new key pairs!", e);
        }
    }

    public static byte[] decryptAESRSAEncodedBuf(class_2540 buf, PrivateKey privateKey) {
        int encryptedSecretKeyLength = buf.readInt();
        byte[] encryptedSecretKey = new byte[encryptedSecretKeyLength];
        buf.method_52979(encryptedSecretKey);
        SecretKeySpec secretKey = new SecretKeySpec(InertiaAntiCheat.decryptRSABytes(encryptedSecretKey, privateKey), "AES");
        byte[] encryptedData = new byte[buf.readableBytes()];
        buf.method_52979(encryptedData);
        return InertiaAntiCheat.decryptAESBytes(encryptedData, secretKey);
    }
}

