/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server.networking.method.data;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.common.util.HashAlgorithm;
import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.handlers.DataValidationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServerDataGroupValidatorHandler
extends DataValidationHandler {
    public ServerDataGroupValidatorHandler(Runnable failureTask, Runnable successTask, Runnable finishTask) {
        super(failureTask, successTask, finishTask);
    }

    @Override
    public boolean validateMods(List<byte[]> modlist) {
        InertiaAntiCheatServer.debugLine2();
        InertiaAntiCheatServer.debugInfo("Checking modlist now, using group method");
        List softWhitelistedMods = InertiaAntiCheatServer.serverConfig.getList("validation.group.softWhitelist");
        InertiaAntiCheatServer.debugInfo("Soft whitelisted mods: " + String.join((CharSequence)", ", softWhitelistedMods));
        ArrayList<String> hashes = new ArrayList<String>();
        ArrayList copySoftWhitelistedMods = new ArrayList(softWhitelistedMods);
        for (byte[] mod : modlist) {
            String fileHash = InertiaAntiCheat.getHash(mod, InertiaAntiCheatServer.hashAlgorithm);
            if (copySoftWhitelistedMods.contains(fileHash)) {
                copySoftWhitelistedMods.remove(fileHash);
                continue;
            }
            hashes.add(fileHash);
        }
        Collections.sort(hashes);
        String combinedHash = String.join((CharSequence)"|", hashes);
        String finalHash = InertiaAntiCheat.getHash(combinedHash.getBytes(), HashAlgorithm.MD5);
        InertiaAntiCheatServer.debugInfo("Final hash: " + finalHash);
        InertiaAntiCheatServer.debugInfo("Combined hash: " + combinedHash);
        boolean success = InertiaAntiCheatServer.serverConfig.getList("validation.group.hash").contains(finalHash);
        if (success) {
            InertiaAntiCheatServer.debugInfo("Passed");
        } else {
            InertiaAntiCheatServer.debugInfo("Failed");
        }
        InertiaAntiCheatServer.debugLine2();
        return success;
    }
}

