/*
 * Decompiled with CFR 0.152.
 */
package com.diffusehyperion.inertiaanticheat.server.networking.method.data;

import com.diffusehyperion.inertiaanticheat.common.InertiaAntiCheat;
import com.diffusehyperion.inertiaanticheat.server.InertiaAntiCheatServer;
import com.diffusehyperion.inertiaanticheat.server.networking.method.data.handlers.DataValidationHandler;
import java.util.List;

public class ServerDataIndividualValidatorHandler
extends DataValidationHandler {
    public ServerDataIndividualValidatorHandler(Runnable failureTask, Runnable successTask, Runnable finishTask) {
        super(failureTask, successTask, finishTask);
    }

    @Override
    public boolean validateMods(List<byte[]> modlist) {
        InertiaAntiCheatServer.debugLine2();
        InertiaAntiCheatServer.debugInfo("Checking modlist now, using individual method");
        InertiaAntiCheatServer.debugInfo("Mod list size: " + modlist.size());
        List blacklistedMods = InertiaAntiCheatServer.serverConfig.getList("validation.individual.blacklist");
        InertiaAntiCheatServer.debugInfo("Blacklisted mods: " + String.join((CharSequence)", ", blacklistedMods));
        List whitelistedMods = InertiaAntiCheatServer.serverConfig.getList("validation.individual.whitelist");
        InertiaAntiCheatServer.debugInfo("Whitelisted mods: " + String.join((CharSequence)", ", whitelistedMods));
        InertiaAntiCheatServer.debugLine();
        for (byte[] mod : modlist) {
            String fileHash = InertiaAntiCheat.getHash(mod, InertiaAntiCheatServer.hashAlgorithm);
            InertiaAntiCheatServer.debugInfo("File hash: " + fileHash + "; with algorithm " + String.valueOf((Object)InertiaAntiCheatServer.hashAlgorithm));
            if (blacklistedMods.contains(fileHash)) {
                InertiaAntiCheatServer.debugInfo("Found in blacklist");
                InertiaAntiCheatServer.debugLine();
                return false;
            }
            if (whitelistedMods.contains(fileHash)) {
                InertiaAntiCheatServer.debugInfo("Found in whitelist");
                whitelistedMods.remove(fileHash);
            }
            InertiaAntiCheatServer.debugLine();
        }
        if (!whitelistedMods.isEmpty()) {
            InertiaAntiCheatServer.debugInfo("Whitelist not fulfilled");
            InertiaAntiCheatServer.debugLine();
            return false;
        }
        InertiaAntiCheatServer.debugInfo("Passed");
        InertiaAntiCheatServer.debugLine2();
        return true;
    }
}

