/*
 * Decompiled with CFR 0.152.
 */
package com.bsipe.lotrkingsaddon.modules;

import com.bsipe.lotrkingsaddon.modules.AbstractModule;
import com.bsipe.lotrkingsaddon.recipes.EnchantedBookRecipe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;

public class CraftingRecipeModule
extends AbstractModule {
    public static boolean ENABLED;
    public static boolean REDSTONE_CRAFTING_ENABLED;
    public static boolean QUARTZ_CRAFTING_ENABLED;
    public static boolean ENDER_CHEST_CRAFTING_ENABLED;
    public static boolean SERVER_ONLY;
    public static boolean ENCHANTED_BOOK_CRAFTING_ENABLED;
    public static boolean EFFICIENCY_CRAFTING_ENABLED;
    public static boolean FORTUNE_CRAFTING_ENABLED;
    public static boolean UNBREAKING_CRAFTING_ENABLED;
    public static boolean SHARPNESS_CRAFTING_ENABLED;
    public static boolean FIRE_ASPECT_CRAFTING_ENABLED;
    public static boolean KNOCKBACK_CRAFTING_ENABLED;
    public static boolean LOOTING_CRAFTING_ENABLED;
    public static boolean PROTECTION_CRAFTING_ENABLED;
    public static boolean FIRE_PROT_CRAFTING_ENABLED;
    public static boolean PROJ_PROT_CRAFTING_ENABLED;
    public static boolean FEATHER_FALLING_CRAFTING_ENABLED;
    public static boolean POWER_CRAFTING_ENABLED;
    public static boolean PUNCH_CRAFTING_ENABLED;
    public static final String CONFIG_CATAGORY = "crafting_recipe_module";
    private static HashMap<EntityPlayerMP, int[]> synced;

    public CraftingRecipeModule(Configuration config) {
        ENABLED = config.getBoolean("custom_crafting_recipes_enabled", CONFIG_CATAGORY, true, "Controls whether Custom Crafting recipes are added.");
        REDSTONE_CRAFTING_ENABLED = config.getBoolean("redstone_crafting_enabled", CONFIG_CATAGORY, true, "Adds redstone dust crafting recipe");
        QUARTZ_CRAFTING_ENABLED = config.getBoolean("quartz_crafting_enabled", CONFIG_CATAGORY, true, "Adds quartz crystal crafting recipe");
        ENDER_CHEST_CRAFTING_ENABLED = config.getBoolean("enderr_chest_crafting_enabled", CONFIG_CATAGORY, true, "Adds LOTR Friendly recipe for ender chests");
        SERVER_ONLY = config.getBoolean("server_only", CONFIG_CATAGORY, false, "Adds tick handler to force update the client, making the custom recipe server only");
        ENCHANTED_BOOK_CRAFTING_ENABLED = config.getBoolean("enchanted_book_crafting_enabled", CONFIG_CATAGORY, true, "Gates all enchanted book crafting behind a single config.");
        EFFICIENCY_CRAFTING_ENABLED = config.getBoolean("efficiency_crafting_enabled", CONFIG_CATAGORY, true, "Allows Efficiency 5 books to be crafted with scrolls");
        FORTUNE_CRAFTING_ENABLED = config.getBoolean("fortune_crafting_enabled", CONFIG_CATAGORY, true, "Allows Fortune 3 books to be crafted with scrolls");
        UNBREAKING_CRAFTING_ENABLED = config.getBoolean("unbreaking_crafting_enabled", CONFIG_CATAGORY, true, "Allows Unbreaking 3 books to be crafted with scrolls");
        SHARPNESS_CRAFTING_ENABLED = config.getBoolean("sharpness_crafting_enabled", CONFIG_CATAGORY, false, "Allows Sharpness 5 books to be crafted with scrolls");
        FIRE_ASPECT_CRAFTING_ENABLED = config.getBoolean("fire_aspect_crafting_enabled", CONFIG_CATAGORY, false, "Allows Fire Aspect 2 books to be crafted with scrolls");
        KNOCKBACK_CRAFTING_ENABLED = config.getBoolean("knockback_crafting_enabled", CONFIG_CATAGORY, false, "Allows Knockback 2 to be crafted with scrolls");
        LOOTING_CRAFTING_ENABLED = config.getBoolean("looting_crafting_enabled", CONFIG_CATAGORY, false, "Allows Looting 3 books to be crafted with scrolls");
        PROTECTION_CRAFTING_ENABLED = config.getBoolean("protection_crafting_enabled", CONFIG_CATAGORY, true, "Allows Protection 4 books to be crafted with scrolls");
        FIRE_PROT_CRAFTING_ENABLED = config.getBoolean("fire_prot_crafting_enabled", CONFIG_CATAGORY, true, "Allows Fire Protection 4 books to be crafted with scrolls");
        PROJ_PROT_CRAFTING_ENABLED = config.getBoolean("proj_prot_crafting_enabled", CONFIG_CATAGORY, true, "Allows Projectile Protection 4 books to be crafted with scrolls");
        FEATHER_FALLING_CRAFTING_ENABLED = config.getBoolean("feather_falling_crafting_enabled", CONFIG_CATAGORY, true, "Allows Feather Falling 4 books to be crafted with scrolls");
        POWER_CRAFTING_ENABLED = config.getBoolean("power_crafting_enabled", CONFIG_CATAGORY, false, "Allows Power 5 books to be crafted with scrolls");
        PUNCH_CRAFTING_ENABLED = config.getBoolean("punch_crafting_enabled", CONFIG_CATAGORY, false, "Allows Punch 2 books to be crafted with scrolls");
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!ENABLED) {
            return;
        }
        if (REDSTONE_CRAFTING_ENABLED) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.redstone, 2), (Object[])new Object[]{LOTRMod.bronze, Items.glowstone_dust});
        }
        if (QUARTZ_CRAFTING_ENABLED) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.quartz, 4), (Object[])new Object[]{" x ", "xvx", " x ", Character.valueOf('x'), Blocks.sand, Character.valueOf('v'), LOTRMod.salt});
        }
        if (ENDER_CHEST_CRAFTING_ENABLED) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.ender_chest), (Object[])new Object[]{"ooo", "omo", "ooo", Character.valueOf('o'), Blocks.obsidian, Character.valueOf('m'), LOTRMod.mithril});
        }
        if (ENCHANTED_BOOK_CRAFTING_ENABLED) {
            this.addEnchantedBookCraftingRecipes();
        }
        if (SERVER_ONLY) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    public void addEnchantedBookCraftingRecipes() {
        RecipeSorter.register((String)"lotrkingsaddon:enchantedbookcrafting", EnchantedBookRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        if (EFFICIENCY_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.efficiency, 5, LOTREnchantment.toolSpeed4, 5));
        }
        if (FORTUNE_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.fortune, 3, LOTREnchantment.looting3, 3));
        }
        if (UNBREAKING_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.unbreaking, 3, LOTREnchantment.durable3, 3));
        }
        if (SHARPNESS_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.sharpness, 5, LOTREnchantment.strong4, 5));
        }
        if (KNOCKBACK_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.knockback, 2, LOTREnchantment.knockback2, 2));
        }
        if (LOOTING_CRAFTING_ENABLED && !FORTUNE_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.looting, 3, LOTREnchantment.looting3, 3));
        }
        if (PROTECTION_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.protection, 4, LOTREnchantment.protect2, 4));
        }
        if (FIRE_PROT_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.fireProtection, 4, LOTREnchantment.protectFire3, 4));
        }
        if (PROJ_PROT_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.projectileProtection, 4, LOTREnchantment.protectRanged3, 4));
        }
        if (FEATHER_FALLING_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.featherFalling, 4, LOTREnchantment.protectFall3, 4));
        }
        if (POWER_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.power, 5, LOTREnchantment.rangedStrong3, 5));
        }
        if (PUNCH_CRAFTING_ENABLED) {
            GameRegistry.addRecipe((IRecipe)new EnchantedBookRecipe(Enchantment.punch, 2, LOTREnchantment.rangedKnockback2, 2));
        }
        if (FIRE_ASPECT_CRAFTING_ENABLED) {
            ItemStack stack = new ItemStack((Item)Items.enchanted_book);
            Items.enchanted_book.addEnchantment(stack, new EnchantmentData(Enchantment.fireAspect, 2));
            GameRegistry.addShapelessRecipe((ItemStack)stack, (Object[])new Object[]{LOTRMod.balrogFire, LOTRMod.balrogFire});
        }
    }

    public static void tick(EntityPlayerMP player) {
        if (player.openContainer.getClass().equals(ContainerWorkbench.class)) {
            int[] info;
            ContainerWorkbench crafting = (ContainerWorkbench)player.openContainer;
            ItemStack result = CraftingManager.getInstance().findMatchingRecipe(crafting.craftMatrix, player.worldObj);
            if (result == null) {
                synced.remove(player);
                return;
            }
            if (synced.containsKey(player) && (info = synced.get(player))[0] == player.currentWindowId && info[1] == Item.getIdFromItem((Item)result.getItem()) && !Items.enchanted_book.equals(result.getItem())) {
                return;
            }
            player.playerNetServerHandler.sendPacket((Packet)new S2FPacketSetSlot(crafting.windowId, 0, result));
            synced.put(player, new int[]{player.currentWindowId, Item.getIdFromItem((Item)result.getItem())});
        }
    }

    @SubscribeEvent
    public void logOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!ENABLED || !SERVER_ONLY) {
            return;
        }
        synced.remove(event.player);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!ENABLED || !SERVER_ONLY) {
            return;
        }
        if (event.player instanceof EntityPlayerMP && event.player.openContainer != null) {
            CraftingRecipeModule.tick((EntityPlayerMP)event.player);
        }
    }

    static {
        synced = new HashMap();
    }
}

