/*
 * Decompiled with CFR 0.152.
 */
package com.bsipe.lotrkingsaddon.recipes;

import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.item.LOTRItemModifierTemplate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class EnchantedBookRecipe
implements IRecipe {
    private LOTREnchantment lotrModifier;
    private int modifierScrollRequirementCount;
    private ItemStack result;

    public EnchantedBookRecipe(Enchantment enchantment, int enchantmentResultLevel, LOTREnchantment lotrModifier, int modifierScrollRequirementCount) {
        ItemStack stack = new ItemStack((Item)Items.enchanted_book);
        Items.enchanted_book.addEnchantment(stack, new EnchantmentData(enchantment, enchantmentResultLevel));
        this.result = stack;
        this.lotrModifier = lotrModifier;
        this.modifierScrollRequirementCount = modifierScrollRequirementCount;
    }

    public boolean matches(InventoryCrafting inventory, World world) {
        int matchingScrollCount = 0;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i) == null || !inventory.getStackInSlot(i).getItem().equals(LOTRMod.modTemplate)) continue;
            if (LOTRItemModifierTemplate.getModifier((ItemStack)inventory.getStackInSlot(i)).equals(this.lotrModifier)) {
                ++matchingScrollCount;
                continue;
            }
            return false;
        }
        return matchingScrollCount == this.modifierScrollRequirementCount;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        return this.result;
    }

    public int getRecipeSize() {
        return this.modifierScrollRequirementCount;
    }

    public ItemStack getRecipeOutput() {
        return this.result;
    }
}

