/*
 * Decompiled with CFR 0.152.
 */
package com.bsipe.lotrkingsaddon.modules;

import com.bsipe.lotrkingsaddon.modules.AbstractModule;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDimension;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.spawning.LOTRBiomeSpawnList;
import lotr.common.world.spawning.LOTRSpawnEntry;
import lotr.common.world.spawning.LOTRSpawnerNPCs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ForgeEventFactory;

public class PerPlayerMobCapModule
extends AbstractModule {
    public static boolean ENABLED;
    public static boolean ENABLE_LOGGING;
    public static int MIDDLE_EARTH_MOB_CAP;
    public static int UTUMNO_MOB_CAP;
    public static int previousMobCount;
    public static int player_index;
    private static final Set<ChunkCoordIntPair> eligibleSpawnChunks;
    private static final int CHUNK_RANGE = 7;
    public static final int LIMIT = 16384;
    public static final String CONFIG_CATAGORY = "mobs_per_player";

    public PerPlayerMobCapModule(Configuration config) {
        config.addCustomCategoryComment(CONFIG_CATAGORY, "These numbers were determined via testing to match current game behavior.");
        config.addCustomCategoryComment(CONFIG_CATAGORY, "This module is server side only, it is not required by the client to work.");
        ENABLED = config.getBoolean("per_player_mob_spawning_enabled", CONFIG_CATAGORY, true, "Controls whether mob spawning is switched to a per-player system.");
        ENABLE_LOGGING = config.getBoolean("mob_spawning_logging", CONFIG_CATAGORY, false, "Adds development logging to check if mobs are spawning properly");
        MIDDLE_EARTH_MOB_CAP = config.getInt("middle_earth", CONFIG_CATAGORY, 114, 0, 2000, "Number of mob 'points' per player in the middle earth dimension");
        UTUMNO_MOB_CAP = config.getInt("utumno", CONFIG_CATAGORY, 573, 0, 2000, "Number of mob 'points' per player in the utumno dimension");
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (!ENABLED) {
            return;
        }
        try {
            ReflectionHelper.setPrivateValue(LOTRDimension.class, (Object)LOTRDimension.MIDDLE_EARTH, (Object)0, (int)14);
            ReflectionHelper.setPrivateValue(LOTRDimension.class, (Object)LOTRDimension.UTUMNO, (Object)0, (int)14);
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!ENABLED) {
            return;
        }
        LOTRConfig.mobSpawnInterval = 72000;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!ENABLED) {
            return;
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!ENABLED) {
            return;
        }
        World world = event.world;
        if (world == null || world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && (world == DimensionManager.getWorld((int)LOTRDimension.MIDDLE_EARTH.dimensionID) || world == DimensionManager.getWorld((int)LOTRDimension.UTUMNO.dimensionID)) && LOTRMod.canSpawnMobs((World)world)) {
            if (world == DimensionManager.getWorld((int)LOTRDimension.MIDDLE_EARTH.dimensionID)) {
                this.performSpawning(world, MIDDLE_EARTH_MOB_CAP);
            } else if (world == DimensionManager.getWorld((int)LOTRDimension.UTUMNO.dimensionID)) {
                this.performSpawning(world, UTUMNO_MOB_CAP);
            }
        }
    }

    public static EntityPlayer getPlayer(World world, int index) {
        if (world.field_73010_i.size() > index) {
            return (EntityPlayer)world.field_73010_i.get(index);
        }
        if (world.field_73010_i.isEmpty()) {
            return null;
        }
        ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("Tried to get " + index + " out of " + world.field_73010_i.size()));
        return (EntityPlayer)world.field_73010_i.get(0);
    }

    public void performSpawning(World world, int mobCap) {
        EntityPlayer player;
        int count;
        if (world.field_73010_i.isEmpty()) {
            return;
        }
        player_index %= world.field_73010_i.size();
        if ((count = PerPlayerMobCapModule.countNPCs(world, player = PerPlayerMobCapModule.getPlayer(world, player_index++))) >= mobCap) {
            return;
        }
        PerPlayerMobCapModule.getSpawnableChunks(eligibleSpawnChunks, player);
        PerPlayerMobCapModule.attemptToSpawn(world);
    }

    private static int countNPCs(World world, EntityPlayer player) {
        int mobCount = 0;
        HashMap<String, Integer> classMap = new HashMap<String, Integer>();
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            int spawnCountValue;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof LOTREntityNPC) || (spawnCountValue = ((LOTREntityNPC)entity).getSpawnCountValue()) <= 0) continue;
            classMap.put(((LOTREntityNPC)entity).getEntityClassName(), classMap.getOrDefault(((LOTREntityNPC)entity).getEntityClassName(), 0) + 1);
            if (!PerPlayerMobCapModule.isInRange(player, entity)) continue;
            mobCount += spawnCountValue;
        }
        if (ENABLE_LOGGING && mobCount != previousMobCount) {
            previousMobCount = mobCount;
            boolean isMiddleEarth = world == DimensionManager.getWorld((int)LOTRDimension.MIDDLE_EARTH.dimensionID);
            ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("Counted " + mobCount + "/" + MIDDLE_EARTH_MOB_CAP + " mobs for " + player.getDisplayName() + " in " + (isMiddleEarth ? "Middle Earth" : "Utumno")));
        }
        return mobCount;
    }

    public static boolean isInRange(EntityPlayer p, Entity e) {
        int d1 = p.field_70176_ah - e.field_70176_ah;
        int d2 = p.field_70164_aj - e.field_70164_aj;
        return 16384 > d1 * d1 + d2 * d2;
    }

    public static void getSpawnableChunks(Set<ChunkCoordIntPair> set, EntityPlayer player) {
        set.clear();
        int i = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
        int k = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
        for (int i1 = -7; i1 <= 7; ++i1) {
            for (int k1 = -7; k1 <= 7; ++k1) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i + i1, k + k1);
                set.add(chunkcoordintpair);
            }
        }
    }

    public static boolean attemptToSpawn(World world) {
        boolean success = false;
        List shuffled = LOTRSpawnerNPCs.shuffle(eligibleSpawnChunks);
        for (ChunkCoordIntPair chunkCoords : shuffled) {
            ChunkPosition chunkPosition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk((World)world, (ChunkCoordIntPair)chunkCoords);
            if (chunkPosition == null || !PerPlayerMobCapModule.isValidSpawningLocation(world, chunkPosition)) continue;
            success = success || PerPlayerMobCapModule.spawnNPCAtCoords(world, chunkPosition, world.func_72861_E());
        }
        return success;
    }

    public static boolean isValidSpawningLocation(World world, ChunkPosition position) {
        return world.func_147439_a(position.field_151329_a, position.field_151327_b, position.field_151328_c).func_149721_r() && world.func_147439_a(position.field_151329_a, position.field_151327_b, position.field_151328_c).func_149688_o() != Material.field_151579_a;
    }

    public static boolean spawnNPCAtCoords(World world, ChunkPosition position, ChunkCoordinates spawnPoint) {
        int groups = 3;
        boolean success = false;
        for (int l = 0; l < groups; ++l) {
            int i1 = position.field_151329_a;
            int j1 = position.field_151327_b;
            int k1 = position.field_151328_c;
            int range = 5;
            int yRange = 0;
            int rangeP1 = range + 1;
            int yRangeP1 = yRange + 1;
            LOTRSpawnEntry.Instance spawnEntryInstance = PerPlayerMobCapModule.getRandomSpawnListEntry(world, i1, j1, k1);
            if (spawnEntryInstance == null) continue;
            LOTRSpawnEntry spawnEntry = spawnEntryInstance.spawnEntry;
            boolean isConquestSpawn = spawnEntryInstance.isConquestSpawn;
            int spawnCount = MathHelper.func_76136_a((Random)world.field_73012_v, (int)spawnEntry.field_76301_c, (int)spawnEntry.field_76299_d);
            int chance = spawnEntryInstance.spawnChance;
            if (chance == 0 || world.field_73012_v.nextInt(chance) == 0) {
                IEntityLivingData entityData = null;
                int spawned = 0;
                int attempts = spawnCount * 8;
                for (int a = 0; a < attempts; ++a) {
                    Event.Result canSpawn;
                    EntityLiving entity;
                    float f5;
                    float f4;
                    float f3;
                    float distSq;
                    float f2;
                    float f1;
                    float f;
                    if (!world.func_72899_e(i1 += world.field_73012_v.nextInt(rangeP1) - world.field_73012_v.nextInt(rangeP1), j1 += world.field_73012_v.nextInt(yRangeP1) - world.field_73012_v.nextInt(yRangeP1), k1 += world.field_73012_v.nextInt(rangeP1) - world.field_73012_v.nextInt(rangeP1)) || !PerPlayerMobCapModule.canNPCSpawnAtLocation(world, i1, j1, k1) || world.func_72977_a((double)(f = (float)i1 + 0.5f), (double)(f1 = (float)j1), (double)(f2 = (float)k1 + 0.5f), 24.0) != null || !((distSq = (f3 = f - (float)spawnPoint.field_71574_a) * f3 + (f4 = f1 - (float)spawnPoint.field_71572_b) * f4 + (f5 = f2 - (float)spawnPoint.field_71573_c) * f5) >= 576.0f)) continue;
                    try {
                        entity = (EntityLiving)spawnEntry.field_76300_b.getConstructor(World.class).newInstance(world);
                    }
                    catch (Exception var42) {
                        var42.printStackTrace();
                        return false;
                    }
                    entity.func_70012_b((double)f, (double)f1, (double)f2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof LOTREntityNPC && isConquestSpawn) {
                        LOTREntityNPC npc = (LOTREntityNPC)entity;
                        npc.setConquestSpawning(true);
                    }
                    if ((canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)f, (float)f1, (float)f2)) == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entity.func_70601_bi()) {
                        world.func_72838_d((Entity)entity);
                        success = true;
                        if (ENABLE_LOGGING) {
                            ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("Spawned " + entity.getClass().getSimpleName() + " at coords(" + f + "," + f1 + "," + f2 + ")"));
                        }
                        if (entity instanceof LOTREntityNPC) {
                            LOTREntityNPC npc = (LOTREntityNPC)entity;
                            npc.isNPCPersistent = false;
                            npc.setShouldTraderRespawn(false);
                            npc.setConquestSpawning(false);
                        }
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entity, (World)world, (float)f, (float)f1, (float)f2)) {
                            entityData = entity.func_110161_a(entityData);
                        }
                        if (++spawned < spawnCount) continue;
                        break;
                    }
                    if (!ENABLE_LOGGING) continue;
                    ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("canSpawnEntity Failed"));
                }
                if (success || !ENABLE_LOGGING) continue;
                ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("All attempts failed"));
                continue;
            }
            if (!ENABLE_LOGGING) continue;
            ((EntityPlayer)world.field_73010_i.get(0)).func_145747_a((IChatComponent)new ChatComponentText("Spawn Chance Failed: " + chance));
        }
        return success;
    }

    private static LOTRSpawnEntry.Instance getRandomSpawnListEntry(World world, int i, int j, int k) {
        LOTRBiomeSpawnList spawnlist = null;
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome && world.field_73011_w instanceof LOTRWorldProvider) {
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            LOTRWorldChunkManager worldChunkMgr = (LOTRWorldChunkManager)world.field_73011_w.field_76578_c;
            LOTRBiomeVariant variant = worldChunkMgr.getBiomeVariantAt(i, k);
            spawnlist = lotrbiome.getNPCSpawnList(world, world.field_73012_v, i, j, k, variant);
        }
        return spawnlist != null ? spawnlist.getRandomSpawnEntry(world.field_73012_v, world, i, j, k) : null;
    }

    private static boolean canNPCSpawnAtLocation(World world, int i, int j, int k) {
        if (!World.func_147466_a((IBlockAccess)world, (int)i, (int)(j - 1), (int)k)) {
            return false;
        }
        Block block = world.func_147439_a(i, j - 1, k);
        world.func_72805_g(i, j - 1, k);
        boolean spawnBlock = block.canCreatureSpawn(EnumCreatureType.monster, (IBlockAccess)world, i, j - 1, k);
        return spawnBlock && block != Blocks.field_150357_h && !world.func_147439_a(i, j, k).func_149721_r() && !world.func_147439_a(i, j, k).func_149688_o().func_76224_d() && !world.func_147439_a(i, j + 1, k).func_149721_r();
    }

    static {
        player_index = 0;
        eligibleSpawnChunks = new HashSet<ChunkCoordIntPair>();
    }
}

