/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.client.model;

import baguchan.nether_invader.client.animation.BastionGeneralAnimations;
import baguchan.nether_invader.client.render.state.BastionGeneralRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class BastionGeneralModel<T extends BastionGeneralRenderState>
extends EntityModel<T>
implements ArmedModel<T> {
    private final ModelPart everything;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart helmet;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart front_cloth;
    private final ModelPart back_cloth;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final KeyframeAnimation idleAnimation;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation attackAnimation;

    public BastionGeneralModel(ModelPart root) {
        super(root);
        this.everything = root.getChild("everything");
        this.body = this.everything.getChild("body");
        this.leftArm = this.body.getChild("leftArm");
        this.rightArm = this.body.getChild("rightArm");
        this.head = this.body.getChild("head");
        this.snout = this.head.getChild("snout");
        this.helmet = this.head.getChild("helmet");
        this.leftEar = this.head.getChild("leftEar");
        this.rightEar = this.head.getChild("rightEar");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.front_cloth = this.body.getChild("front_cloth");
        this.back_cloth = this.body.getChild("back_cloth");
        this.leftLeg = this.everything.getChild("leftLeg");
        this.rightLeg = this.everything.getChild("rightLeg");
        this.idleAnimation = BastionGeneralAnimations.idle.bake(root);
        this.attackAnimation = BastionGeneralAnimations.swing.bake(root);
        this.walkAnimation = BastionGeneralAnimations.walk.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 22).addBox(-8.0f, -19.0f, -7.0f, 16.0f, 19.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 77).addBox(-8.0f, -19.0f, -7.0f, 16.0f, 20.0f, 14.0f, new CubeDeformation(0.25f)).texOffs(64, 59).addBox(-3.0f, -6.5f, -9.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(104, 0).addBox(0.0f, -2.75f, -3.5f, 5.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-16.25f, (float)-0.5f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(80, 0).addBox(-5.0f, -3.0f, -3.5f, 5.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-16.0f, (float)-0.5f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -9.75f, -6.5f, 12.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-18.5f, (float)-2.25f));
        PartDefinition snout = head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(37, 3).addBox(-3.0f, -2.25f, -2.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(5, 7).addBox(3.0f, -0.25f, -2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 4).addBox(-4.0f, 0.75f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-6.5f));
        PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 55).addBox(-6.0f, 0.25f, -6.5f, 12.0f, 10.0f, 12.0f, new CubeDeformation(0.25f)).texOffs(48, 51).addBox(0.0f, -2.5f, -7.5f, 0.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(65, 8).addBox(-0.6964f, 0.1228f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-6.25f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(49, 8).addBox(-0.3036f, 0.1228f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-6.25f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, -0.01f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-3.75f, (float)-6.5f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, -0.01f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-3.75f, (float)-6.5f));
        PartDefinition front_cloth = body.addOrReplaceChild("front_cloth", CubeListBuilder.create().texOffs(77, 85).addBox(-5.0f, 0.25f, 0.25f, 10.0f, 11.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-2.9f, (float)-7.25f));
        PartDefinition back_cloth = body.addOrReplaceChild("back_cloth", CubeListBuilder.create().texOffs(106, 85).addBox(-5.0f, 0.25f, 0.25f, 10.0f, 11.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-2.85f, (float)7.25f));
        PartDefinition leftLeg = everything.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(63, 28).addBox(-3.5f, 0.0f, -4.0f, 7.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)9.5f, (float)0.0f));
        PartDefinition rightLeg = everything.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(93, 28).addBox(-3.5f, 0.0f, -4.0f, 7.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)9.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.attackAnimation.apply(((BastionGeneralRenderState)((Object)entity)).attackAnimationState, ((BastionGeneralRenderState)((Object)entity)).ageInTicks);
        this.walkAnimation.applyWalk(((BastionGeneralRenderState)((Object)entity)).walkAnimationPos, ((BastionGeneralRenderState)((Object)entity)).walkAnimationSpeed, 2.0f, 2.5f);
        if (!((BastionGeneralRenderState)((Object)entity)).attackAnimationState.isStarted()) {
            this.idleAnimation.applyWalk(((BastionGeneralRenderState)((Object)entity)).ageInTicks, 1.0f, 2.0f, 2.5f);
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void translateToHand(T entityRenderState, HumanoidArm humanoidArm, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        this.getArm(humanoidArm).translateAndRotate(poseStack);
    }
}

