/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.entity;

import baguchan.nether_invader.entity.PiglinRaider;
import baguchan.nether_invader.entity.ai.RevampedPiglinAi;
import baguchan.nether_invader.registry.ModEntitys;
import baguchan.nether_invader.world.raid.PiglinRaid;
import baguchi.bagus_lib.register.ModSensors;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class AgressivePiglin
extends AbstractPiglin
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.defineId(AgressivePiglin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(AgressivePiglin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_DANCING = SynchedEntityData.defineId(AgressivePiglin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ResourceLocation SPEED_MODIFIER_BABY_ID = ResourceLocation.withDefaultNamespace((String)"baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final int MAX_HEALTH = 16;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.35f;
    private static final int ATTACK_DAMAGE = 5;
    private static final float CHANCE_OF_WEARING_EACH_ARMOUR_ITEM = 0.1f;
    private static final int MAX_PASSENGERS_ON_ONE_HOGLIN = 3;
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.PIGLIN.getDimensions().scale(0.5f).withEyeHeight(0.97f);
    private static final double PROBABILITY_OF_SPAWNING_WITH_CROSSBOW_INSTEAD_OF_SWORD = 0.5;
    private boolean cannotHunt;
    protected static final ImmutableList<SensorType<? extends Sensor<? super AgressivePiglin>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ModSensors.SMART_NEAREST_LIVING_ENTITY_SENSOR.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.HURT_BY, (Object)((SensorType)baguchan.nether_invader.registry.ModSensors.ANGER_PIGLIN_SENSOR.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.DOORS_TO_CLOSE, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)MemoryModuleType.NEARBY_ADULT_PIGLINS, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.HURT_BY, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CELEBRATE_LOCATION, MemoryModuleType.DANCING, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.NEAREST_REPELLENT});

    public AgressivePiglin(EntityType<? extends AbstractPiglin> p_34683_, Level p_34684_) {
        super(p_34683_, p_34684_);
        this.xpReward = 5;
    }

    protected void addAdditionalSaveData(ValueOutput p_421634_) {
        super.addAdditionalSaveData(p_421634_);
        if (this.isBaby()) {
            p_421634_.putBoolean("IsBaby", true);
        }
        if (this.cannotHunt) {
            p_421634_.putBoolean("CannotHunt", true);
        }
    }

    protected void readAdditionalSaveData(ValueInput p_422019_) {
        super.readAdditionalSaveData(p_422019_);
        this.setBaby(p_422019_.getBooleanOr("IsBaby", false));
        this.setCannotHunt(p_422019_.getBooleanOr("CannotHunt", false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326106_) {
        super.defineSynchedData(p_326106_);
        p_326106_.define(DATA_BABY_ID, (Object)false);
        p_326106_.define(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        p_326106_.define(DATA_IS_DANCING, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_34727_) {
        super.onSyncedDataUpdated(p_34727_);
        if (DATA_BABY_ID.equals(p_34727_)) {
            this.refreshDimensions();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 35.0);
    }

    public static boolean checkPiglinSpawnRules(EntityType<Piglin> p_219198_, LevelAccessor p_219199_, EntitySpawnReason p_219200_, BlockPos p_219201_, RandomSource p_219202_) {
        return !p_219199_.getBlockState(p_219201_.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34717_, DifficultyInstance p_34718_, EntitySpawnReason p_34719_, @Nullable SpawnGroupData p_34720_) {
        RandomSource randomsource = p_34717_.getRandom();
        RevampedPiglinAi.initMemories(this, p_34717_.getRandom());
        this.populateDefaultEquipmentSlots(randomsource, p_34718_);
        this.populateDefaultEquipmentEnchantments(p_34717_, randomsource, p_34718_);
        return super.finalizeSpawn(p_34717_, p_34718_, p_34719_, p_34720_);
    }

    public boolean removeWhenFarAway(double p_34775_) {
        return !this.isPersistenceRequired();
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219189_, DifficultyInstance p_219190_) {
        if (this.isAdult()) {
            this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.GOLDEN_HELMET), p_219189_);
            this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), p_219189_);
            this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), p_219189_);
            this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.GOLDEN_BOOTS), p_219189_);
        } else {
            this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.GOLDEN_BOOTS), p_219189_);
        }
        AgressivePiglin agressivePiglin = this;
        if (agressivePiglin instanceof PiglinRaider) {
            PiglinRaider piglinRaider = (PiglinRaider)((Object)agressivePiglin);
            if (piglinRaider.netherInvader$isPatrolLeader()) {
                this.setItemSlotAndDropWhenKilled(EquipmentSlot.HEAD, PiglinRaid.getLeaderBannerInstance((HolderGetter<BannerPattern>)this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
                this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE));
                this.setDropChance(EquipmentSlot.CHEST, 0.0f);
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.NETHERITE_SWORD));
                this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
            }
            if (this.getControlledVehicle() != null && this.getType() == ModEntitys.AGRESSIVE_PIGLIN.get()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, Items.CROSSBOW.getDefaultInstance());
            }
        }
    }

    private void maybeWearArmor(EquipmentSlot p_219192_, ItemStack p_219193_, RandomSource p_219194_) {
        if (p_219194_.nextFloat() < 0.1f) {
            this.setItemSlot(p_219192_, p_219193_);
        }
    }

    protected Brain.Provider<AgressivePiglin> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_34723_) {
        return RevampedPiglinAi.makeBrain(this, (Brain<AgressivePiglin>)this.brainProvider().makeBrain(p_34723_));
    }

    public Brain<AgressivePiglin> getBrain() {
        return super.getBrain();
    }

    public EntityDimensions getDefaultDimensions(Pose p_316426_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316426_);
    }

    public void setBaby(boolean p_34729_) {
        this.getEntityData().set(DATA_BABY_ID, (Object)p_34729_);
        if (!this.level().isClientSide()) {
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            attributeinstance.removeModifier(SPEED_MODIFIER_BABY.id());
            if (p_34729_) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    public boolean isBaby() {
        return (Boolean)this.getEntityData().get(DATA_BABY_ID);
    }

    private void setCannotHunt(boolean p_34792_) {
        this.cannotHunt = p_34792_;
    }

    protected boolean canHunt() {
        return !this.cannotHunt;
    }

    protected void customServerAiStep(ServerLevel p_376586_) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("piglinBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profilerfiller.pop();
        RevampedPiglinAi.updateActivity(this);
        super.customServerAiStep(p_376586_);
    }

    protected int getBaseExperienceReward(ServerLevel p_376894_) {
        return this.xpReward;
    }

    protected void finishConversion(ServerLevel p_34756_) {
        super.finishConversion(p_34756_);
    }

    private ItemStack createSpawnWeapon() {
        return (double)this.random.nextFloat() < 0.5 && !this.isBaby() ? new ItemStack((ItemLike)Items.CROSSBOW) : new ItemStack((ItemLike)Items.GOLDEN_SWORD);
    }

    private boolean isChargingCrossbow() {
        return (Boolean)this.entityData.get(DATA_IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean p_34753_) {
        this.entityData.set(DATA_IS_CHARGING_CROSSBOW, (Object)p_34753_);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public PiglinArmPose getArmPose() {
        if (this.isDancing()) {
            return PiglinArmPose.DANCING;
        }
        if (this.isAggressive() && this.isHoldingMeleeWeapon()) {
            return PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return PiglinArmPose.CROSSBOW_CHARGE;
        }
        return this.isAggressive() && this.isHolding(is -> is.getItem() instanceof CrossbowItem) ? PiglinArmPose.CROSSBOW_HOLD : PiglinArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(DATA_IS_DANCING);
    }

    public void setDancing(boolean p_34790_) {
        this.entityData.set(DATA_IS_DANCING, (Object)p_34790_);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_34694_, float p_34695_) {
        boolean flag = super.hurtServer(serverLevel, p_34694_, p_34695_);
        if (this.level().isClientSide()) {
            return false;
        }
        if (flag && p_34694_.getEntity() instanceof LivingEntity) {
            RevampedPiglinAi.wasHurtBy(serverLevel, this, (LivingEntity)p_34694_.getEntity());
        }
        return flag;
    }

    public void performRangedAttack(LivingEntity p_34704_, float p_34705_) {
        this.performCrossbowAttack((LivingEntity)this, 1.6f);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem p_34715_) {
        return p_34715_ == Items.CROSSBOW;
    }

    public boolean startRiding(Entity p_34701_, boolean p_34702_, boolean b2) {
        if (this.isBaby() && p_34701_.getType() == EntityType.HOGLIN) {
            p_34701_ = this.getTopPassenger(p_34701_, 3);
        }
        return super.startRiding(p_34701_, p_34702_, b2);
    }

    private Entity getTopPassenger(Entity p_34731_, int p_34732_) {
        List list = p_34731_.getPassengers();
        return p_34732_ != 1 && !list.isEmpty() ? this.getTopPassenger((Entity)list.get(0), p_34732_ - 1) : p_34731_;
    }

    protected SoundEvent getAmbientSound() {
        return this.level().isClientSide() ? null : (SoundEvent)RevampedPiglinAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent getHurtSound(DamageSource p_34767_) {
        return SoundEvents.PIGLIN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PIGLIN_DEATH;
    }

    protected void playStepSound(BlockPos p_34748_, BlockState p_34749_) {
        this.playSound(SoundEvents.PIGLIN_STEP, 0.15f, 1.0f);
    }

    protected void playConvertedSound() {
        this.makeSound(SoundEvents.PIGLIN_CONVERTED_TO_ZOMBIFIED);
    }
}

