/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.entity;

import baguchan.nether_invader.entity.ai.BastionPiglinAi;
import baguchan.nether_invader.registry.ModItems;
import baguchi.bagus_lib.register.ModSensors;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BastionGeneral
extends AbstractPiglin {
    protected static final ImmutableList<SensorType<? extends Sensor<? super BastionGeneral>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ModSensors.SMART_NEAREST_LIVING_ENTITY_SENSOR.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.HURT_BY, (Object)((SensorType)baguchan.nether_invader.registry.ModSensors.ANGER_PIGLIN_SENSOR.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.DOORS_TO_CLOSE, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)MemoryModuleType.NEARBY_ADULT_PIGLINS, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.HURT_BY, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CELEBRATE_LOCATION, MemoryModuleType.DANCING, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.NEAREST_REPELLENT});
    public AnimationState attackAnimationState = new AnimationState();
    private final int attackAnimationLength = 34;
    private int attackAnimationTick;

    public BastionGeneral(EntityType<? extends AbstractPiglin> p_34683_, Level p_34684_) {
        super(p_34683_, p_34684_);
        this.xpReward = 5;
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationState.start(this.tickCount);
            this.attackAnimationTick = 0;
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.stop();
            }
        }
    }

    protected void dropCustomDeathLoot(ServerLevel p_348503_, DamageSource p_34697_, boolean p_34699_) {
        super.dropCustomDeathLoot(p_348503_, p_34697_, p_34699_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326106_) {
        super.defineSynchedData(p_326106_);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_34727_) {
        super.onSyncedDataUpdated(p_34727_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ARMOR, 4.0).add(Attributes.ARMOR_TOUGHNESS, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 35.0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_363352_, @Nullable SpawnGroupData p_21437_) {
        RandomSource randomsource = p_21434_.getRandom();
        BastionPiglinAi.initMemories(this, p_21434_.getRandom());
        this.populateDefaultEquipmentSlots(randomsource, p_21435_);
        this.populateDefaultEquipmentEnchantments(p_21434_, randomsource, p_21435_);
        return super.finalizeSpawn(p_21434_, p_21435_, p_363352_, p_21437_);
    }

    public boolean removeWhenFarAway(double p_34775_) {
        return !this.isPersistenceRequired();
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219189_, DifficultyInstance p_219190_) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.LAVA_INFUSED_SWORD.asItem()));
    }

    protected Brain.Provider<BastionGeneral> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_34723_) {
        return BastionPiglinAi.makeBrain(this, (Brain<BastionGeneral>)this.brainProvider().makeBrain(p_34723_));
    }

    public Brain<BastionGeneral> getBrain() {
        return super.getBrain();
    }

    public boolean isBaby() {
        return false;
    }

    protected boolean canHunt() {
        return false;
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("piglinBrain");
        this.getBrain().tick(serverLevel, (LivingEntity)this);
        profilerfiller.pop();
        BastionPiglinAi.updateActivity(this);
        super.customServerAiStep(serverLevel);
    }

    protected int getBaseExperienceReward(ServerLevel p_376894_) {
        return this.xpReward;
    }

    protected void finishConversion(ServerLevel p_34756_) {
        super.finishConversion(p_34756_);
    }

    public PiglinArmPose getArmPose() {
        if (this.isAggressive() && this.isHoldingMeleeWeapon()) {
            return PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return this.isAggressive() && this.isHolding(is -> is.getItem() instanceof CrossbowItem) ? PiglinArmPose.CROSSBOW_HOLD : PiglinArmPose.DEFAULT;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_34694_, float p_34695_) {
        boolean flag = super.hurtServer(serverLevel, p_34694_, p_34695_);
        if (this.level().isClientSide()) {
            return false;
        }
        if (flag && p_34694_.getEntity() instanceof LivingEntity) {
            BastionPiglinAi.wasHurtBy(serverLevel, this, (LivingEntity)p_34694_.getEntity());
        }
        return flag;
    }

    public boolean startRiding(Entity p_21396_, boolean p_21397_, boolean p_433558_) {
        if (this.isBaby() && p_21396_.getType() == EntityType.HOGLIN) {
            p_21396_ = this.getTopPassenger(p_21396_, 3);
        }
        return super.startRiding(p_21396_, p_21397_, p_433558_);
    }

    private Entity getTopPassenger(Entity p_34731_, int p_34732_) {
        List list = p_34731_.getPassengers();
        return p_34732_ != 1 && !list.isEmpty() ? this.getTopPassenger((Entity)list.get(0), p_34732_ - 1) : p_34731_;
    }

    protected SoundEvent getAmbientSound() {
        return this.level().isClientSide() ? null : (SoundEvent)BastionPiglinAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent getHurtSound(DamageSource p_34767_) {
        return SoundEvents.PIGLIN_BRUTE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PIGLIN_BRUTE_DEATH;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void playStepSound(BlockPos p_34748_, BlockState p_34749_) {
        this.playSound(SoundEvents.PIGLIN_STEP, 0.15f, 1.0f);
    }

    protected void playConvertedSound() {
        this.makeSound(SoundEvents.PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED);
    }
}

