/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.entity;

import baguchan.nether_invader.network.ChainPacket;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public interface Chainable {
    public static final String LEASH_TAG = "chain";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    @Nullable
    public ChainData getChainData();

    public void setChainData(@Nullable ChainData var1);

    default public boolean isChained() {
        return this.getChainData() != null && this.getChainData().chainHolder != null;
    }

    default public boolean mayBeChained() {
        return this.getChainData() != null;
    }

    default public boolean canHaveAChainAttachedTo(Entity p_418026_) {
        if (this == p_418026_) {
            return false;
        }
        return !(this.leashDistanceTo(p_418026_) > this.chainSnapDistance()) && this.canBeChained();
    }

    default public double leashDistanceTo(Entity p_418359_) {
        return p_418359_.getBoundingBox().getCenter().distanceTo(((Entity)this).getBoundingBox().getCenter());
    }

    default public boolean canBeChained() {
        return true;
    }

    default public void setDelayedChainHolderId(int p_352387_) {
        this.setChainData(new ChainData(p_352387_));
        Chainable.dropChain((Entity)this, false, false);
    }

    default public void readChainData(ValueInput p_422278_) {
        ChainData leashable$leashdata = p_422278_.read(LEASH_TAG, ChainData.CODEC).orElse(null);
        if (this.getChainData() != null && leashable$leashdata == null) {
            this.removeChain();
        }
        this.setChainData(leashable$leashdata);
    }

    default public void writeChainData(ValueOutput p_422090_, @Nullable ChainData p_352363_) {
        p_422090_.storeNullable(LEASH_TAG, ChainData.CODEC, (Object)p_352363_);
    }

    private static <E extends Entity> void restoreChainFromSave(E p_352354_, ChainData p_352106_) {
        Level var3;
        if (p_352106_.delayedChainInfo != null && (var3 = p_352354_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var3;
            Optional optional1 = p_352106_.delayedChainInfo.left();
            Optional optional = p_352106_.delayedChainInfo.right();
            if (optional1.isPresent()) {
                Entity entity = serverlevel.getEntity((UUID)optional1.get());
                if (entity != null) {
                    Chainable.setChainedTo(p_352354_, entity, true);
                    return;
                }
            } else if (optional.isPresent()) {
                return;
            }
            if (p_352354_.tickCount > 100) {
                p_352354_.spawnAtLocation(serverlevel, (ItemLike)Items.IRON_CHAIN);
                ((Chainable)p_352354_).setChainData(null);
            }
        }
    }

    default public void dropChain() {
        Chainable.dropChain((Entity)this, true, true);
    }

    default public void removeChain() {
        Chainable.dropChain((Entity)this, true, false);
    }

    default public void onChainRemoved() {
    }

    private static <E extends Entity> void dropChain(E p_352163_, boolean p_352286_, boolean p_352272_) {
        ChainData leashable$leashdata = ((Chainable)p_352163_).getChainData();
        if (leashable$leashdata != null && leashable$leashdata.chainHolder != null) {
            ((Chainable)p_352163_).setChainData(null);
            ((Chainable)p_352163_).onChainRemoved();
            Level var5 = p_352163_.level();
            if (var5 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var5;
                if (p_352272_) {
                    p_352163_.spawnAtLocation(serverlevel, (ItemLike)Items.IRON_CHAIN);
                }
                if (p_352286_) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ChainPacket(p_352163_, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public static <E extends Entity> void tickChain(ServerLevel p_376374_, E p_352082_) {
        ChainData leashable$leashdata = ((Chainable)p_352082_).getChainData();
        if (leashable$leashdata != null && leashable$leashdata.delayedChainInfo != null) {
            Chainable.restoreChainFromSave(p_352082_, leashable$leashdata);
        }
        if (leashable$leashdata != null && leashable$leashdata.chainHolder != null) {
            Entity entity;
            if (!p_352082_.canInteractWithLevel() || !leashable$leashdata.chainHolder.canInteractWithLevel()) {
                if (p_376374_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    ((Chainable)p_352082_).dropChain();
                } else {
                    ((Chainable)p_352082_).removeChain();
                }
            }
            if ((entity = ((Chainable)p_352082_).getChainHolder()) != null && entity.level() == p_352082_.level()) {
                double d0 = ((Chainable)p_352082_).leashDistanceTo(entity);
                ((Chainable)p_352082_).whenChainedTo(entity);
                if (d0 > ((Chainable)p_352082_).chainSnapDistance()) {
                    p_376374_.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((Chainable)p_352082_).chainTooFarBehaviour();
                } else if (d0 > ((Chainable)p_352082_).leashElasticDistance() - (double)entity.getBbWidth() - (double)p_352082_.getBbWidth() && ((Chainable)p_352082_).checkElasticInteractions(entity, leashable$leashdata)) {
                    ((Chainable)p_352082_).onElasticChainPull();
                } else {
                    ((Chainable)p_352082_).closeRangeChainBehaviour(entity);
                }
                p_352082_.setYRot((float)((double)p_352082_.getYRot() - leashable$leashdata.angularMomentum));
                leashable$leashdata.angularMomentum *= (double)Chainable.angularFriction(p_352082_);
            }
        }
    }

    default public void onElasticChainPull() {
        Entity entity = (Entity)this;
        entity.checkFallDistanceAccumulation();
    }

    default public double chainSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E p_418015_) {
        if (p_418015_.onGround()) {
            BlockPos groundPos = p_418015_.getBlockPosBelowThatAffectsMyMovement();
            return p_418015_.level().getBlockState(groundPos).getFriction((LevelReader)p_418015_.level(), groundPos, p_418015_) * 0.91f;
        }
        return p_418015_.isInLiquid() ? 0.8f : 0.91f;
    }

    default public void whenChainedTo(Entity p_418473_) {
    }

    default public void chainTooFarBehaviour() {
        this.dropChain();
    }

    default public void closeRangeChainBehaviour(Entity p_352073_) {
    }

    default public boolean checkElasticInteractions(Entity p_418481_, ChainData p_418158_) {
        boolean flag = p_418481_.supportQuadLeashAsHolder() && this.supportQuadChain();
        List<Wrench> list = Chainable.computeElasticInteraction((Entity)this, p_418481_, flag ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, flag ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (list.isEmpty()) {
            return false;
        }
        Wrench leashable$wrench = Wrench.accumulate(list).scale(flag ? 0.25 : 1.0);
        p_418158_.angularMomentum += 10.0 * leashable$wrench.torque();
        Vec3 vec3 = Chainable.getHolderMovement(p_418481_).subtract(((Entity)this).getKnownMovement());
        ((Entity)this).addDeltaMovement(leashable$wrench.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(vec3.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity p_426117_) {
        Mob mob;
        if (p_426117_ instanceof Mob && (mob = (Mob)p_426117_).isNoAi()) {
            Vec3 var10000 = Vec3.ZERO;
            return var10000;
        }
        Vec3 var10000 = p_426117_.getKnownMovement();
        return var10000;
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E p_418297_, Entity p_418456_, List<Vec3> p_418351_, List<Vec3> p_418397_) {
        double d0 = ((Chainable)p_418297_).leashElasticDistance();
        Vec3 vec3 = Chainable.getHolderMovement(p_418297_);
        float f = p_418297_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec31 = new Vec3((double)p_418297_.getBbWidth(), (double)p_418297_.getBbHeight(), (double)p_418297_.getBbWidth());
        float f1 = p_418456_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec32 = new Vec3((double)p_418456_.getBbWidth(), (double)p_418456_.getBbHeight(), (double)p_418456_.getBbWidth());
        ArrayList<Wrench> list = new ArrayList<Wrench>();
        for (int i = 0; i < p_418351_.size(); ++i) {
            Vec3 vec33 = p_418351_.get(i).multiply(vec31).yRot(-f);
            Vec3 vec34 = p_418297_.position().add(vec33);
            Vec3 vec35 = p_418397_.get(i).multiply(vec32).yRot(-f1);
            Vec3 vec36 = p_418456_.position().add(vec35);
            Optional<Wrench> var10000 = Chainable.computeDampenedSpringInteraction(vec36, vec34, d0, vec3, vec33);
            Objects.requireNonNull(list);
            var10000.ifPresent(list::add);
        }
        return list;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 p_418217_, Vec3 p_418024_, double p_418081_, Vec3 p_418190_, Vec3 p_418069_) {
        boolean flag;
        double d0 = p_418024_.distanceTo(p_418217_);
        if (d0 < p_418081_) {
            return Optional.empty();
        }
        Vec3 vec3 = p_418217_.subtract(p_418024_).normalize().scale(d0 - p_418081_);
        double d1 = Wrench.torqueFromForce(p_418069_, vec3);
        boolean bl = flag = p_418190_.dot(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.scale((double)0.3f);
        }
        return Optional.of(new Wrench(vec3, d1));
    }

    default public boolean supportQuadChain() {
        return false;
    }

    default public Vec3[] getQuadChainOffsets() {
        return Chainable.createQuadChainOffsets((Entity)this, 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadChainOffsets(Entity p_418142_, double p_418244_, double p_418078_, double p_418298_, double p_418121_) {
        float f = p_418142_.getBbWidth();
        double d0 = p_418244_ * (double)f;
        double d1 = p_418078_ * (double)f;
        double d2 = p_418298_ * (double)f;
        double d3 = p_418121_ * (double)p_418142_.getBbHeight();
        return new Vec3[]{new Vec3(-d2, d3, d1 + d0), new Vec3(-d2, d3, -d1 + d0), new Vec3(d2, d3, -d1 + d0), new Vec3(d2, d3, d1 + d0)};
    }

    default public Vec3 getChainOffset(float p_418480_) {
        return this.getChainOffset();
    }

    default public Vec3 getChainOffset() {
        Entity entity = (Entity)this;
        return new Vec3(0.0, (double)entity.getEyeHeight(), (double)(entity.getBbWidth() * 0.4f));
    }

    default public void setChainedTo(Entity p_352411_, boolean p_352183_) {
        if (this != p_352411_) {
            Chainable.setChainedTo((Entity)this, p_352411_, p_352183_);
        }
    }

    private static <E extends Entity> void setChainedTo(E p_352280_, Entity p_352109_, boolean p_352239_) {
        ChainData leashable$leashdata = ((Chainable)p_352280_).getChainData();
        if (leashable$leashdata == null) {
            leashable$leashdata = new ChainData(p_352109_);
            ((Chainable)p_352280_).setChainData(leashable$leashdata);
        } else {
            Entity entity = leashable$leashdata.chainHolder;
            leashable$leashdata.setChainHolder(p_352109_);
            if (entity == null || entity != p_352109_) {
                // empty if block
            }
        }
        Level var5 = p_352280_.level();
        if (var5 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var5;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ChainPacket(p_352280_, p_352109_), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (p_352280_.isPassenger()) {
            p_352280_.stopRiding();
        }
    }

    @Nullable
    default public Entity getChainHolder() {
        return Chainable.getChainHolder((Entity)this);
    }

    @Nullable
    private static <E extends Entity> Entity getChainHolder(E p_352466_) {
        Entity entity;
        ChainData leashable$leashdata = ((Chainable)p_352466_).getChainData();
        if (leashable$leashdata == null) {
            return null;
        }
        if (leashable$leashdata.delayedChainHolderId != 0 && p_352466_.level().isClientSide() && (entity = p_352466_.level().getEntity(leashable$leashdata.delayedChainHolderId)) instanceof Entity) {
            leashable$leashdata.setChainHolder(entity);
        }
        return leashable$leashdata.chainHolder;
    }

    public static List<Chainable> leashableChainedTo(Entity p_418021_) {
        return Chainable.leashableInArea(p_418021_, p_418528_ -> p_418528_.getChainHolder() == p_418021_);
    }

    public static List<Chainable> leashableInArea(Entity p_418133_, Predicate<Chainable> p_418334_) {
        return Chainable.leashableInArea(p_418133_.level(), p_418133_.getBoundingBox().getCenter(), p_418334_);
    }

    public static List<Chainable> leashableInArea(Level p_418478_, Vec3 p_418494_, Predicate<Chainable> p_418347_) {
        double d0 = 32.0;
        AABB aabb = AABB.ofSize((Vec3)p_418494_, (double)32.0, (double)32.0, (double)32.0);
        Stream var10000 = p_418478_.getEntitiesOfClass(Entity.class, aabb, p_418131_ -> {
            Chainable leashable;
            if (p_418131_ instanceof Chainable && p_418347_.test(leashable = (Chainable)p_418131_)) {
                boolean b1 = true;
                return b1;
            }
            boolean b1 = false;
            return b1;
        }).stream();
        Objects.requireNonNull(Chainable.class);
        return var10000.map(o -> o).toList();
    }

    public static final class ChainData {
        public static final Codec<ChainData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), (Codec)BlockPos.CODEC).xmap(ChainData::new, p_412912_ -> p_412912_.chainHolder != null ? Either.left((Object)p_412912_.chainHolder.getUUID()) : Objects.requireNonNull(p_412912_.delayedChainInfo, "Invalid ChainData had no attachment"));
        int delayedChainHolderId;
        @Nullable
        public Entity chainHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedChainInfo;
        public double angularMomentum;

        private ChainData(Either<UUID, BlockPos> p_352282_) {
            this.delayedChainInfo = p_352282_;
        }

        ChainData(Entity p_352066_) {
            this.chainHolder = p_352066_;
        }

        ChainData(int p_352297_) {
            this.delayedChainHolderId = p_352297_;
        }

        public void setChainHolder(Entity p_352464_) {
            this.chainHolder = p_352464_;
            this.delayedChainInfo = null;
            this.delayedChainHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 p_418322_, Vec3 p_418094_) {
            return p_418322_.z * p_418094_.x - p_418322_.x * p_418094_.z;
        }

        static Wrench accumulate(List<Wrench> p_418210_) {
            if (p_418210_.isEmpty()) {
                return ZERO;
            }
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Wrench leashable$wrench : p_418210_) {
                Vec3 vec3 = leashable$wrench.force;
                d0 += vec3.x;
                d1 += vec3.y;
                d2 += vec3.z;
                d3 += leashable$wrench.torque;
            }
            return new Wrench(new Vec3(d0, d1, d2), d3);
        }

        public Wrench scale(double p_418466_) {
            return new Wrench(this.force.scale(p_418466_), this.torque * p_418466_);
        }
    }
}

