/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.mixin;

import baguchan.nether_invader.api.IPiglinImmunite;
import baguchan.nether_invader.entity.PiglinRaider;
import baguchan.nether_invader.world.raid.PiglinRaid;
import baguchan.nether_invader.world.savedata.PiglinRaidData;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractPiglin.class})
public abstract class AbstractPiglinMixin
extends Monster
implements IPiglinImmunite,
PiglinRaider {
    @Unique
    private boolean netherInvader$immuniteByPotion;
    @Nullable
    @Unique
    protected PiglinRaid netherInvader$raid;
    @Unique
    private int netherInvader$wave;
    @Unique
    private boolean netherInvader$canJoinRaid;
    @Unique
    private int netherInvader$ticksOutsideRaid;
    @Unique
    private boolean netherInvader$patrolLeader;
    @Unique
    private boolean netherInvader$patrolling;

    protected AbstractPiglinMixin(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    protected void customServerAiStep(ServerLevel serverLevel, CallbackInfo ci) {
        if (this.level() instanceof ServerLevel && this.isAlive()) {
            PiglinRaid raid = this.netherInvader$getCurrentRaid();
            if (this.netherInvader$canJoinRaid()) {
                if (raid == null) {
                    PiglinRaid raid1;
                    if (this.level().getGameTime() % 20L == 0L && (raid1 = PiglinRaidData.get(this.level()).getPiglinRaidAt(this.blockPosition())) != null && PiglinRaidData.canJoinPiglinRaid(this)) {
                        raid1.joinRaid(serverLevel, raid1.getGroupsSpawned(), (AbstractPiglin)this, null, true);
                    }
                } else {
                    LivingEntity livingentity = this.getTarget();
                    if (livingentity != null && (livingentity.getType() == EntityType.PLAYER || livingentity.getType() == EntityType.IRON_GOLEM)) {
                        this.noActionTime = 0;
                    }
                }
            }
        }
    }

    @Inject(method={"isConverting"}, at={@At(value="HEAD")}, cancellable=true)
    public void isConverting(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (this.level().getBiome(this.blockPosition()).is(BiomeTags.IS_NETHER)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(ValueOutput p_421634_, CallbackInfo ci) {
        p_421634_.putBoolean("immunite_by_potion", this.netherInvader$immuniteByPotion);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(ValueInput p_422019_, CallbackInfo ci) {
        this.netherInvader$immuniteByPotion = p_422019_.getBooleanOr("immunite_by_potion", false);
    }

    @Override
    @Unique
    public void setNetherInvader$immuniteByPotion(boolean netherInvader$immuniteByPotion) {
        this.netherInvader$immuniteByPotion = netherInvader$immuniteByPotion;
    }

    @Override
    public int netherInvader$getTicksOutsideRaid() {
        return this.netherInvader$ticksOutsideRaid;
    }

    @Override
    public void netherInvader$setTicksOutsideRaid(int p_37864_) {
        this.netherInvader$ticksOutsideRaid = p_37864_;
    }

    @Override
    @Unique
    public boolean isNetherInvader$immuniteByPotion() {
        return this.netherInvader$immuniteByPotion;
    }

    @Override
    @Unique
    public boolean netherInvader$canJoinRaid() {
        return this.netherInvader$canJoinRaid;
    }

    @Override
    @Unique
    public void netherInvader$setCanJoinRaid(boolean p_37898_) {
        this.netherInvader$canJoinRaid = p_37898_;
    }

    @Override
    public boolean netherInvader$canJoinPatrol() {
        return !this.netherInvader$hasActiveRaid();
    }

    @Override
    @Unique
    public void netherInvader$setCurrentRaid(@Nullable PiglinRaid p_37852_) {
        this.netherInvader$raid = p_37852_;
    }

    @Override
    @Nullable
    public PiglinRaid netherInvader$getCurrentRaid() {
        return this.netherInvader$raid;
    }

    @Override
    @Unique
    public boolean netherInvader$isCaptain() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
        boolean flag = !itemstack.isEmpty() && ItemStack.matches((ItemStack)itemstack, (ItemStack)PiglinRaid.getLeaderBannerInstance((HolderGetter<BannerPattern>)this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        boolean flag1 = this.netherInvader$isPatrolLeader();
        return flag && flag1;
    }

    @Override
    @Unique
    public void netherInvader$setPatrolLeader(boolean p_33076_) {
        this.netherInvader$patrolLeader = p_33076_;
        this.netherInvader$patrolling = true;
    }

    @Override
    @Unique
    public boolean netherInvader$isPatrolLeader() {
        return this.netherInvader$patrolLeader;
    }

    @Override
    @Unique
    public boolean netherInvader$hasRaid() {
        boolean bl;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            bl = false;
        } else {
            ServerLevel serverlevel = (ServerLevel)level;
            bl = this.netherInvader$getCurrentRaid() != null || PiglinRaidData.get((Level)serverlevel).getPiglinRaidAt(this.blockPosition()) != null;
        }
        return bl;
    }

    @Override
    @Unique
    public void netherInvader$setWave(int p_37843_) {
        this.netherInvader$wave = p_37843_;
    }

    @Override
    @Unique
    public int netherInvader$getWave() {
        return this.netherInvader$wave;
    }

    @Override
    public void netherInvader$applyRaidBuffs(ServerLevel level, int p37714, boolean b) {
    }

    public void die(DamageSource p_37847_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = p_37847_.getEntity();
            PiglinRaid raid = this.netherInvader$getCurrentRaid();
            if (raid != null) {
                if (this.netherInvader$isPatrolLeader()) {
                    raid.removeLeader(this.netherInvader$getWave());
                }
                if (entity != null && entity.getType() == EntityType.PLAYER) {
                    raid.addHeroOfTheVillage(entity);
                }
                raid.removeFromRaid(serverLevel, (AbstractPiglin)this, false);
            }
        }
        super.die(p_37847_);
    }
}

