/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.network;

import baguchan.nether_invader.entity.Chainable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class ChainPacket
implements CustomPacketPayload,
IPayloadHandler<ChainPacket> {
    public static final StreamCodec<FriendlyByteBuf, ChainPacket> STREAM_CODEC = CustomPacketPayload.codec(ChainPacket::write, ChainPacket::new);
    public static final CustomPacketPayload.Type<ChainPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nether_invader", (String)"chain"));
    private final int sourceId;
    private final int destId;

    public ChainPacket(Entity p_133164_, @Nullable Entity p_133165_) {
        this.sourceId = p_133164_.getId();
        this.destId = p_133165_ != null ? p_133165_.getId() : 0;
    }

    public ChainPacket(int sourceId, int destId) {
        this.sourceId = sourceId;
        this.destId = destId;
    }

    public ChainPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.sourceId);
        buf.writeInt(this.destId);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(ChainPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.getInstance().player != null && (entity = Minecraft.getInstance().player.level().getEntity(message.sourceId)) instanceof Chainable) {
                Chainable chainable = (Chainable)entity;
                chainable.setDelayedChainHolderId(message.destId);
            }
        });
    }
}

