/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.registry;

import baguchan.nether_invader.entity.AgressivePiglin;
import baguchan.nether_invader.entity.BastionGeneral;
import baguchan.nether_invader.entity.ChainedGhast;
import baguchan.nether_invader.entity.Scaffolding;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="nether_invader")
public class ModEntitys {
    public static final DeferredRegister<EntityType<?>> ENTITIES_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"nether_invader");
    public static final DeferredHolder<EntityType<?>, EntityType<ChainedGhast>> CHAINED_GHAST = ENTITIES_REGISTRY.register("chained_ghast", () -> EntityType.Builder.of(ChainedGhast::new, (MobCategory)MobCategory.MONSTER).fireImmune().sized(4.0f, 4.0f).eyeHeight(2.6f).passengerAttachments(new float[]{4.0625f}).ridingOffset(0.5f).clientTrackingRange(10).build(ModEntitys.prefix("chained_ghast")));
    public static final DeferredHolder<EntityType<?>, EntityType<Scaffolding>> SCAFFOLDING = ENTITIES_REGISTRY.register("scaffolding", () -> EntityType.Builder.of(Scaffolding::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(ModEntitys.prefix("scaffolding")));
    public static final DeferredHolder<EntityType<?>, EntityType<AgressivePiglin>> AGRESSIVE_PIGLIN = ENTITIES_REGISTRY.register("agressive_piglin", () -> EntityType.Builder.of(AgressivePiglin::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.79f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).notInPeaceful().clientTrackingRange(8).build(ModEntitys.prefix("agressive_piglin")));
    public static final DeferredHolder<EntityType<?>, EntityType<BastionGeneral>> BASTION_GENERAL = ENTITIES_REGISTRY.register("bastion_general", () -> EntityType.Builder.of(BastionGeneral::new, (MobCategory)MobCategory.MONSTER).sized(0.9f, 2.15f).eyeHeight(1.85f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).notInPeaceful().clientTrackingRange(8).build(ModEntitys.prefix("bastion_general")));

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put((EntityType)CHAINED_GHAST.get(), ChainedGhast.createAttributes().build());
        event.put((EntityType)SCAFFOLDING.get(), Scaffolding.createAttributes().build());
        event.put((EntityType)AGRESSIVE_PIGLIN.get(), AgressivePiglin.createAttributes().build());
        event.put((EntityType)BASTION_GENERAL.get(), BastionGeneral.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerEntityPlace(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CHAINED_GHAST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChainedGhast::checkChainGhastSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)AGRESSIVE_PIGLIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)BASTION_GENERAL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    private static ResourceKey<EntityType<?>> prefix(String path) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nether_invader", (String)path));
    }
}

