/*
 * Decompiled with CFR 0.152.
 */
package baguchan.nether_invader.world.savedata;

import baguchan.nether_invader.NetherConfigs;
import baguchan.nether_invader.entity.PiglinRaider;
import baguchan.nether_invader.world.raid.PiglinRaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;

public class PiglinRaidData
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    public static final Codec<PiglinRaidData> CODEC = RecordCodecBuilder.create(p_400930_ -> p_400930_.group((App)RaidWithId.CODEC.listOf().optionalFieldOf(RAID_FILE_ID, List.of()).forGetter(p_400932_ -> p_400932_.raidMap.int2ObjectEntrySet().stream().map(RaidWithId::from).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(p_400933_ -> p_400933_.nextId), (App)Codec.INT.fieldOf("tick").forGetter(p_400931_ -> p_400931_.tick)).apply((Applicative)p_400930_, PiglinRaidData::new));
    public static final SavedDataType<PiglinRaidData> TYPE;
    public static final SavedDataType<PiglinRaidData> TYPE_END;
    private final Int2ObjectMap<PiglinRaid> raidMap = new Int2ObjectOpenHashMap();
    private int nextId = 1;
    private int tick;
    private static Map<Level, PiglinRaidData> dataMap;

    public static SavedDataType<PiglinRaidData> getType(Holder<DimensionType> p_401277_) {
        return p_401277_.is(BuiltinDimensionTypes.END) ? TYPE_END : TYPE;
    }

    public PiglinRaidData() {
        this.setDirty();
    }

    private PiglinRaidData(List<RaidWithId> p_401252_, int p_401028_, int p_401314_) {
        for (RaidWithId raids$raidwithid : p_401252_) {
            this.raidMap.put(raids$raidwithid.id, (Object)raids$raidwithid.raid);
        }
        this.nextId = p_401028_;
        this.tick = p_401314_;
    }

    public static PiglinRaidData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            PiglinRaidData fromMap = dataMap.get(serverLevel);
            if (fromMap == null) {
                DimensionDataStorage storage = serverLevel.getDataStorage();
                PiglinRaidData data = (PiglinRaidData)storage.computeIfAbsent(TYPE);
                if (data != null) {
                    data.setDirty();
                }
                dataMap.put(world, data);
                return data;
            }
            return fromMap;
        }
        return null;
    }

    @Nullable
    public PiglinRaid get(int p_37959_) {
        return (PiglinRaid)this.raidMap.get(p_37959_);
    }

    public OptionalInt getId(PiglinRaid p_401241_) {
        for (Int2ObjectMap.Entry entry : this.raidMap.int2ObjectEntrySet()) {
            if (entry.getValue() != p_401241_) continue;
            return OptionalInt.of(entry.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void tick(ServerLevel p_401204_) {
        ++this.tick;
        ObjectIterator iterator = this.raidMap.values().iterator();
        while (iterator.hasNext()) {
            PiglinRaid raid = (PiglinRaid)iterator.next();
            if (p_401204_.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.setDirty();
                continue;
            }
            raid.tick(p_401204_);
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
    }

    public static boolean canJoinPiglinRaid(PiglinRaider p_37966_) {
        Mob entity;
        return p_37966_ instanceof Mob && (entity = (Mob)p_37966_).isAlive() && p_37966_.netherInvader$canJoinRaid() && entity.getNoActionTime() <= 2400;
    }

    @Nullable
    public PiglinRaid createOrExtendPiglinRaid(ServerPlayer p_37964_, BlockPos p_338602_) {
        BlockPos blockpos1;
        if (p_37964_.isSpectator()) {
            return null;
        }
        ServerLevel serverlevel = p_37964_.level();
        if (serverlevel.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        ResourceKey dimensiontype = serverlevel.dimension();
        if (!((List)NetherConfigs.COMMON.ENABLE_DIMENSIONS.get()).contains(dimensiontype.location().toString())) {
            return null;
        }
        List list = serverlevel.getPoiManager().getInRange(p_219845_ -> p_219845_.is(PoiTypeTags.VILLAGE), p_338602_, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int i = 0;
        Vec3 vec3 = Vec3.ZERO;
        for (PoiRecord poirecord : list) {
            BlockPos blockpos = poirecord.getPos();
            vec3 = vec3.add((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ());
            ++i;
        }
        if (i > 0) {
            vec3 = vec3.scale(1.0 / (double)i);
            blockpos1 = BlockPos.containing((Position)vec3);
        } else {
            blockpos1 = p_338602_;
        }
        PiglinRaid raid = this.getOrCreatePiglinRaid(serverlevel, blockpos1);
        if (!raid.isStarted() && !this.raidMap.containsValue((Object)raid)) {
            this.raidMap.put(this.getUniqueId(), (Object)raid);
        }
        if (!raid.isStarted() || raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            raid.absorbRaidOmen(p_37964_);
        }
        this.setDirty();
        return raid;
    }

    private PiglinRaid getOrCreatePiglinRaid(ServerLevel p_37961_, BlockPos p_37962_) {
        PiglinRaid raid = this.getPiglinRaidAt(p_37962_);
        return raid != null ? raid : new PiglinRaid(p_37962_, p_37961_.getDifficulty());
    }

    @Nullable
    public PiglinRaid getPiglinRaidAt(BlockPos p_8833_) {
        return this.getNearbyPiglinRaid(p_8833_, 9216);
    }

    public static PiglinRaidData load(CompoundTag p_150237_) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_150237_).resultOrPartial().orElseGet(PiglinRaidData::new);
    }

    private int getUniqueId() {
        return ++this.nextId;
    }

    @Nullable
    public PiglinRaid getNearbyPiglinRaid(BlockPos p_37971_, int p_37972_) {
        PiglinRaid raid = null;
        double d0 = p_37972_;
        for (PiglinRaid raid1 : this.raidMap.values()) {
            double d1 = raid1.getCenter().distSqr((Vec3i)p_37971_);
            if (!raid1.isActive() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }

    static {
        dataMap = new HashMap<Level, PiglinRaidData>();
        TYPE = new SavedDataType("piglin_raids", PiglinRaidData::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
        TYPE_END = new SavedDataType("piglin_raids_end", PiglinRaidData::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    }

    record RaidWithId(int id, PiglinRaid raid) {
        public static final Codec<RaidWithId> CODEC = RecordCodecBuilder.create(p_401087_ -> p_401087_.group((App)Codec.INT.fieldOf("id").forGetter(RaidWithId::id), (App)PiglinRaid.MAP_CODEC.forGetter(RaidWithId::raid)).apply((Applicative)p_401087_, RaidWithId::new));

        public static RaidWithId from(Int2ObjectMap.Entry<PiglinRaid> p_401228_) {
            return new RaidWithId(p_401228_.getIntKey(), (PiglinRaid)p_401228_.getValue());
        }
    }
}

