/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.hedgetech.slashfly.CommonClass;
import org.hedgetech.slashfly.Fly;
import org.hedgetech.slashfly.commands.CommandRegistry;

@Mod(value="slashfly")
public class NeoForgeSlashFly {
    public NeoForgeSlashFly(IEventBus eventBus) {
        CommonClass.init();
        NeoForge.EVENT_BUS.addListener(NeoForgeSlashFly::onCommandRegister);
        NeoForge.EVENT_BUS.addListener(NeoForgeSlashFly::onPlayerLogout);
        NeoForge.EVENT_BUS.addListener(NeoForgeSlashFly::onPlayerLogin);
        NeoForge.EVENT_BUS.addListener(NeoForgeSlashFly::onPlayerRespawn);
        NeoForge.EVENT_BUS.addListener(NeoForgeSlashFly::onPlayerBreakSpeed);
    }

    private static void onCommandRegister(RegisterCommandsEvent event) {
        CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Fly.savePlayer(event.getEntity(), event.getEntity().level().getServer());
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            Fly.initPlayer(sPlayer, event.getEntity().level().getServer());
        }
    }

    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Fly.onPlayerRespawn(player.getStringUUID(), player);
    }

    private static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        Abilities abilities = player.getAbilities();
        boolean onGround = player.onGround();
        if (!onGround && abilities.flying) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }
}

