/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly.saveddata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.hedgetech.slashfly.data.PlayerData;

public class PlayerSavedData
extends SavedData {
    public static final Codec<Map<String, PlayerData>> PLAYER_DATA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, PlayerData.CODEC);
    public static final Codec<PlayerSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PLAYER_DATA_CODEC.fieldOf("player_data").forGetter(PlayerSavedData::getPlayerDatum)).apply((Applicative)instance, PlayerSavedData::new));
    private final HashMap<String, PlayerData> playerDatum = new HashMap();
    private static final SavedDataType<PlayerSavedData> TYPE = new SavedDataType("slashfly", PlayerSavedData::new, CODEC, null);

    public PlayerSavedData() {
    }

    public PlayerSavedData(Map<String, PlayerData> playerDatum) {
        this.playerDatum.putAll(playerDatum);
    }

    public Map<String, PlayerData> getPlayerDatum() {
        return this.playerDatum;
    }

    public PlayerData getPlayerData(String uuidString) {
        return this.playerDatum.computeIfAbsent(uuidString, playerUUID -> new PlayerData());
    }

    public boolean togglePlayerFlight(Player player) {
        boolean enabled = false;
        if (player != null) {
            Abilities playerAbilities = player.getAbilities();
            boolean mayFly = playerAbilities.mayfly;
            enabled = this.togglePlayerFlight(player, !mayFly);
        }
        return enabled;
    }

    public boolean togglePlayerFlight(Player player, boolean enableFlight) {
        boolean enabled = false;
        if (player != null) {
            PlayerData playerData = this.getPlayerData(player.getStringUUID());
            Abilities playerAbilities = player.getAbilities();
            boolean onGround = player.onGround();
            boolean flying = enableFlight && !onGround;
            playerAbilities.mayfly = enableFlight;
            playerAbilities.flying = flying;
            player.onUpdateAbilities();
            playerData.setMayFly(enableFlight);
            playerData.setIsFlying(flying);
            this.setDirty();
            enabled = enableFlight;
        }
        return enabled;
    }

    public void setPlayerFlightSpeed(Player player, float speed) {
        if (player != null) {
            PlayerData playerData = this.getPlayerData(player.getStringUUID());
            Abilities playerAbilities = player.getAbilities();
            float normalizedSpeed = speed / 10.0f;
            playerAbilities.setFlyingSpeed(normalizedSpeed);
            player.onUpdateAbilities();
            playerData.setFlightSpeed(normalizedSpeed);
            this.setDirty();
        }
    }

    public static PlayerSavedData ofServer(MinecraftServer server) {
        try {
            return (PlayerSavedData)Objects.requireNonNull(server.overworld()).getDataStorage().computeIfAbsent(TYPE);
        }
        catch (Exception e) {
            DimensionDataStorage dataStore = Objects.requireNonNull(server.overworld()).getDataStorage();
            dataStore.set(TYPE, (SavedData)new PlayerSavedData());
            return (PlayerSavedData)dataStore.computeIfAbsent(TYPE);
        }
    }
}

