/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly.saveddata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10741;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;
import org.hedgetech.slashfly.data.PlayerData;

public class PlayerSavedData
extends class_18 {
    public static final Codec<Map<String, PlayerData>> PLAYER_DATA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, PlayerData.CODEC);
    public static final Codec<PlayerSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PLAYER_DATA_CODEC.fieldOf("player_data").forGetter(PlayerSavedData::getPlayerDatum)).apply((Applicative)instance, PlayerSavedData::new));
    private final HashMap<String, PlayerData> playerDatum = new HashMap();
    private static final class_10741<PlayerSavedData> TYPE = new class_10741("slashfly", PlayerSavedData::new, CODEC, null);

    public PlayerSavedData() {
    }

    public PlayerSavedData(Map<String, PlayerData> playerDatum) {
        this.playerDatum.putAll(playerDatum);
    }

    public Map<String, PlayerData> getPlayerDatum() {
        return this.playerDatum;
    }

    public PlayerData getPlayerData(String uuidString) {
        return this.playerDatum.computeIfAbsent(uuidString, playerUUID -> new PlayerData());
    }

    public boolean togglePlayerFlight(class_1657 player) {
        boolean enabled = false;
        if (player != null) {
            class_1656 playerAbilities = player.method_31549();
            boolean mayFly = playerAbilities.field_7478;
            enabled = this.togglePlayerFlight(player, !mayFly);
        }
        return enabled;
    }

    public boolean togglePlayerFlight(class_1657 player, boolean enableFlight) {
        boolean enabled = false;
        if (player != null) {
            PlayerData playerData = this.getPlayerData(player.method_5845());
            class_1656 playerAbilities = player.method_31549();
            boolean onGround = player.method_24828();
            boolean flying = enableFlight && !onGround;
            playerAbilities.field_7478 = enableFlight;
            playerAbilities.field_7479 = flying;
            player.method_7355();
            playerData.setMayFly(enableFlight);
            playerData.setIsFlying(flying);
            this.method_80();
            enabled = enableFlight;
        }
        return enabled;
    }

    public void setPlayerFlightSpeed(class_1657 player, float speed) {
        if (player != null) {
            PlayerData playerData = this.getPlayerData(player.method_5845());
            class_1656 playerAbilities = player.method_31549();
            float normalizedSpeed = speed / 10.0f;
            playerAbilities.method_7248(normalizedSpeed);
            player.method_7355();
            playerData.setFlightSpeed(normalizedSpeed);
            this.method_80();
        }
    }

    public static PlayerSavedData ofServer(MinecraftServer server) {
        try {
            return (PlayerSavedData)Objects.requireNonNull(server.method_30002()).method_17983().method_17924(TYPE);
        }
        catch (Exception e) {
            class_26 dataStore = Objects.requireNonNull(server.method_30002()).method_17983();
            dataStore.method_123(TYPE, (class_18)new PlayerSavedData());
            return (PlayerSavedData)dataStore.method_17924(TYPE);
        }
    }
}

