/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import org.hedgetech.slashfly.data.PlayerData;
import org.hedgetech.slashfly.saveddata.PlayerSavedData;

public class Fly {
    public static void initPlayer(ServerPlayer player, MinecraftServer server) {
        PlayerSavedData savedData = PlayerSavedData.ofServer(server);
        PlayerData playerData = savedData.getPlayerData(player.getStringUUID());
        Abilities playerAbilities = player.getAbilities();
        playerAbilities.mayfly = playerData.getMayFly();
        playerAbilities.flying = playerData.getIsFlying();
        playerAbilities.setFlyingSpeed(playerData.getFlightSpeed());
        player.onUpdateAbilities();
        if (playerData.getMayFly()) {
            player.sendSystemMessage((Component)Component.literal((String)("Flying enabled and speed set to " + playerData.getFlightSpeed() * 10.0f + "!")));
        }
    }

    public static void savePlayer(Player player, MinecraftServer server) {
        PlayerSavedData savedData = PlayerSavedData.ofServer(server);
        PlayerData playerData = savedData.getPlayerData(player.getStringUUID());
        savedData.togglePlayerFlight(player, playerData.getMayFly());
    }

    public static void onPlayerRespawn(String uuidString, Player player) {
        PlayerSavedData savedData = PlayerSavedData.ofServer(player.level().getServer());
        PlayerData playerData = savedData.getPlayerData(uuidString);
        savedData.togglePlayerFlight(player, playerData.getMayFly());
        savedData.setPlayerFlightSpeed(player, playerData.getFlightSpeed() * 10.0f);
    }

    public static int toggleFly(CommandSourceStack source) {
        ServerPlayer player = source.getPlayer();
        assert (player != null);
        PlayerSavedData savedData = PlayerSavedData.ofServer(source.getServer());
        if (savedData.togglePlayerFlight((Player)player)) {
            source.sendSuccess(() -> Component.literal((String)"Flying enabled!"), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Flying disabled!"), false);
        }
        return 1;
    }

    public static int setFlySpeed(CommandSourceStack source, float speed) {
        ServerPlayer player = source.getPlayer();
        assert (player != null);
        PlayerSavedData savedData = PlayerSavedData.ofServer(source.getServer());
        savedData.setPlayerFlightSpeed((Player)player, speed);
        source.sendSuccess(() -> Component.literal((String)("Flying speed set to " + speed + "!")), false);
        return 1;
    }
}

