/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import org.hedgetech.slashfly.CommonClass;
import org.hedgetech.slashfly.Fly;
import org.hedgetech.slashfly.commands.CommandRegistry;

@Mod(value="slashfly")
public class ForgeSlashFly {
    public ForgeSlashFly() {
        CommonClass.init();
        RegisterCommandsEvent.BUS.addListener(ForgeSlashFly::registerCommandsEventHandler);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(ForgeSlashFly::playerLoggedOutEventHandler);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(ForgeSlashFly::playerLoggedInEventHandler);
        PlayerEvent.PlayerRespawnEvent.BUS.addListener(ForgeSlashFly::playerRespawnEventHandler);
        PlayerEvent.BreakSpeed.BUS.addListener(ForgeSlashFly::playerBreakSpeedEventHandler);
    }

    private static void registerCommandsEventHandler(RegisterCommandsEvent event) {
        CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void playerLoggedOutEventHandler(PlayerEvent.PlayerLoggedOutEvent event) {
        Fly.savePlayer(event.getEntity(), event.getEntity().level().getServer());
    }

    private static void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Fly.initPlayer(serverPlayer, serverPlayer.level().getServer());
        }
    }

    private static void playerRespawnEventHandler(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Fly.onPlayerRespawn(player.getStringUUID(), player);
    }

    private static void playerBreakSpeedEventHandler(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        Abilities abilities = player.getAbilities();
        boolean onGround = player.onGround();
        boolean inWater = player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get());
        if (!onGround && abilities.flying) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
        if (inWater && abilities.flying) {
            event.setNewSpeed(event.getNewSpeed() / (float)Objects.requireNonNull(player.getAttribute(Attributes.SUBMERGED_MINING_SPEED)).getValue());
        }
    }
}

