/*
 * Decompiled with CFR 0.152.
 */
package org.hedgetech.slashfly;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import org.hedgetech.slashfly.CommonClass;
import org.hedgetech.slashfly.Fly;
import org.hedgetech.slashfly.commands.CommandRegistry;

@Mod(value="slashfly")
public class ForgeSlashFly {
    public ForgeSlashFly() {
        CommonClass.init();
        RegisterCommandsEvent.BUS.addListener(ForgeSlashFly::registerCommandsEventHandler);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(ForgeSlashFly::playerLoggedOutEventHandler);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(ForgeSlashFly::playerLoggedInEventHandler);
        PlayerEvent.PlayerRespawnEvent.BUS.addListener(ForgeSlashFly::playerRespawnEventHandler);
        PlayerEvent.BreakSpeed.BUS.addListener(ForgeSlashFly::playerBreakSpeedEventHandler);
    }

    private static void registerCommandsEventHandler(RegisterCommandsEvent event) {
        CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void playerLoggedOutEventHandler(PlayerEvent.PlayerLoggedOutEvent event) {
        Fly.savePlayer(event.getEntity());
    }

    private static void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Fly.initPlayer(serverPlayer);
        }
    }

    private static void playerRespawnEventHandler(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Fly.onPlayerRespawn(player.getStringUUID(), player);
    }

    private static void playerBreakSpeedEventHandler(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        Abilities abilities = player.getAbilities();
        boolean onGround = player.onGround();
        if (!onGround && abilities.flying) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }
}

