/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.tiles;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.ItemDamage;
import com.kotori316.infchest.common.tiles.HasInv;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TileDeque
extends BlockEntity
implements HasInv {
    public static final String NBT_ITEMS = "items";
    public static final int MAX_COUNT = 1000000;
    protected LinkedList<ItemStack> inventory = new LinkedList();

    public TileDeque(BlockPos pos, BlockState state) {
        super(InfChest.accessor.DEQUE_TYPE(), pos, state);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.inventory = valueInput.listOrEmpty(NBT_ITEMS, ItemStack.OPTIONAL_CODEC).stream().filter(Predicate.not(ItemStack::isEmpty)).collect(Collectors.toCollection(LinkedList::new));
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        ValueOutput.TypedOutputList list = valueOutput.list(NBT_ITEMS, ItemStack.OPTIONAL_CODEC);
        this.inventory.stream().filter(Predicate.not(ItemStack::isEmpty)).forEach(arg_0 -> ((ValueOutput.TypedOutputList)list).add(arg_0));
        super.saveAdditional(valueOutput);
    }

    @Override
    public int getContainerSize() {
        return Math.min(this.inventory.size() + 1, 1000000);
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    @Override
    public ItemStack getItem(int index) {
        if (index == 0 || index > this.inventory.size()) {
            return ItemStack.EMPTY;
        }
        return this.inventory.get(index - 1);
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.inventory, (int)(index - 1), (int)count);
    }

    @Override
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.inventory, (int)(index - 1));
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        if (0 < index && index <= this.inventory.size()) {
            this.inventory.set(index - 1, stack);
        } else if (index == 0) {
            this.inventory.add(stack);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.inventory = this.inventory.stream().filter(Predicate.not(ItemStack::isEmpty)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public void clearContent() {
        this.inventory.clear();
    }

    public NonNullList<ItemStack> itemsList() {
        return this.inventory.stream().collect(Collectors.groupingBy(ItemDamage::new, Collectors.summingLong(ItemStack::getCount))).entrySet().stream().flatMap(e -> ((ItemDamage)e.getKey()).toStacks((Long)e.getValue())).collect(Collectors.toCollection(NonNullList::create));
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, this.itemsList());
        }
    }
}

