/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.packets;

import com.kotori316.infchest.common.tiles.TileInfChest;
import java.math.BigInteger;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ItemCountMessage(BlockPos pos, ResourceKey<Level> dim, byte[] bytes, ItemStack out, ItemStack holding) implements CustomPacketPayload
{
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"infchest", (String)"item_count_message");
    public static final CustomPacketPayload.Type<ItemCountMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemCountMessage> STREAM_CODEC = CustomPacketPayload.codec(ItemCountMessage::write, ItemCountMessage::new);

    public ItemCountMessage(TileInfChest chest, BigInteger integer) {
        this(chest.getBlockPos(), (ResourceKey<Level>)Optional.ofNullable(chest.getLevel()).map(Level::dimension).orElse(Level.OVERWORLD), integer.toByteArray(), chest.getItem(1), chest.getHoldingWithOneCount());
    }

    public <T extends FriendlyByteBuf> ItemCountMessage(T p) {
        this(p.readBlockPos(), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)p.readResourceLocation()), p.readByteArray(), (ItemStack)p.readLenientJsonWithCodec(ItemStack.OPTIONAL_CODEC), (ItemStack)p.readLenientJsonWithCodec(ItemStack.OPTIONAL_CODEC));
    }

    <T extends FriendlyByteBuf> void write(T p) {
        p.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        p.writeByteArray(this.bytes);
        p.writeJsonWithCodec(ItemStack.OPTIONAL_CODEC, (Object)this.out);
        p.writeJsonWithCodec(ItemStack.OPTIONAL_CODEC, (Object)this.holding);
    }

    public CustomPacketPayload.Type<ItemCountMessage> type() {
        return TYPE;
    }

    public void onReceive(Level level) {
        BlockEntity entity = level.getBlockEntity(this.pos());
        if (level.dimension().equals(this.dim()) && entity instanceof TileInfChest) {
            TileInfChest chest = (TileInfChest)entity;
            chest.setCount(new BigInteger(this.bytes()));
            chest.setItem(1, this.out());
            chest.setHolding(this.holding());
        }
    }
}

