/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.infchest.common.blocks;

import com.kotori316.infchest.common.InfChest;
import com.kotori316.infchest.common.blocks.BlockInfChest;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import org.jetbrains.annotations.Nullable;

final class ItemInfChest
extends BlockItem {
    ItemInfChest(BlockInfChest block) {
        super((Block)block, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infchest", (String)"infchest"))).useBlockDescriptionPrefix());
    }

    public InteractionResult useOn(UseOnContext context) {
        if (Optional.ofNullable(context.getPlayer()).map(Player::isCreative).orElse(Boolean.FALSE).booleanValue()) {
            int size = context.getItemInHand().getCount();
            InteractionResult result = super.useOn(context);
            context.getItemInHand().setCount(size);
            return result;
        }
        return super.useOn(context);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level world, @Nullable Player player, ItemStack stack, BlockState state) {
        if (world.getServer() != null) {
            CompoundTag tag = Optional.ofNullable((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).map(CustomData::copyTag).orElse(null);
            BlockEntity entity = world.getBlockEntity(pos);
            if (tag != null && entity != null && (world.isClientSide || !entity.getType().onlyOpCanSetNbt() || player != null && player.canUseGameMasterBlocks())) {
                CompoundTag tileNbt = entity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
                tileNbt.merge(tag);
                tileNbt.putInt("x", pos.getX());
                tileNbt.putInt("y", pos.getY());
                tileNbt.putInt("z", pos.getZ());
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(entity.problemPath(), InfChest.LOGGER);){
                    entity.loadCustomOnly(TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)tileNbt));
                }
                entity.setChanged();
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack chestStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flagIn) {
        super.appendHoverText(chestStack, context, tooltipDisplay, consumer, flagIn);
        CompoundTag n = Optional.ofNullable((CustomData)chestStack.get(DataComponents.BLOCK_ENTITY_DATA)).map(CustomData::copyTag).orElse(null);
        HolderLookup.Provider registry = context.registries();
        if (n != null && registry != null) {
            Optional<ItemStack> stack = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)n.getCompoundOrEmpty("item")).result().filter(Predicate.not(ItemStack::isEmpty));
            stack.map(ItemStack::getItem).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ResourceLocation::toString).map(Component::literal).ifPresent(consumer);
            stack.map(ItemStack::getDisplayName).ifPresent(consumer);
            n.getString("count").filter(Predicate.not(String::isEmpty)).map(ItemInfChest::addPostfix).ifPresent(consumer);
        }
    }

    private static Component addPostfix(String s) {
        return Component.literal((String)(s + " items"));
    }
}

